/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.symbol;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.query.eval.ExpressionEvaluator;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.List;
import java.util.Map;

public class Reference
implements Expression {
    private int refIndex;
    private Class typeHint;
    private Expression expression;
    private boolean correlated;
    private transient Map elements;
    private transient List tuple;

    public Reference(int refIndex) {
        this.refIndex = refIndex;
    }

    public Reference(int refIndex, Expression expression) {
        this.refIndex = refIndex;
        this.expression = expression;
    }

    public boolean isResolved() {
        return this.expression != null;
    }

    public int getIndex() {
        return this.refIndex;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Class getType() {
        if (this.expression == null) {
            return null;
        }
        return this.expression.getType();
    }

    public Class getTypeHint() {
        return this.typeHint;
    }

    public void setTypeHint(Class typeHint) {
        this.typeHint = typeHint;
    }

    public void setData(Map elements, List tuple) {
        this.elements = elements;
        this.tuple = tuple;
    }

    public Map getDataElements() {
        return this.elements;
    }

    public List getTuple() {
        return this.tuple;
    }

    public Object getValue() throws ExpressionEvaluationException, MetaMatrixComponentException {
        return ExpressionEvaluator.evaluate((Expression)this.expression, (Map)this.elements, (List)this.tuple);
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        Reference other = (Reference)obj;
        return other.getIndex() == this.getIndex();
    }

    public int hashCode() {
        return this.getIndex();
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean isCorrelated() {
        return this.correlated;
    }

    public void setCorrelated(boolean correlated) {
        this.correlated = correlated;
    }
}

