/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml.vdb;

import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.xml.CoreXmlPlugin;
import com.metamatrix.internal.core.xml.vdb.TerminatingVdbHeaderContentHandler;
import com.metamatrix.internal.core.xml.vdb.VdbHeader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class VdbHeaderReader {
    private static final String XML_DECLARATION_PREFIX_STRING = "<?xml version=";
    private static final String VDB_FILE_EXTENSION = ".vdb";
    private static final String MANIFEST_MODEL_NAME = "MetaMatrix-VdbManifestModel.xmi";
    private static final String LOWER_CASE_MANIFEST_MODEL_NAME = "MetaMatrix-VdbManifestModel.xmi".toLowerCase();
    static /* synthetic */ Class class$com$metamatrix$internal$core$xml$vdb$VdbHeaderReader;

    /*
     * Loose catch block
     */
    public static VdbHeader readHeader(File file) throws MetaMatrixCoreException {
        block22: {
            String lowerCaseFileName;
            block23: {
                VdbHeader header;
                block24: {
                    InputStream iStream;
                    ZipFile zipFile;
                    block21: {
                        block18: {
                            VdbHeader vdbHeader;
                            block19: {
                                if (file == null || !file.isFile() || !file.exists() || file.length() <= 0L) break block22;
                                lowerCaseFileName = file.getName().toLowerCase();
                                if (!lowerCaseFileName.endsWith(VDB_FILE_EXTENSION)) break block23;
                                zipFile = null;
                                iStream = null;
                                header = null;
                                zipFile = new ZipFile(file);
                                iStream = VdbHeaderReader.getManifestStreamFromVdbArchive(zipFile);
                                if (iStream != null) break block18;
                                vdbHeader = null;
                                Object var7_9 = null;
                                if (iStream == null) break block19;
                                try {
                                    iStream.close();
                                }
                                catch (IOException err) {
                                    // empty catch block
                                }
                            }
                            if (zipFile != null) {
                                try {
                                    zipFile.close();
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                            }
                            return vdbHeader;
                        }
                        VdbHeaderReader reader = new VdbHeaderReader();
                        header = reader.read(iStream);
                        Object var7_10 = null;
                        if (iStream == null) break block21;
                        try {
                            iStream.close();
                        }
                        catch (IOException err) {
                            // empty catch block
                        }
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException e) {}
                    }
                    break block24;
                    {
                        catch (IOException e) {
                            throw new MetaMatrixRuntimeException((Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        if (iStream != null) {
                            try {
                                iStream.close();
                            }
                            catch (IOException err) {
                                // empty catch block
                            }
                        }
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                return header;
            }
            if (LOWER_CASE_MANIFEST_MODEL_NAME.equals(lowerCaseFileName)) {
                VdbHeaderReader reader = new VdbHeaderReader();
                return reader.read(file);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private VdbHeader read(InputStream istream) throws MetaMatrixCoreException {
        if (istream == null) {
            String msg = CoreXmlPlugin.Util.getString("VdbHeaderReader.The_InputStream_reference_may_not_be_null._1");
            throw new IllegalArgumentException(msg);
        }
        TerminatingVdbHeaderContentHandler handler = null;
        try {
            handler = new TerminatingVdbHeaderContentHandler();
            Thread.currentThread().setContextClassLoader((class$com$metamatrix$internal$core$xml$vdb$VdbHeaderReader == null ? (class$com$metamatrix$internal$core$xml$vdb$VdbHeaderReader = VdbHeaderReader.class$("com.metamatrix.internal.core.xml.vdb.VdbHeaderReader")) : class$com$metamatrix$internal$core$xml$vdb$VdbHeaderReader).getClassLoader());
            SAXParser parser = new SAXParser();
            parser.setContentHandler((ContentHandler)handler);
            parser.parse(new InputSource(istream));
            return handler.getVdbHeader();
        }
        catch (SAXException e) {
            if (!"HeaderFoundException".equals(e.getMessage()) && !"XMINotFoundException".equals(e.getMessage()) && !(e instanceof SAXParseException)) return handler.getVdbHeader();
        }
        catch (IOException e) {
            return handler.getVdbHeader();
        }
        catch (Throwable e) {
            String msg = CoreXmlPlugin.Util.getString("VdbHeaderReader.Error_in_parsing_file_1");
            throw new MetaMatrixCoreException(e, msg);
        }
        return handler.getVdbHeader();
    }

    /*
     * Loose catch block
     */
    public VdbHeader read(File file) throws MetaMatrixCoreException {
        IOException e22;
        VdbHeader vdbHeader;
        BufferedInputStream bis;
        FileInputStream fis;
        block16: {
            if (file == null) {
                String msg = CoreXmlPlugin.Util.getString("VdbHeaderReader.The_file_reference_may_not_be_null_2");
                throw new IllegalArgumentException(msg);
            }
            if (!file.exists()) {
                Object[] params = new Object[]{file};
                String msg = CoreXmlPlugin.Util.getString("VdbHeaderReader.The_file_0_does_not_exist_and_therefore_cannot_be_read._3", params);
                throw new IllegalArgumentException(msg);
            }
            if (!file.canRead()) {
                Object[] params = new Object[]{file};
                String msg = CoreXmlPlugin.Util.getString("VdbHeaderReader.The_file_0_does_not_have_read_privileges._4", params);
                throw new IllegalArgumentException(msg);
            }
            if (!VdbHeaderReader.isXmlFile(file)) {
                return null;
            }
            fis = null;
            bis = null;
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            vdbHeader = this.read(bis);
            Object var7_11 = null;
            if (bis == null) break block16;
            try {
                bis.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e22) {
                // empty catch block
            }
        }
        return vdbHeader;
        catch (FileNotFoundException e3) {
            try {
                String msg = CoreXmlPlugin.Util.getString("VdbHeaderReader.Error_in_parsing_file_1");
                throw new MetaMatrixCoreException((Throwable)e3, msg);
            }
            catch (Throwable throwable) {
                block18: {
                    IOException e22;
                    Object var7_12 = null;
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e22) {
                            // empty catch block
                        }
                    }
                    if (fis == null) break block18;
                    try {
                        fis.close();
                    }
                    catch (IOException e22) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isXmlFile(File file) {
        block11: {
            fis = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    buf = new byte[32];
                    fis.read(buf);
                    if (!new String(buf).startsWith("<?xml version=")) break block11;
                    var3_4 = true;
                    var5_5 = null;
                    if (fis == null) return var3_4;
                }
                catch (IOException var2_3) {
                    var5_7 = null;
                    if (fis == null) return false;
                    try {
                        fis.close();
                        return false;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
            }
            catch (Throwable var4_13) {
                var5_8 = null;
                if (fis == null) throw var4_13;
                ** try [egrp 2[TRYBLOCK] [5 : 72->79)] { 
lbl28:
                // 1 sources

                fis.close();
                throw var4_13;
lbl30:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                throw var4_13;
            }
            try {}
            catch (IOException e) {
                // empty catch block
                return var3_4;
            }
            fis.close();
            return var3_4;
        }
        var5_6 = null;
        if (fis == null) return false;
        try {}
        catch (IOException e) {}
        fis.close();
        return false;
        return false;
    }

    private static InputStream getManifestStreamFromVdbArchive(ZipFile zipFile) {
        return VdbHeaderReader.getEntryStreamFromArchive(zipFile, MANIFEST_MODEL_NAME);
    }

    private static InputStream getEntryStreamFromArchive(ZipFile zipFile, String zipEntryName) {
        ArgCheck.isNotNull((Object)zipFile);
        ArgCheck.isNotEmpty((String)zipEntryName);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry == null || !entry.getName().equalsIgnoreCase(zipEntryName)) continue;
                return zipFile.getInputStream(entry);
            }
        }
        catch (IOException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

