/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.commandshell;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.StringUtilities;
import java.util.ArrayList;
import java.util.List;

public class ScriptReader {
    public static String RESULT_KEYWORD = "result";
    private static final String LEFT_BRACE = "{";
    private static final String RIGHT_BRACE = "}";
    private String script;
    private String testName;
    private int testScriptIndex;
    private String testScript;
    private String[] testLines;

    public ScriptReader(String scripts) {
        this.script = scripts;
    }

    public void gotoScript(String scriptName) {
        this.testScriptIndex = 0;
        this.testName = scriptName;
        this.testScript = this.getScriptContents();
        this.testLines = StringUtilities.getLines(this.testScript);
    }

    public boolean hasMore() {
        this.checkGotoCalled();
        this.skipBlankLines();
        return this.testScriptIndex < this.testLines.length;
    }

    public String nextCommandLine() {
        this.checkGotoCalled();
        this.skipBlankLines();
        if (this.checkResults()) {
            this.getExpectedResults();
        }
        if (this.testScriptIndex < this.testLines.length) {
            String result = this.testLines[this.testScriptIndex].trim();
            ++this.testScriptIndex;
            return result;
        }
        return null;
    }

    private void checkGotoCalled() {
        if (this.testName == null) {
            String message = CorePlugin.Util.getString("ScriptReader.Call_goto_first");
            throw new MetaMatrixRuntimeException(message);
        }
    }

    private void skipBlankLines() {
        while (this.testScriptIndex < this.testLines.length && this.testLines[this.testScriptIndex].trim().length() == 0) {
            ++this.testScriptIndex;
        }
    }

    public boolean checkResults() {
        this.checkGotoCalled();
        this.skipBlankLines();
        return this.testScriptIndex < this.testLines.length && this.testLines[this.testScriptIndex].trim().startsWith(RESULT_KEYWORD);
    }

    public String getExpectedResults() {
        this.checkGotoCalled();
        if (!this.checkResults()) {
            return null;
        }
        ++this.testScriptIndex;
        StringBuffer result = new StringBuffer();
        while (!this.testLines[this.testScriptIndex].trim().equals("]")) {
            result.append(this.testLines[this.testScriptIndex]);
            result.append(StringUtil.LINE_SEPARATOR);
            ++this.testScriptIndex;
        }
        ++this.testScriptIndex;
        return result.toString();
    }

    private String getScriptContents() {
        boolean readyForNewScript = true;
        String[] scriptLines = StringUtilities.getLines(this.script);
        for (int i = 0; i < scriptLines.length; ++i) {
            if (readyForNewScript) {
                List subStrings;
                boolean openingBraceFound = false;
                if (scriptLines[i].indexOf(LEFT_BRACE) >= 0) {
                    openingBraceFound = true;
                }
                if ((subStrings = StringUtil.split(scriptLines[i], LEFT_BRACE)).size() < 1) continue;
                String name = (String)subStrings.get(0);
                if ((name = name.trim()).length() <= 0) continue;
                readyForNewScript = false;
                if (!name.equals(this.testName)) continue;
                if (!openingBraceFound) {
                    while (i < scriptLines.length && scriptLines[i].indexOf(LEFT_BRACE) < 0) {
                        ++i;
                    }
                }
                return this.readToEndOfScript(scriptLines, i + 1);
            }
            if (!scriptLines[i].trim().equals(RIGHT_BRACE)) continue;
            readyForNewScript = true;
        }
        Object[] params = new Object[]{this.testName};
        String message = CorePlugin.Util.getString("ScriptReader.Could_not_find_test_{0}", params);
        throw new MetaMatrixRuntimeException(message);
    }

    private String readToEndOfScript(String[] lines, int index) {
        StringBuffer result = new StringBuffer();
        for (int i = index; i < lines.length && !lines[i].trim().equals(RIGHT_BRACE); ++i) {
            result.append(lines[i]);
            result.append(StringUtil.LINE_SEPARATOR);
        }
        return result.toString();
    }

    public String[] getScriptNames() {
        ArrayList<String> result = new ArrayList<String>();
        List subStrings = StringUtil.split(this.script, LEFT_BRACE);
        for (int i = 0; i < subStrings.size() - 1; ++i) {
            String fragment = ((String)subStrings.get(i)).trim();
            String[] lines = StringUtilities.getLines(fragment);
            String testName = lines[lines.length - 1];
            if (this.containsWhitespace(testName) || testName.length() <= 0) continue;
            result.add(testName);
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean containsWhitespace(String text) {
        char[] chars = text.toCharArray();
        for (int j = 0; j < chars.length; ++j) {
            if (!Character.isWhitespace(chars[j])) continue;
            return true;
        }
        return false;
    }
}

