/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.interceptor;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.interceptor.Interceptor;
import com.metamatrix.core.interceptor.InterceptorStack;
import com.metamatrix.core.util.ArgCheck;

public class InterceptorStackImpl
implements InterceptorStack {
    private Interceptor firstInterceptor;

    public InterceptorStackImpl(Interceptor[] interceptors) {
        if (interceptors.length < 1) {
            String msg = CorePlugin.Util.getString("InterceptorStackImpl.Interceptor_array_cannot_be_empty_1");
            throw new IllegalArgumentException(msg);
        }
        this.firstInterceptor = interceptors[0];
        for (int i = 1; i < interceptors.length; ++i) {
            this.addInterceptorAfter(interceptors[i], interceptors[i - 1]);
        }
    }

    public InterceptorStackImpl(Interceptor firstInterceptor) {
        if (firstInterceptor == null) {
            String msg = CorePlugin.Util.getString("InterceptorStackImpl.The_reference_to_the_first_interceptor_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        this.firstInterceptor = firstInterceptor;
    }

    protected InterceptorStackImpl() {
    }

    public void addInterceptorAfter(Interceptor newInterceptor, Interceptor existingInterceptor) {
        if (newInterceptor == null) {
            String msg = CorePlugin.Util.getString("InterceptorStackImpl.New_Interceptor_may_not_be_null._1");
            throw new IllegalArgumentException(msg);
        }
        if (existingInterceptor == null) {
            String msg = CorePlugin.Util.getString("InterceptorStackImpl.Existing_Interceptor_may_not_be_null._2");
            throw new IllegalArgumentException(msg);
        }
        boolean existingInterceptorInStack = false;
        for (Interceptor currentInterceptor = this.firstInterceptor; currentInterceptor != null; currentInterceptor = currentInterceptor.next()) {
            if (newInterceptor == currentInterceptor) {
                String msg = CorePlugin.Util.getString("InterceptorStackImpl.not_same_interceptor");
                throw new IllegalArgumentException(msg);
            }
            if (existingInterceptor != currentInterceptor) continue;
            existingInterceptorInStack = true;
        }
        if (!existingInterceptorInStack) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("InterceptorStackImpl.Existing_firstInterceptor_must_already_exist_in_firstInterceptor_stack._7"));
        }
        Interceptor nextInterceptor = existingInterceptor.next();
        existingInterceptor.setNext(newInterceptor);
        if (nextInterceptor != null) {
            newInterceptor.setNext(nextInterceptor);
        }
    }

    public void addInterceptorBefore(Interceptor newInterceptor, Interceptor existingInterceptor) {
        if (newInterceptor == null) {
            String msg = CorePlugin.Util.getString("InterceptorStackImpl.New_Interceptor_may_not_be_null._1");
            throw new IllegalArgumentException(msg);
        }
        if (existingInterceptor == null) {
            String msg = CorePlugin.Util.getString("InterceptorStackImpl.Existing_Interceptor_may_not_be_null._2");
            throw new IllegalArgumentException(msg);
        }
        boolean existingInterceptorInStack = false;
        Interceptor prevInterceptor = null;
        for (Interceptor currentInterceptor = this.firstInterceptor; currentInterceptor != null; currentInterceptor = currentInterceptor.next()) {
            if (newInterceptor == currentInterceptor) {
                String msg = CorePlugin.Util.getString("InterceptorStackImpl.not_same_interceptor");
                throw new IllegalArgumentException(msg);
            }
            if (existingInterceptor == currentInterceptor) {
                existingInterceptorInStack = true;
                continue;
            }
            if (existingInterceptorInStack) continue;
            prevInterceptor = currentInterceptor;
        }
        if (!existingInterceptorInStack) {
            throw new IllegalArgumentException(CorePlugin.Util.getString("InterceptorStackImpl.Existing_interceptor_was_not_found_in_interceptor_stack._13"));
        }
        newInterceptor.setNext(existingInterceptor);
        if (prevInterceptor == null) {
            this.firstInterceptor = newInterceptor;
        } else {
            prevInterceptor.setNext(newInterceptor);
        }
    }

    public Interceptor getFirstInterceptor() {
        return this.firstInterceptor;
    }

    protected void setFirstInterceptor(Interceptor firstInterceptor) {
        this.firstInterceptor = firstInterceptor;
    }

    public boolean removeInterceptor(Interceptor interceptor) {
        ArgCheck.isNotNull(interceptor);
        Interceptor prevInterceptor = null;
        for (Interceptor currentInterceptor = this.getFirstInterceptor(); currentInterceptor != null; currentInterceptor = currentInterceptor.next()) {
            if (currentInterceptor != interceptor) continue;
            if (prevInterceptor == null) {
                this.firstInterceptor = interceptor.next();
            } else {
                prevInterceptor.setNext(interceptor.next());
            }
            return true;
        }
        return false;
    }
}

