/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.util.ArgCheck;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.Status;

public class ClassLoaderUtil {
    private static final Class[] EMPTY_ARGUMENT_LIST = new Class[0];
    private final URLClassLoader loader;
    private final List problems;

    public ClassLoaderUtil(URLClassLoader loader) {
        ArgCheck.isNotNull(loader);
        this.loader = loader;
        this.problems = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Class[] getAssignableClasses(Class[] types) {
        if (types == null) {
            String msg = CorePlugin.Util.getString("ClassLoaderUtil.The_Class[]_of_types_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        if (types.length == 0) {
            return new Class[0];
        }
        for (int j = 0; j < types.length; ++j) {
            if (types[j] != null) continue;
            String msg = CorePlugin.Util.getString("ClassLoaderUtil.The_Class[]_of_types_may_not_contain_null_references");
            throw new IllegalArgumentException(msg);
        }
        ArrayList classes = new ArrayList();
        URL[] urls = this.loader.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            InputStream stream = null;
            stream = url.openStream();
            if (stream != null) {
                ZipEntry entry;
                ZipInputStream zipStream = null;
                zipStream = new ZipInputStream(stream);
                block12: while ((entry = zipStream.getNextEntry()) != null) {
                    String className = ClassLoaderUtil.changeFileNameToClassName(entry.getName());
                    if (className == null) continue;
                    Class<?> cls = null;
                    try {
                        cls = this.loader.loadClass(className);
                    }
                    catch (Throwable th) {
                        Object[] params = new Object[]{className, url};
                        String msg = CorePlugin.Util.getString("ClassLoaderUtil.Error_trying_to_load_class_from_file") + params;
                        Status error = new Status(2, "com.metamatrix.core", 0, msg, th);
                        this.problems.add(error);
                    }
                    if (cls == null) continue;
                    for (int j = 0; j < types.length; ++j) {
                        if (!types[j].isAssignableFrom(cls)) continue;
                        classes.add(cls);
                        continue block12;
                    }
                }
            }
            Object var16_20 = null;
            if (stream == null) continue;
            try {
                stream.close();
            }
            catch (IOException e1) {}
            continue;
            {
                catch (IOException e) {
                    Object[] params = new Object[]{url};
                    String msg = CorePlugin.Util.getString("ClassLoaderUtil.Error_trying_to_load_file", params);
                    Status error = new Status(4, "com.metamatrix.core", 0, msg, (Throwable)e);
                    this.problems.add(error);
                    var16_20 = null;
                    if (stream == null) continue;
                    try {
                        stream.close();
                    }
                    catch (IOException e1) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var16_20 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e1) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public Class[] getAssignableClasses(Class type) {
        return this.getAssignableClasses(new Class[]{type});
    }

    public Class[] getAssignablePublicClassesWithNoArgConstructors(Class[] types) {
        Class[] assignableClasses = this.getAssignableClasses(types);
        ArrayList<Class> classes = new ArrayList<Class>();
        for (int i = 0; i < assignableClasses.length; ++i) {
            Class clazz = assignableClasses[i];
            if (clazz.isInterface() || this.isAbstract(clazz) || !this.isPublic(clazz) || !this.hasAZeroArgConstructor(clazz)) continue;
            classes.add(clazz);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public Class[] getAssignablePublicClassesWithNoArgConstructors(Class type) {
        return this.getAssignablePublicClassesWithNoArgConstructors(new Class[]{type});
    }

    protected boolean isAbstract(Class clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    protected boolean isPublic(Class clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    protected boolean hasAZeroArgConstructor(Class clazz) {
        try {
            Constructor noArgConstructor = clazz.getConstructor(EMPTY_ARGUMENT_LIST);
            return noArgConstructor != null;
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public static String changeFileNameToClassName(String name) {
        if (name == null) {
            String msg = CorePlugin.Util.getString("ClassLoaderUtil.The_name_of_the_class_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        String className = null;
        if (name.toLowerCase().endsWith(".class")) {
            className = name.replace('/', '.');
            className = className.replace('\\', '.');
            className = className.substring(0, className.length() - 6);
        }
        return className;
    }

    public boolean hasProblems() {
        return this.problems.size() != 0;
    }

    public List getProblems() {
        return this.problems;
    }

    public void clearProblems() {
        this.problems.clear();
    }

    public URLClassLoader getClassLoader() {
        return this.loader;
    }

    public static String getClassLoaderInformation(ClassLoader classLoader, String label) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(byteStream);
        stream.println("START CLASS LOADERS - " + label);
        ClassLoaderUtil.getClassPathRecursively(classLoader, stream);
        stream.println("END CLASS LOADERS - " + label);
        stream.flush();
        return byteStream.toString();
    }

    private static void getClassPathRecursively(ClassLoader classLoader, PrintStream stream) {
        ClassLoaderUtil.getClassPath(classLoader, stream);
        if (classLoader.getParent() != null) {
            ClassLoaderUtil.getClassPathRecursively(classLoader.getParent(), stream);
        }
    }

    private static void getClassPath(ClassLoader classLoader, PrintStream stream) {
        stream.println("ClassLoader: " + classLoader);
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            URL[] urls = urlClassLoader.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                stream.println(urls[i].toString());
            }
        }
    }
}

