/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.util.FileUtils;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class ClassUtil {
    private static final String PLUGINS_FOLDER = "plugins";

    public static String getProjectName(Class clazz) {
        String path = ClassUtil.getProjectPath(clazz);
        return path == null ? null : new Path(path).lastSegment();
    }

    public static String getProjectPath(Class clazz) {
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        Path path = new Path(url.getPath());
        IPath parent = path.removeLastSegments(1);
        while (parent.segmentCount() > 0 && !PLUGINS_FOLDER.equalsIgnoreCase(parent.lastSegment())) {
            path = parent;
            parent = path.removeLastSegments(1);
        }
        return parent.segmentCount() > 0 ? path.toString() : null;
    }

    public static String getSimpleClassName(Class clazz) {
        if (clazz == null) {
            String msg = CorePlugin.Util.getString("ClassUtil.The_Class_reference_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        String name = clazz.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static String getSimpleClassName(Object object) {
        if (object == null) {
            String msg = CorePlugin.Util.getString("ClassUtil.The_instance_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        return ClassUtil.getSimpleClassName(object.getClass());
    }

    private ClassUtil() {
    }

    public static interface Constants
    extends FileUtils.Constants {
        public static final String JAR_EXTENSION = FileUtils.Constants.FILE_EXTENSION_SEPARATOR + "jar";
        public static final String ZIP_EXTENSION = FileUtils.Constants.FILE_EXTENSION_SEPARATOR + "zip";
        public static final String CLASS_EXTENSION = FileUtils.Constants.FILE_EXTENSION_SEPARATOR + "class";
        public static final String LIBRARY_FILTER = FileUtils.Constants.FILE_NAME_WILDCARD + JAR_EXTENSION + "; " + FileUtils.Constants.FILE_NAME_WILDCARD + ZIP_EXTENSION;
        public static final String PACKAGE_SEPARATOR = ".";
        public static final String INNER_CLASS_SEPARATOR = "$";
        public static final char PACKAGE_SEPARATOR_CHAR = '.';
        public static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    }
}

