/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.util;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.core.util.Debugger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class DebuggerImpl
implements ClassUtil.Constants,
Debugger,
Debugger.Constants {
    private static final String I18N_PREFIX = "DebuggerImpl.";
    private static final String CONFLICT_WARNING = "DebuggerImpl.conflictWarning";
    static final String MESSAGE_SEPARATOR = ": ";
    static final char HASHCODE_SEPARATOR = '@';
    private static final String ENTERED_MESSAGE_PREFIX = "Entered ";
    private static final String EXITED_MESSAGE_PREFIX = "Exited ";
    private static final DateFormat TIMESTAMPER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static final Map INDENTS = new HashMap(0);
    private static final String INDENT = "  ";
    static Properties props;
    static Map propDescs;
    static Map propVals;
    static boolean debugEnabled;
    static boolean traceEnabled;
    static boolean printThread;
    static boolean printTimestamp;
    static boolean indentMsg;
    static String output;
    private String pluginId;
    private Map timerIdStartMap;

    public static void loadProperties() {
        Properties installProps = new Properties();
        HashMap<String, String> propPlugins = new HashMap<String, String>();
        HashMap<String, String> newPropDescs = new HashMap<String, String>();
        HashMap<String, String> newPropVals = new HashMap<String, String>();
        Bundle[] bundles = CorePlugin.getDefault().getBundleContext().getBundles();
        int bundleNdx = bundles.length;
        while (--bundleNdx >= 0) {
            Bundle bundle = bundles[bundleNdx];
            String pluginId = bundle.getSymbolicName();
            try {
                URL url = bundle.getEntry(Debugger.Constants.FILENAME);
                File file = url == null ? null : new File(Platform.resolve((URL)url).getFile());
                if (file == null || !file.exists()) continue;
                Properties props = new Properties();
                props.load(file.toURL().openStream());
                Iterator<Map.Entry<Object, Object>> iter = props.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Object, Object> entry = iter.next();
                    String key = (String)entry.getKey();
                    String val = (String)entry.getValue();
                    if (key.endsWith("$description")) {
                        newPropDescs.put(DebuggerImpl.getStoredKey(key.substring(0, key.length() - "$description".length())), val);
                        continue;
                    }
                    if (key.endsWith("$values")) {
                        newPropVals.put(DebuggerImpl.getStoredKey(key.substring(0, key.length() - "$values".length())), val);
                        continue;
                    }
                    if ("$traceFilters".equals(key)) {
                        installProps.put(key, val);
                        continue;
                    }
                    if (installProps.containsKey(key)) {
                        CorePlugin.Util.log(2, CorePlugin.Util.getString(CONFLICT_WARNING, key, pluginId, propPlugins.get(key)));
                        continue;
                    }
                    installProps.put(DebuggerImpl.getStoredKey(key), val);
                    propPlugins.put(key, pluginId);
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException err) {
                CorePlugin.Util.log(err);
            }
        }
        Properties newProps = new Properties(installProps);
        newProps.putAll((Map<?, ?>)installProps);
        File file = DebuggerImpl.getDebugFile();
        if (file.exists()) {
            try {
                newProps.load(file.toURL().openStream());
                Iterator<Map.Entry<Object, Object>> iter = newProps.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Object, Object> entry = iter.next();
                    String key = (String)entry.getKey();
                    if (key.startsWith(Debugger.Constants.TRACE_CLASSES_PREFIX) || installProps.containsKey(key)) continue;
                    iter.remove();
                }
            }
            catch (IOException err) {
                CorePlugin.Util.log(err);
            }
        }
        debugEnabled = Boolean.valueOf(newProps.getProperty("debugEnabled"));
        traceEnabled = Boolean.valueOf(newProps.getProperty("tracing"));
        output = newProps.getProperty(Debugger.Constants.OUTPUT_DESTINATION_PROPERTY, "System.out");
        printThread = Boolean.valueOf(newProps.getProperty(Debugger.Constants.PRINT_THREAD_PROPERTY));
        printTimestamp = Boolean.valueOf(newProps.getProperty(Debugger.Constants.PRINT_TIMESTAMP_PROPERTY));
        indentMsg = Boolean.valueOf(newProps.getProperty(Debugger.Constants.INDENT_MESSAGE_PROPERTY));
        props = newProps;
        propDescs = newPropDescs;
        propVals = newPropVals;
    }

    private static File getDebugFile() {
        Bundle plugin = Platform.getBundle((String)"com.metamatrix.core");
        IPath path = Platform.getStateLocation((Bundle)plugin).append(Debugger.Constants.FILENAME);
        File file = path.toFile();
        return file;
    }

    private static void ensurePropertiesLoaded() {
        if (props == null || props.isEmpty()) {
            DebuggerImpl.loadProperties();
        }
    }

    private static Properties getProperties() {
        DebuggerImpl.ensurePropertiesLoaded();
        return props;
    }

    private static String getStoredKey(String key) {
        if (key.startsWith("$")) {
            StringBuffer buf = new StringBuffer(key.length());
            StringTokenizer iter = new StringTokenizer(key, "$");
            while (iter.hasMoreTokens()) {
                buf.append(iter.nextToken());
            }
            return buf.toString();
        }
        return Debugger.Constants.CONTEXTS_PREFIX + key;
    }

    private static boolean isPropertyEnabledRecursively(String name) {
        int ndx = name.lastIndexOf(Debugger.Constants.SEPARATOR);
        if (ndx > 0 && !DebuggerImpl.isPropertyEnabledRecursively(name.substring(0, ndx))) {
            return false;
        }
        return DebuggerImpl.isPropertyTrue(name);
    }

    public static String getProperty(String name) {
        if (name == null) {
            return "";
        }
        return DebuggerImpl.getProperties().getProperty(name);
    }

    public static String getPropertyDescription(String name) {
        if (name == null) {
            return "";
        }
        DebuggerImpl.ensurePropertiesLoaded();
        return (String)propDescs.get(name);
    }

    public static String getPropertyValues(String name) {
        if (name == null) {
            return "";
        }
        DebuggerImpl.ensurePropertiesLoaded();
        return (String)propVals.get(name);
    }

    public static Iterator getPropertyIterator() {
        return DebuggerImpl.getProperties().entrySet().iterator();
    }

    public static void setProperty(String name, String value) {
        if (name == null) {
            String msg = CorePlugin.Util.getString("DebuggerImpl.The_name_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = CorePlugin.Util.getString("DebuggerImpl.The_value_may_not_be_null");
            throw new IllegalArgumentException(msg);
        }
        DebuggerImpl.getProperties().setProperty(name, value);
        if ("debugEnabled".equals(name)) {
            debugEnabled = Boolean.valueOf(value);
        } else if ("tracing".equals(name)) {
            traceEnabled = Boolean.valueOf(value);
        } else if (Debugger.Constants.OUTPUT_DESTINATION_PROPERTY.equals(name)) {
            output = value == null ? "System.out" : value;
        } else if (Debugger.Constants.PRINT_THREAD_PROPERTY.equals(name)) {
            printThread = Boolean.valueOf(value);
        } else if (Debugger.Constants.PRINT_TIMESTAMP_PROPERTY.equals(name)) {
            printTimestamp = Boolean.valueOf(value);
        } else if (Debugger.Constants.INDENT_MESSAGE_PROPERTY.equals(name)) {
            indentMsg = Boolean.valueOf(value);
        }
    }

    public static boolean isPropertyBoolean(String name) {
        return DebuggerImpl.getPropertyValues(name) == null;
    }

    public static boolean isPropertyTrue(String name) {
        if (name == null) {
            return false;
        }
        return !DebuggerImpl.isPropertyBoolean(name) || Boolean.valueOf(DebuggerImpl.getProperty(name)) != false;
    }

    public static boolean isPropertyEnabled(String name) {
        if (name == null) {
            return false;
        }
        boolean isEnabled = false;
        try {
            DebuggerImpl.ensurePropertiesLoaded();
        }
        catch (RuntimeException e) {
            return isEnabled;
        }
        return debugEnabled && DebuggerImpl.isPropertyEnabledRecursively(name);
    }

    public static void saveProperties() throws IOException {
        Iterator iter = DebuggerImpl.getPropertyIterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(Debugger.Constants.TRACE_CLASSES_PREFIX) || Boolean.valueOf((String)entry.getValue()).booleanValue()) continue;
            iter.remove();
        }
        DebuggerImpl.getProperties().store(new FileOutputStream(DebuggerImpl.getDebugFile()), null);
    }

    DebuggerImpl(String id) {
        this.pluginId = id;
        this.timerIdStartMap = new HashMap();
    }

    public void debug(String context, String message) {
        if (this.isDebugEnabled(context)) {
            this.print(context, message);
        }
    }

    public String getDebugContextProperty(String property) {
        if (property == null) {
            return "";
        }
        return DebuggerImpl.getProperty(Debugger.Constants.CONTEXTS_PREFIX + property);
    }

    public String getTraceContextProperty(String property) {
        if (property == null) {
            return "";
        }
        return DebuggerImpl.getProperty(Debugger.Constants.TRACE_CONTEXTS_PREFIX + property);
    }

    public boolean isDebugEnabled(String context) {
        return DebuggerImpl.isPropertyEnabled(Debugger.Constants.CONTEXTS_PREFIX + context);
    }

    public boolean isTraceEnabled(String context) {
        return DebuggerImpl.isPropertyEnabled(Debugger.Constants.TRACE_CONTEXTS_PREFIX + context);
    }

    public boolean isTraceEnabled(Class clazz) {
        if (clazz == null) {
            return false;
        }
        return DebuggerImpl.isPropertyEnabled(Debugger.Constants.TRACE_CLASSES_PREFIX + this.pluginId + Debugger.Constants.SEPARATOR + clazz.getName().replace('.', '/'));
    }

    public boolean isTraceEnabled(Object object) {
        if (object == null) {
            return false;
        }
        return this.isTraceEnabled(object.getClass());
    }

    public void print(String context, String message) {
        this.print(this.format(context, message));
    }

    public void print(Class clazz, String message) {
        if (traceEnabled) {
            this.print(this.format(clazz, message));
        }
    }

    public void print(Object object, String message) {
        if (traceEnabled) {
            this.print(this.format(object, message));
        }
    }

    public void printEntered(String context, String message) {
        if (!traceEnabled) {
            return;
        }
        if (indentMsg) {
            Thread thread = Thread.currentThread();
            String indent = (String)INDENTS.get(thread);
            indent = indent == null ? "" : indent;
            this.print(indent + this.format(context, ENTERED_MESSAGE_PREFIX + message));
            INDENTS.put(thread, indent + INDENT);
        } else {
            this.print(context, message);
        }
    }

    public void printEntered(Class clazz, String message) {
        if (!traceEnabled) {
            return;
        }
        if (indentMsg) {
            Thread thread = Thread.currentThread();
            String indent = (String)INDENTS.get(thread);
            indent = indent == null ? "" : indent;
            this.print(indent + this.format(clazz, ENTERED_MESSAGE_PREFIX + message));
            INDENTS.put(thread, indent + INDENT);
        } else {
            this.print(clazz, message);
        }
    }

    public void printEntered(Object object, String message) {
        if (!traceEnabled) {
            return;
        }
        if (indentMsg) {
            Thread thread = Thread.currentThread();
            String indent = (String)INDENTS.get(thread);
            indent = indent == null ? "" : indent;
            this.print(indent + this.format(object, ENTERED_MESSAGE_PREFIX + message));
            INDENTS.put(thread, indent + INDENT);
        } else {
            this.print(object, message);
        }
    }

    public void printExited(String context, String message) {
        if (!traceEnabled) {
            return;
        }
        if (indentMsg) {
            Thread thread = Thread.currentThread();
            String indent = (String)INDENTS.get(thread);
            indent = indent == null ? "" : indent.substring(INDENT.length());
            this.print(indent + this.format(context, EXITED_MESSAGE_PREFIX + message));
            INDENTS.put(thread, indent);
        } else {
            this.print(context, message);
        }
    }

    public void printExited(Class clazz, String message) {
        if (!traceEnabled) {
            return;
        }
        if (indentMsg) {
            Thread thread = Thread.currentThread();
            String indent = (String)INDENTS.get(thread);
            indent = indent == null ? "" : indent.substring(INDENT.length());
            this.print(indent + this.format(clazz, EXITED_MESSAGE_PREFIX + message));
            INDENTS.put(thread, indent);
        } else {
            this.print(clazz, message);
        }
    }

    public void printExited(Object object, String message) {
        if (!traceEnabled) {
            return;
        }
        if (indentMsg) {
            Thread thread = Thread.currentThread();
            String indent = (String)INDENTS.get(thread);
            indent = indent == null ? "" : indent.substring(INDENT.length());
            this.print(indent + this.format(object, EXITED_MESSAGE_PREFIX + message));
            INDENTS.put(thread, indent);
        } else {
            this.print(object, message);
        }
    }

    public void start(String theContextId) {
        this.start(theContextId, theContextId);
    }

    public void start(String theTimerId, String theContextId) {
        this.start(theTimerId, theContextId, null);
    }

    public void start(String theTimerId, String theContextId, Object[] theInfo) {
        ArgCheck.isNotNull(theContextId);
        if (this.isDebugEnabled(theContextId)) {
            double startTime = System.currentTimeMillis();
            this.timerIdStartMap.put(theTimerId, new Double(startTime));
            CharSequence info = null;
            if (theInfo != null && theInfo.length > 0) {
                info = new StringBuffer();
                StringBuffer sb = (StringBuffer)info;
                for (int i = 0; i < theInfo.length; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(theInfo[i]);
                }
            } else {
                info = "";
            }
            this.print(CorePlugin.Util.getString("DebuggerImpl.timerStart", new Object[]{theTimerId, info}));
        }
    }

    public void stop(String theContextId) {
        this.stop(theContextId, theContextId);
    }

    public void stop(String theTimerId, String theContextId) {
        this.stop(theTimerId, theContextId, null);
    }

    public void stop(String theTimerId, String theContextId, Object[] theInfo) {
        ArgCheck.isNotNull(theContextId);
        if (this.isDebugEnabled(theContextId)) {
            Number startTime = (Number)this.timerIdStartMap.get(theTimerId);
            Object totalTime = null;
            CharSequence info = null;
            if (startTime == null) {
                totalTime = CorePlugin.Util.getString("DebuggerImpl.timerNotFound");
            } else {
                this.timerIdStartMap.remove(theContextId);
                totalTime = new Double((double)System.currentTimeMillis() - startTime.doubleValue());
                if (theInfo != null && theInfo.length > 0) {
                    info = new StringBuffer();
                    StringBuffer sb = (StringBuffer)info;
                    for (int i = 0; i < theInfo.length; ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append(theInfo[i]);
                    }
                } else {
                    info = "";
                }
            }
            this.print(CorePlugin.Util.getString("DebuggerImpl.timerStop", new Object[]{theTimerId, totalTime, info}));
        }
    }

    public void trace(String context, String message) {
        if (this.isTraceEnabled(context)) {
            this.print(this.format(context, message));
        }
    }

    public void trace(Class clazz, String message) {
        if (this.isTraceEnabled(clazz)) {
            this.print(this.format(clazz, message));
        }
    }

    public void trace(Object object, String message) {
        if (this.isTraceEnabled(object)) {
            this.print(this.format(object, message));
        }
    }

    public void traceEntered(String context, String message) {
        if (this.isTraceEnabled(context)) {
            this.printEntered(context, message);
        }
    }

    public void traceEntered(Class clazz, String message) {
        if (this.isTraceEnabled(clazz)) {
            this.printEntered(clazz, message);
        }
    }

    public void traceEntered(Object object, String message) {
        if (this.isTraceEnabled(object)) {
            this.printEntered(object, message);
        }
    }

    public void traceExited(String context, String message) {
        if (this.isTraceEnabled(context)) {
            this.printExited(context, message);
        }
    }

    public void traceExited(Class clazz, String message) {
        if (this.isTraceEnabled(clazz)) {
            this.printExited(clazz, message);
        }
    }

    public void traceExited(Object object, String message) {
        if (this.isTraceEnabled(object)) {
            this.printExited(object, message);
        }
    }

    String format(String context, String message) {
        return context + MESSAGE_SEPARATOR + message;
    }

    String format(Class clazz, String message) {
        if (clazz != null) {
            return this.format(clazz.getName(), message);
        }
        return this.format((String)null, message);
    }

    String format(Object object, String message) {
        if (object != null) {
            return this.format(object.getClass().getName() + '@' + object.hashCode(), message);
        }
        return this.format((String)null, message);
    }

    String format(String message) {
        if (printThread) {
            message = Thread.currentThread().toString() + MESSAGE_SEPARATOR + message;
        }
        if (printTimestamp) {
            message = TIMESTAMPER.format(TIMESTAMPER.getCalendar().getTime()) + MESSAGE_SEPARATOR + message;
        }
        return message;
    }

    private void print(String message) {
        PrintStream printer;
        boolean opened = false;
        if ("System.out".equals(output)) {
            printer = System.out;
        } else if ("System.err".equals(output)) {
            printer = System.err;
        } else {
            try {
                printer = new PrintStream(new FileOutputStream(output, true));
                opened = true;
            }
            catch (FileNotFoundException err) {
                printer = System.out;
                CorePlugin.Util.log(err);
            }
        }
        printer.println(this.format(message));
        if (opened) {
            printer.close();
        }
    }
}

