/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.event;

import com.metamatrix.core.event.IChangeListener;
import com.metamatrix.core.event.IChangeNotifier;
import com.metamatrix.core.util.Assertion;
import java.util.ArrayList;
import java.util.List;

public class ChangeNotifier
implements IChangeNotifier {
    private List listeners;

    public void addChangeListener(IChangeListener theListener) {
        Assertion.isNotNull(theListener);
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(theListener)) {
            this.listeners.add(theListener);
        }
    }

    public void fireStateChanged(IChangeNotifier theSource) {
        if (this.listeners != null) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                ((IChangeListener)this.listeners.get(i)).stateChanged(theSource);
            }
        }
    }

    public void removeChangeListener(IChangeListener theListener) {
        Assertion.isNotNull(theListener);
        if (this.listeners != null) {
            this.listeners.remove(theListener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }
}

