/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.helper;

import com.metamatrix.soap.helper.SOAPException;
import java.sql.Connection;
import java.sql.SQLException;

public class SOAPConnection {
    private static final String SESSION_ID_PREFIX = "MMSOAPSESSION_";
    private static long sessionNum = 1L;
    private long lastAccessTime = System.currentTimeMillis();
    private Connection connection;
    private String sessionID;
    private boolean isAnonymous;

    public SOAPConnection(Connection connection, boolean isAnonymous) throws SOAPException {
        this.connection = connection;
        this.isAnonymous = isAnonymous;
        this.sessionID = this.constructSessionID();
    }

    public void updateAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public Long getLastAccessTime() {
        return new Long(this.lastAccessTime);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void logoff() throws SQLException {
        Connection connection = this.getConnection();
        if (connection != null) {
            connection.close();
        }
    }

    private String constructSessionID() throws SOAPException {
        return SESSION_ID_PREFIX + Long.toString(SOAPConnection.getNextSessionNum());
    }

    private static synchronized long getNextSessionNum() {
        return sessionNum++;
    }
}

