/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.service;

import com.metamatrix.core.util.MetaMatrixExceptionUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.jdbc.api.SQLStates;
import com.metamatrix.soap.SOAPPlugin;
import com.metamatrix.soap.exceptions.SOAPProcessingException;
import com.metamatrix.soap.license.LicenseInfo;
import com.metamatrix.soap.service.ConnectionSource;
import com.metamatrix.soap.service.DataServiceInfo;
import com.metamatrix.soap.service.PoolingConnectionSource;
import com.metamatrix.soap.util.EndpointUriTranslatorStrategyImpl;
import com.metamatrix.soap.util.SystinetObjectUtil;
import com.systinet.saaj.soap.DefaultMessageFactory;
import com.systinet.saaj.soap.TextImpl;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.messaging.ReqRespListener;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.idoox.security.jaas.NamePasswordCredential;
import org.idoox.security.server.Current;
import org.idoox.security.server.ReceivedCredentials;
import org.idoox.util.RuntimeWrappedException;

public class DataServiceWebServiceImpl
implements ReqRespListener {
    public static final String SOAP_11_STANDARD_CLIENT_FAULT_CODE = "Client";
    public static final String SOAP_11_STANDARD_SERVER_FAULT_CODE = "Server";
    public static final String USER_NAME = "user";
    public static ConnectionSource connectionSource = new PoolingConnectionSource();
    public static final String PASSWORD = "password";
    public static final String ERROR_PREFIX = "Procedure error:";
    private static final boolean isLicensed = LicenseInfo.getInstance().isSOAPAPILicensed();
    private final MessageFactory factory;
    static /* synthetic */ Class class$org$idoox$security$jaas$NamePasswordCredential;

    public DataServiceWebServiceImpl() {
        this.factory = new DefaultMessageFactory();
    }

    public DataServiceWebServiceImpl(MessageFactory factory, ConnectionSource connectionSource) {
        this.factory = factory;
        DataServiceWebServiceImpl.connectionSource = connectionSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public SOAPMessage onMessage(SOAPMessage message) {
        block32: {
            if (!DataServiceWebServiceImpl.isLicensed) {
                return this.createSOAPFaultMessage(LicenseInfo.getErrorMessage(), "Server");
            }
            inputMessage = null;
            bodyElements = null;
            info = null;
            body = null;
            try {
                body = message.getSOAPPart().getEnvelope().getBody();
            }
            catch (SOAPException e3) {
                return this.createSOAPFaultMessage((Exception)e3, SOAPPlugin.Util.getString("DataServiceWebServiceImpl.11"), "Server");
            }
            try {
                info = this.getDataServiceInfo(message);
            }
            catch (SOAPProcessingException e2) {
                return this.createSOAPFaultMessage((Exception)e2, e2.getMessage(), "Server");
            }
            bodyElements = this.getBodyElements(body);
            if (bodyElements != null && bodyElements.size() == 1) {
                try {
                    inputMessage = SystinetObjectUtil.stringifySoapElement((SOAPElement)bodyElements.get(0));
                }
                catch (SOAPProcessingException e1) {
                    SOAPPlugin.Util.log(4, (Throwable)e1, e1.getMessage());
                    return this.createSOAPFaultMessage((Exception)e1, e1.getMessage(), "Server");
                }
            } else if (bodyElements.size() == 0) {
                text = this.getText(body);
                if (text != null) {
                    inputMessage = text.getValue();
                }
            } else if (bodyElements.size() > 1) {
                return this.createSOAPFaultMessage(SOAPPlugin.Util.getString("DataServiceWebServiceImpl.10"), "Client");
            }
            connection = null;
            connection = this.getConnection(info);
            if (inputMessage == null || StringUtil.isEmpty((String)inputMessage)) {
                executeStatement = "{?=call " + info.getDataServiceFullPath() + "()}";
                statement = connection.prepareCall(executeStatement);
            } else {
                executeStatement = "{?=call " + info.getDataServiceFullPath() + "(?)}";
                statement = connection.prepareCall(executeStatement);
                statement.setString(1, inputMessage);
            }
            statement.setQueryTimeout(this.getQueryTimeout());
            hasResultSet = statement.execute();
            returnMessage = new DefaultMessageFactory().createMessage();
            if (!hasResultSet) ** GOTO lbl66
            returnFragment /* !! */  = null;
            set = statement.getResultSet();
            if (set.next()) {
                returnFragment /* !! */  = set.getString(1);
            }
            if (!set.next()) break block32;
            params = new String[]{info.getDataServiceFullPath()};
            var13_19 = this.createSOAPFaultMessage(SOAPPlugin.Util.getString("DataServiceWebServiceImpl.5", params), "Server");
            var15_20 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                SOAPPlugin.Util.log(2, (Throwable)e, SOAPPlugin.Util.getString("DataServiceWebServiceImpl.15"));
            }
            return var13_19;
        }
        SystinetObjectUtil.addXMLFragmentToBody(returnMessage, (String)returnFragment /* !! */ );
lbl66:
        // 2 sources

        returnFragment /* !! */  = returnMessage;
        var15_21 = null;
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            SOAPPlugin.Util.log(2, (Throwable)e, SOAPPlugin.Util.getString("DataServiceWebServiceImpl.15"));
        }
        return returnFragment /* !! */ ;
        catch (Exception e) {
            try {
                faultcode = "Server";
                if (e instanceof SQLException && SQLStates.isUsageErrorState((String)(sqlException = (SQLException)e).getSQLState())) {
                    faultcode = "Client";
                }
                exceptions = MetaMatrixExceptionUtil.getChildrenIterator((Throwable)e);
                display = new StringBuffer(e.getMessage());
                while (exceptions.hasNext()) {
                    exc = (Throwable)exceptions.next();
                    display.append("\n").append(exc.getMessage());
                }
                var11_17 = this.createSOAPFaultMessage(e, display.toString(), faultcode);
                var15_22 = null;
            }
            catch (Throwable var14_28) {
                var15_23 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    SOAPPlugin.Util.log(2, (Throwable)e, SOAPPlugin.Util.getString("DataServiceWebServiceImpl.15"));
                }
                throw var14_28;
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                SOAPPlugin.Util.log(2, (Throwable)e, SOAPPlugin.Util.getString("DataServiceWebServiceImpl.15"));
            }
            return var11_17;
        }
    }

    protected Connection getConnection(DataServiceInfo info) throws SOAPException {
        Properties connectionProperties = new Properties();
        String password = null;
        String username = null;
        Current current = Current.getInstance();
        ReceivedCredentials creds = current.getReceivedCredentials();
        if (creds == null) {
            throw new SOAPException(SOAPPlugin.Util.getString("DataServiceWebServiceImpl.13"));
        }
        NamePasswordCredential npc = null;
        Subject sub = creds.getSubject();
        if (sub == null) {
            throw new SOAPException(SOAPPlugin.Util.getString("DataServiceWebServiceImpl.14"));
        }
        Set credSet = sub.getPrivateCredentials(class$org$idoox$security$jaas$NamePasswordCredential == null ? (class$org$idoox$security$jaas$NamePasswordCredential = DataServiceWebServiceImpl.class$("org.idoox.security.jaas.NamePasswordCredential")) : class$org$idoox$security$jaas$NamePasswordCredential);
        if (credSet == null || credSet.size() == 0) {
            throw new SOAPException(SOAPPlugin.Util.getString("DataServiceWebServiceImpl.2"));
        }
        npc = (NamePasswordCredential)credSet.iterator().next();
        if (npc == null) {
            throw new SOAPException(SOAPPlugin.Util.getString("DataServiceWebServiceImpl.3"));
        }
        username = npc.getName();
        password = npc.getPassword();
        connectionProperties.setProperty("Username", username);
        connectionProperties.setProperty("Password", password);
        connectionProperties.setProperty("ServerURL", info.getServerURL());
        Connection connection = null;
        try {
            connection = connectionSource.getConnection(connectionProperties);
        }
        catch (Exception e) {
            e.printStackTrace();
            Object[] param = new String[]{username, e.getMessage()};
            throw new SOAPException(SOAPPlugin.Util.getString("DataServiceWebServiceImpl.8", param), (Throwable)e);
        }
        return connection;
    }

    protected Properties getAuthenticationProperties(String username, String password) {
        Properties props = new Properties();
        if (username != null) {
            props.setProperty(USER_NAME, username);
        }
        if (password != null) {
            props.setProperty(PASSWORD, password);
        }
        return props;
    }

    protected DataServiceInfo getDataServiceInfo(SOAPMessage message) throws SOAPProcessingException {
        return EndpointUriTranslatorStrategyImpl.getDataServiceInfo(message);
    }

    protected SOAPMessage createSOAPFaultMessage(Exception e, String faultMessageString, String faultCode) {
        SOAPPlugin.Util.log(4, (Throwable)e, faultMessageString);
        return this.createSOAPFaultMessageImpl(faultMessageString, faultCode);
    }

    protected SOAPMessage createSOAPFaultMessage(String faultMessageString, String faultCode) {
        SOAPPlugin.Util.log(4, faultMessageString);
        return this.createSOAPFaultMessageImpl(faultMessageString, faultCode);
    }

    private SOAPMessage createSOAPFaultMessageImpl(String faultMessageString, String faultCode) {
        try {
            SOAPMessage faultMessage = this.factory.createMessage();
            SOAPBody body = faultMessage.getSOAPPart().getEnvelope().getBody();
            SOAPFault fault = body.addFault();
            fault.setFaultCode(faultCode);
            fault.setFaultString(faultMessageString);
            return faultMessage;
        }
        catch (SOAPException ee) {
            SOAPPlugin.Util.log(4, (Throwable)ee, ee.getMessage());
            throw new RuntimeWrappedException((Throwable)ee);
        }
    }

    private List getBodyElements(SOAPBody body) {
        LinkedList elements = new LinkedList();
        if (body == null) {
            return elements;
        }
        Iterator iter = body.getChildElements();
        if (iter != null) {
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof SOAPElement)) continue;
                elements.add(obj);
            }
        }
        return elements;
    }

    private TextImpl getText(SOAPBody body) {
        if (body == null) {
            return null;
        }
        Iterator iter = body.getChildElements();
        if (iter != null) {
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof TextImpl)) continue;
                return (TextImpl)obj;
            }
        }
        return null;
    }

    protected int getQueryTimeout() {
        int timeout = 0;
        if (System.getProperty("com.metamatrix.webservice.querytimeout") != null) {
            try {
                timeout = Integer.parseInt(System.getProperty("com.metamatrix.webservice.querytimeout"));
            }
            catch (NumberFormatException nfe) {
                SOAPPlugin.Util.log(2, (Throwable)nfe, SOAPPlugin.Util.getString("DataServiceWebServiceImpl.16"));
                timeout = 0;
            }
        }
        return timeout;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

