/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.util;

import com.metamatrix.soap.SOAPPlugin;
import com.metamatrix.soap.exceptions.SOAPProcessingException;
import com.metamatrix.soap.service.DataServiceInfo;
import com.metamatrix.soap.util.ExceptionUtil;
import javax.xml.soap.SOAPMessage;
import org.idoox.transport.URI;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.webservice.Current;

public class EndpointUriTranslatorStrategyImpl {
    private static final String URL_PREFIX = "jdbc:metamatrix:";
    private static final String URL_AT = "@";
    private static final String URL_SUFFIX = ";version=";

    public static DataServiceInfo getDataServiceInfo(SOAPMessage message) throws SOAPProcessingException {
        DataServiceInfo info = new DataServiceInfo();
        URI uri = (URI)Current.getCallContext().getContextData().get("endpointURI");
        String vdbContextualWebServiceName = null;
        if (!(message instanceof WaspSOAPMessage)) {
            String message1 = SOAPPlugin.Util.getString("EndpointUriTranslatorStrategyImpl.0");
            throw ExceptionUtil.processingError(message1);
        }
        WaspSOAPMessage wsMessage = (WaspSOAPMessage)message;
        vdbContextualWebServiceName = wsMessage.getSOAPAction();
        info.setDataServiceFullPath(vdbContextualWebServiceName);
        if (uri == null) {
            String message1 = SOAPPlugin.Util.getString("EndpointUriTranslatorStrategyImpl.Uri_was_null");
            throw ExceptionUtil.processingError(message1);
        }
        String serverUrl = uri.getParameter("ServerURL");
        String vdbName = uri.getParameter("VDBName");
        String vdbVersion = uri.getParameter("VDBVersion");
        String additionalProps = uri.getParameter("AddExecProperties");
        String jdbcUrl = EndpointUriTranslatorStrategyImpl.createJdbcUrl(serverUrl, vdbName, vdbVersion, additionalProps);
        info.setServerURL(jdbcUrl);
        return info;
    }

    protected static String createJdbcUrl(String serverUrl, String vdbName, String vdbVersion, String additionalProps) {
        StringBuffer result = new StringBuffer(URL_PREFIX).append(vdbName).append(URL_AT).append(serverUrl);
        if (vdbVersion != null) {
            result.append(URL_SUFFIX).append(vdbVersion);
        }
        if (additionalProps != null) {
            result.append(';').append(additionalProps);
        }
        return result.toString();
    }
}

