/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.util;

import com.idoox.xml.Tokenizer2Writer;
import com.idoox.xml.XmlWriter;
import com.metamatrix.soap.SOAPPlugin;
import com.metamatrix.soap.exceptions.SOAPProcessingException;
import com.metamatrix.soap.util.ExceptionUtil;
import com.systinet.saaj.soap.SOAPElementImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.idoox.wasp.Context;
import org.idoox.xml.ElementFinalizingTokenizerWrapper;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.TokenizerFactory;

public class SystinetObjectUtil {
    public static String stringifySoapElement(SOAPElement element) throws SOAPProcessingException {
        if (element == null) {
            throw ExceptionUtil.processingError(SOAPPlugin.Util.getString("SystinetObjectUtil.0"));
        }
        if (element instanceof SOAPElementImpl) {
            SOAPElementImpl elementImpl = (SOAPElementImpl)element;
            try {
                StringWriter writer = new StringWriter();
                XmlWriter outw = new XmlWriter((Writer)writer, false);
                Tokenizer t = elementImpl.getContent();
                Tokenizer2Writer.copy((Tokenizer)t, (TokenWriter)outw);
                outw.flush();
                return writer.toString();
            }
            catch (Exception e) {
                Object[] params = new String[]{element.getElementName().getLocalName()};
                throw ExceptionUtil.processingError(e, SOAPPlugin.Util.getString("SystinetObjectUtil.1", params));
            }
        }
        Object[] param = new String[]{element.getClass().getName()};
        throw ExceptionUtil.processingError(SOAPPlugin.Util.getString("SystinetObjectUtil.2", param));
    }

    public static void addXMLFragmentToBody(SOAPMessage message, String fragment) throws SOAPProcessingException {
        if (message == null) {
            throw ExceptionUtil.processingError(SOAPPlugin.Util.getString("SystinetObjectUtil.3"));
        }
        if (message.getSOAPPart() == null) {
            throw ExceptionUtil.processingError(SOAPPlugin.Util.getString("SystinetObjectUtil.4"));
        }
        try {
            Tokenizer tokenizer = SystinetObjectUtil.getTokenizerFromString(fragment);
            SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
            if (envelope == null) {
                throw ExceptionUtil.processingError(SOAPPlugin.Util.getString("SystinetObjectUtil.5"));
            }
            SOAPBody body = envelope.getBody();
            if (body == null) {
                throw ExceptionUtil.processingError(SOAPPlugin.Util.getString("SystinetObjectUtil.6"));
            }
            tokenizer.next();
            tokenizer = new ElementFinalizingTokenizerWrapper((Tokenizer)new ElementFinalizingTokenizerWrapper(tokenizer, (SOAPElement)body), (SOAPElement)envelope);
            if (!(body instanceof SOAPElementImpl)) {
                throw ExceptionUtil.processingError(SOAPPlugin.Util.getString("SystinetObjectUtil.7"));
            }
            SOAPElementImpl bodyImpl = (SOAPElementImpl)body;
            bodyImpl.setContent(tokenizer);
        }
        catch (Exception e) {
            Object[] param = new String[]{fragment};
            String message1 = SOAPPlugin.Util.getString("SystinetObjectUtil.8", param);
            throw ExceptionUtil.processingError(e, message1);
        }
    }

    private static Tokenizer getTokenizerFromString(String input) throws TokenizerException, IOException {
        TokenizerFactory tokenizerFactory = (TokenizerFactory)Context.getInstance((String)"org.idoox.xml.TokenizerFactory");
        ByteArrayInputStream bais = new ByteArrayInputStream(input.getBytes());
        return tokenizerFactory.getTokenizer((InputStream)bais);
    }
}

