/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.soap.client.axis.helper;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SOAPConfiguration {
    public static final String JNDI_COMP_ENV = "java:comp/env";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String ISENCRYPTED = "isencrypted";
    public static final String VDB = "vdb";
    public static final String VERSION = "version";
    public static final String MAX_ANONYMOUS_USERS = "maxusers";
    public static final String APPSERVER = "appserver";
    public static final String SERVERURL = "serverurl";
    public static final String TIMEOUT = "timeout";
    public static final String CLEAN = "clean";
    private String anonymousUsername;
    private String anonymousPassword;
    private String anonymousVDB;
    private String anonymousVDBVersion;
    private String anonymousAppServer;
    private String anonymousServerURL;
    private int maxusers;
    private int timeout;
    private int cleanDelay;
    private String isEncrypted;
    private Properties props;

    public SOAPConfiguration() {
        String temp;
        try {
            this.props = new Properties();
            this.openConfig();
        }
        catch (NamingException ne) {
            // empty catch block
        }
        this.anonymousUsername = this.props.getProperty(USERNAME, "anonymous");
        this.anonymousPassword = this.props.getProperty(PASSWORD, "anonymous");
        this.isEncrypted = this.props.getProperty(ISENCRYPTED, "false");
        this.anonymousVDB = this.props.getProperty(VDB, VDB);
        this.anonymousVDBVersion = this.props.getProperty(VERSION, "1");
        this.anonymousAppServer = this.props.getProperty(APPSERVER, "weblogic");
        this.anonymousServerURL = this.props.getProperty(SERVERURL, "t3://localhost:7001");
        try {
            temp = this.props.getProperty(MAX_ANONYMOUS_USERS, "10");
            this.maxusers = Integer.parseInt(temp);
        }
        catch (NumberFormatException nfe) {
            this.maxusers = 10;
        }
        try {
            temp = this.props.getProperty(TIMEOUT, "60");
            this.timeout = Integer.parseInt(temp);
        }
        catch (NumberFormatException nfe) {
            this.timeout = 60;
        }
        try {
            temp = this.props.getProperty(CLEAN, "60");
            this.cleanDelay = Integer.parseInt(temp);
        }
        catch (NumberFormatException nfe) {
            this.cleanDelay = 60;
        }
    }

    private void openConfig() throws NamingException {
        InitialContext initCtx = new InitialContext();
        Context defCtx = (Context)initCtx.lookup(JNDI_COMP_ENV);
        this.addProperty(USERNAME, (String)defCtx.lookup(USERNAME));
        this.addProperty(PASSWORD, (String)defCtx.lookup(PASSWORD));
        this.addProperty(ISENCRYPTED, (String)defCtx.lookup(ISENCRYPTED));
        this.addProperty(VDB, (String)defCtx.lookup(VDB));
        this.addProperty(VERSION, (String)defCtx.lookup(VERSION));
        this.addProperty(APPSERVER, (String)defCtx.lookup(APPSERVER));
        this.addProperty(SERVERURL, (String)defCtx.lookup(SERVERURL));
        this.addProperty(MAX_ANONYMOUS_USERS, (String)defCtx.lookup(MAX_ANONYMOUS_USERS));
        this.addProperty(TIMEOUT, (String)defCtx.lookup(TIMEOUT));
        this.addProperty(CLEAN, (String)defCtx.lookup(CLEAN));
    }

    private void addProperty(String key, String value) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.put(key, value);
    }

    public String getAnonymousUserName() {
        return this.anonymousUsername;
    }

    public String getAnonymousPassword() {
        return this.anonymousPassword;
    }

    public String getIsEncrypted() {
        return this.isEncrypted;
    }

    public String getAnonymousVDB() {
        return this.anonymousVDB;
    }

    public String getAnonymousVDBVersion() {
        return this.anonymousVDBVersion;
    }

    public String getAnonymousAppServer() {
        return this.anonymousAppServer;
    }

    public String getAnonymousServerURL() {
        return this.anonymousServerURL;
    }

    public int getMaxUsers() {
        return this.maxusers;
    }

    public int getTimeOut() {
        return this.timeout;
    }

    public int getCleanDelay() {
        return this.cleanDelay;
    }
}

