/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.batch;

import com.metamatrix.common.CommonPlugin;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchSerializer {
    private static final Map serializers = new HashMap(18, 1.0f);

    private BatchSerializer() {
    }

    static void writeIsNullData(ObjectOutput out, int col, List[] batch) throws IOException {
        int numBytes = batch.length / 8;
        int row = 0;
        int currentByte = 0;
        int byteNum = 0;
        while (byteNum < numBytes) {
            int n = currentByte = batch[row].get(col) == null ? 128 : 0;
            if (batch[row + 1].get(col) == null) {
                currentByte |= 0x40;
            }
            if (batch[row + 2].get(col) == null) {
                currentByte |= 0x20;
            }
            if (batch[row + 3].get(col) == null) {
                currentByte |= 0x10;
            }
            if (batch[row + 4].get(col) == null) {
                currentByte |= 8;
            }
            if (batch[row + 5].get(col) == null) {
                currentByte |= 4;
            }
            if (batch[row + 6].get(col) == null) {
                currentByte |= 2;
            }
            if (batch[row + 7].get(col) == null) {
                currentByte |= 1;
            }
            out.write(currentByte);
            ++byteNum;
            row += 8;
        }
        if (batch.length % 8 > 0) {
            currentByte = 0;
            int mask = 128;
            while (row < batch.length) {
                if (batch[row].get(col) == null) {
                    currentByte |= mask;
                }
                ++row;
                mask >>= 1;
            }
            out.write(currentByte);
        }
    }

    static void readIsNullData(ObjectInput in, byte[] isNullBytes) throws IOException {
        for (int i = 0; i < isNullBytes.length; ++i) {
            isNullBytes[i] = in.readByte();
        }
    }

    static boolean isNullObject(byte[] isNull, int row) {
        return (isNull[row / 8] & 1 << 7 - row % 8) != 0;
    }

    private static ColumnSerializer getSerializer(String type) {
        return (ColumnSerializer)serializers.get(type == null ? "object" : type);
    }

    public static void writeBatch(ObjectOutput out, String[] types, List[] batch) throws IOException {
        if (types == null || types.length == 0) {
            out.writeObject(batch);
            return;
        }
        if (batch == null) {
            out.writeInt(-1);
        } else if (batch.length == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(batch.length);
            int columns = batch[0].size();
            out.writeInt(columns);
            ColumnSerializer serializer = null;
            for (int i = 0; i < columns; ++i) {
                serializer = BatchSerializer.getSerializer(types[i]);
                if (serializer == null) {
                    throw new IOException(CommonPlugin.Util.getString("BatchSerializer.no_serializer", (Object)types[i]));
                }
                try {
                    serializer.writeColumn(out, i, batch);
                    continue;
                }
                catch (ClassCastException e) {
                    Object obj = null;
                    String objectClass = null;
                    for (int row = 0; row < batch.length; ++row) {
                        obj = batch[row].get(i);
                        if (obj == null) continue;
                        objectClass = obj.getClass().getName();
                        break;
                    }
                    throw new IOException(CommonPlugin.Util.getString("BatchSerializer.datatype_mismatch", new Object[]{types[i], new Integer(i), objectClass}));
                }
            }
        }
    }

    public static List[] readBatch(ObjectInput in, String[] types) throws IOException, ClassNotFoundException {
        if (types == null || types.length == 0) {
            return (List[])in.readObject();
        }
        int rows = in.readInt();
        if (rows == 0) {
            return new List[0];
        }
        if (rows > 0) {
            int columns = in.readInt();
            List[] batch = new List[rows];
            int numBytes = rows / 8;
            int extraRows = rows % 8;
            for (int currentRow = 0; currentRow < rows; ++currentRow) {
                batch[currentRow] = Arrays.asList(new Object[columns]);
            }
            byte[] isNullBuffer = new byte[extraRows > 0 ? numBytes + 1 : numBytes];
            for (int col = 0; col < columns; ++col) {
                BatchSerializer.getSerializer(types[col]).readColumn(in, col, batch, isNullBuffer);
            }
            return batch;
        }
        return null;
    }

    static {
        serializers.put("bigdecimal", new BigDecimalColumnSerializer());
        serializers.put("biginteger", new BigIntegerColumnSerializer());
        serializers.put("blob", new ObjectColumnSerializer());
        serializers.put("boolean", new BooleanColumnSerializer());
        serializers.put("byte", new ByteColumnSerializer());
        serializers.put("char", new CharColumnSerializer());
        serializers.put("clob", new ObjectColumnSerializer());
        serializers.put("xml", new ObjectColumnSerializer());
        serializers.put("date", new DateColumnSerializer());
        serializers.put("double", new DoubleColumnSerializer());
        serializers.put("float", new FloatColumnSerializer());
        serializers.put("integer", new IntColumnSerializer());
        serializers.put("long", new LongColumnSerializer());
        serializers.put("object", new ObjectColumnSerializer());
        serializers.put("short", new ShortColumnSerializer());
        serializers.put("string", new StringColumnSerializer());
        serializers.put("time", new TimeColumnSerializer());
        serializers.put("timestamp", new TimestampColumnSerializer());
    }

    private static class ObjectColumnSerializer
    implements ColumnSerializer {
        private ObjectColumnSerializer() {
        }

        public void writeColumn(ObjectOutput out, int col, List[] results) throws IOException {
            for (int i = 0; i < results.length; ++i) {
                out.writeObject(results[i].get(col));
            }
        }

        public void readColumn(ObjectInput in, int col, List[] batch, byte[] isNull) throws IOException, ClassNotFoundException {
            for (int i = 0; i < batch.length; ++i) {
                batch[i].set(col, in.readObject());
            }
        }
    }

    private static class TimestampColumnSerializer
    extends AbstractNativeColumnSerializer {
        private TimestampColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            Timestamp ts = (Timestamp)obj;
            out.writeLong(ts.getTime());
            out.writeInt(ts.getNanos());
        }

        protected Object readObject(ObjectInput in) throws IOException {
            Timestamp ts = new Timestamp(in.readLong());
            ts.setNanos(in.readInt());
            return ts;
        }
    }

    private static class TimeColumnSerializer
    extends AbstractNativeColumnSerializer {
        private TimeColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeLong(((Time)obj).getTime());
        }

        protected Object readObject(ObjectInput in) throws IOException {
            return new Time(in.readLong());
        }
    }

    private static class DateColumnSerializer
    extends AbstractNativeColumnSerializer {
        private DateColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeLong(((Date)obj).getTime());
        }

        protected Object readObject(ObjectInput in) throws IOException {
            return new Date(in.readLong());
        }
    }

    private static class BigDecimalColumnSerializer
    extends AbstractNativeColumnSerializer {
        private BigDecimalColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            BigDecimal val = (BigDecimal)obj;
            out.writeInt(val.scale());
            BigInteger unscaled = val.unscaledValue();
            byte[] bytes = unscaled.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        protected Object readObject(ObjectInput in) throws IOException {
            int scale = in.readInt();
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BigDecimal(new BigInteger(bytes), scale);
        }
    }

    private static class BigIntegerColumnSerializer
    extends AbstractNativeColumnSerializer {
        private BigIntegerColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            BigInteger val = (BigInteger)obj;
            byte[] bytes = val.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        protected Object readObject(ObjectInput in) throws IOException {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BigInteger(bytes);
        }
    }

    private static class StringColumnSerializer
    extends AbstractNativeColumnSerializer {
        private StringColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            String val = (String)obj;
            int length = val.length();
            out.writeInt(length);
            boolean writingShort = true;
            for (int i = 0; i < length; ++i) {
                if (writingShort) {
                    char c = val.charAt(i);
                    if (c < '\u0080') {
                        out.write(c);
                        continue;
                    }
                    out.write(128);
                    writingShort = false;
                    out.writeChar(c);
                    continue;
                }
                out.writeChar(val.charAt(i));
            }
        }

        protected Object readObject(ObjectInput in) throws IOException {
            int length = in.readInt();
            char[] chars = new char[length];
            boolean readingShort = true;
            for (int i = 0; i < length; ++i) {
                if (readingShort) {
                    int b = in.read();
                    if (b == 128) {
                        readingShort = false;
                        chars[i] = in.readChar();
                        continue;
                    }
                    chars[i] = (char)b;
                    continue;
                }
                chars[i] = in.readChar();
            }
            return new String(chars);
        }
    }

    private static class CharColumnSerializer
    extends AbstractNativeColumnSerializer {
        private CharColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeChar(((Character)obj).charValue());
        }

        protected Object readObject(ObjectInput in) throws IOException {
            return new Character(in.readChar());
        }
    }

    private static class ByteColumnSerializer
    extends AbstractNativeColumnSerializer {
        private ByteColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeByte(((Byte)obj).byteValue());
        }

        protected Object readObject(ObjectInput in) throws IOException {
            return new Byte(in.readByte());
        }
    }

    private static class BooleanColumnSerializer
    implements ColumnSerializer {
        private BooleanColumnSerializer() {
        }

        public void writeColumn(ObjectOutput out, int col, List[] batch) throws IOException {
            int currentByte = 0;
            int mask = 128;
            for (int row = 0; row < batch.length; ++row) {
                Object obj = batch[row].get(col);
                if (obj == null) {
                    currentByte |= mask;
                }
                if ((mask >>= 1) == 0) {
                    out.write(currentByte);
                    currentByte = 0;
                    mask = 128;
                }
                if (obj == null) continue;
                if (((Boolean)obj).booleanValue()) {
                    currentByte |= mask;
                }
                if ((mask >>= 1) != 0) continue;
                out.write(currentByte);
                currentByte = 0;
                mask = 128;
            }
            if (mask != 128) {
                out.write(currentByte);
            }
        }

        public void readColumn(ObjectInput in, int col, List[] batch, byte[] isNull) throws IOException, ClassNotFoundException {
            int currentByte = 0;
            int mask = 0;
            for (int row = 0; row < batch.length; ++row) {
                if (mask == 0) {
                    currentByte = in.read();
                    mask = 128;
                }
                boolean isNullVal = (currentByte & mask) != 0;
                mask >>= 1;
                if (isNullVal) continue;
                if (mask == 0) {
                    currentByte = in.read();
                    mask = 128;
                }
                batch[row].set(col, (currentByte & mask) == 0 ? Boolean.FALSE : Boolean.TRUE);
                mask >>= 1;
            }
        }
    }

    private static class ShortColumnSerializer
    extends AbstractNativeColumnSerializer {
        private ShortColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeShort(((Short)obj).shortValue());
        }

        protected Object readObject(ObjectInput in) throws IOException {
            return new Short(in.readShort());
        }
    }

    private static class DoubleColumnSerializer
    extends AbstractNativeColumnSerializer {
        private DoubleColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeDouble((Double)obj);
        }

        protected Object readObject(ObjectInput in) throws IOException {
            return new Double(in.readDouble());
        }
    }

    private static class FloatColumnSerializer
    extends AbstractNativeColumnSerializer {
        private FloatColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeFloat(((Float)obj).floatValue());
        }

        protected Object readObject(ObjectInput in) throws IOException {
            return new Float(in.readFloat());
        }
    }

    private static class LongColumnSerializer
    extends AbstractNativeColumnSerializer {
        private LongColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeLong((Long)obj);
        }

        protected Object readObject(ObjectInput in) throws IOException {
            return new Long(in.readLong());
        }
    }

    private static class IntColumnSerializer
    extends AbstractNativeColumnSerializer {
        private IntColumnSerializer() {
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeInt((Integer)obj);
        }

        protected Object readObject(ObjectInput in) throws IOException {
            return new Integer(in.readInt());
        }
    }

    private static abstract class AbstractNativeColumnSerializer
    implements ColumnSerializer {
        private AbstractNativeColumnSerializer() {
        }

        public void writeColumn(ObjectOutput out, int col, List[] batch) throws IOException {
            BatchSerializer.writeIsNullData(out, col, batch);
            Object obj = null;
            for (int i = 0; i < batch.length; ++i) {
                obj = batch[i].get(col);
                if (obj == null) continue;
                this.writeObject(out, obj);
            }
        }

        public void readColumn(ObjectInput in, int col, List[] batch, byte[] isNull) throws IOException, ClassNotFoundException {
            BatchSerializer.readIsNullData(in, isNull);
            for (int i = 0; i < batch.length; ++i) {
                if (BatchSerializer.isNullObject(isNull, i)) continue;
                batch[i].set(col, this.readObject(in));
            }
        }

        protected abstract void writeObject(ObjectOutput var1, Object var2) throws IOException;

        protected abstract Object readObject(ObjectInput var1) throws IOException;
    }

    private static interface ColumnSerializer {
        public void writeColumn(ObjectOutput var1, int var2, List[] var3) throws IOException;

        public void readColumn(ObjectInput var1, int var2, List[] var3, byte[] var4) throws IOException, ClassNotFoundException;
    }
}

