/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.cache;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.cache.ObjectCacheException;
import com.metamatrix.common.cache.ObjectCacheStatistics;
import com.metamatrix.common.cache.policy.InLineResourceRecaptureStrategy;
import com.metamatrix.common.cache.policy.ObjectCachePolicy;
import com.metamatrix.common.cache.policy.ObjectCachePolicyFactory;
import com.metamatrix.common.cache.policy.ResourceRecaptureStrategy;
import com.metamatrix.common.cache.policy.SeparateThreadResourceRecaptureStrategy;
import com.metamatrix.common.properties.UnmodifiableProperties;
import com.metamatrix.core.util.ReflectionHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class ObjectCache {
    public static final String POLICY_FACTORY = "com.metamatrix.common.cache.ObjectCache.PolicyFactory";
    public static final String RESOURCE_RECAPTURE_MODE = "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureMode";
    public static final String MAXIMUM_CAPACITY = "com.metamatrix.common.cache.ObjectCache.MaximumCapacity";
    protected static final String MAXIMUM_CAPACITY_DEFAULT_VALUE = "0";
    public static final String MAXIMUM_COST = "com.metamatrix.common.cache.ObjectCache.MaximumCost";
    protected static final String MAXIMUM_COST_DEFAULT_VALUE = "0";
    public static final String MAXIMUM_AGE = "com.metamatrix.common.cache.ObjectCache.MaximumAge";
    protected static final String MAXIMUM_AGE_DEFAULT_VALUE = "0";
    public static final String RESOURCE_RECAPTURE_FRACTION = "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureFraction";
    protected static final String RESOURCE_RECAPTURE_FRACTION_DEFAULT_VALUE = "0.10";
    public static final String RESOURCE_RECAPTURE_INTERVAL = "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureInterval";
    protected static final String RESOURCE_RECAPTURE_INTERVAL_DEFAULT_ST_VALUE = "5000";
    protected static final String RESOURCE_RECAPTURE_INTERVAL_DEFAULT_IL_VALUE = "10";
    public static final String RESOURCE_RECAPTURE_INTERVAL_RATE = "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalRate";
    public static final String RESOURCE_RECAPTURE_INTERVAL_CEILING = "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalCeiling";
    protected static final int RESOURCE_RECAPTURE_INTERVAL_CEILING_DEFAULT_FACTOR = 20;
    public static final String RESOURCE_RECAPTURE_INTERVAL_INCREMENT = "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalIncrement";
    protected static final String RESOURCE_RECAPTURE_INTERVAL_INCREMENT_DEFAULT_VALUE = "1.15";
    public static final String RESOURCE_RECAPTURE_INTERVAL_DECREMENT = "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalDecrement";
    protected static final String RESOURCE_RECAPTURE_INTERVAL_DECREMENT_DEFAULT_VALUE = "0.97";
    public static final String HELPER_CLASS = "com.metamatrix.common.cache.ObjectCache.CacheHelper";
    public static final String COST_CALCULATOR_CLASS = "com.metamatrix.common.cache.ObjectCache.CostCalculatorClass";
    private ObjectCachePolicy policy;
    private ResourceRecaptureStrategy strategy;
    private Properties immutableEnvironment;

    protected void finalize() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectCache(Properties environment) throws ObjectCacheException {
        Properties env = null;
        Properties properties = environment;
        synchronized (properties) {
            env = (Properties)environment.clone();
        }
        String value = env.getProperty(RESOURCE_RECAPTURE_MODE);
        boolean inLineMode = false;
        if (value == null) throw new ObjectCacheException("ERR.003.008.0002", CommonPlugin.Util.getString("ERR.003.008.0002"));
        if (value.equalsIgnoreCase("SeparateThread")) {
            this.strategy = new SeparateThreadResourceRecaptureStrategy();
        } else {
            if (!value.equalsIgnoreCase("InLine")) throw new ObjectCacheException("ERR.003.008.0001", CommonPlugin.Util.getString("ERR.003.008.0001", new Object[]{value, "InLine", "SeparateThread"}));
            this.strategy = new InLineResourceRecaptureStrategy();
            inLineMode = true;
        }
        if (!env.containsKey(MAXIMUM_CAPACITY)) {
            env.setProperty(MAXIMUM_CAPACITY, "0");
        }
        if (!env.containsKey(MAXIMUM_COST)) {
            env.setProperty(MAXIMUM_COST, "0");
        }
        if (!env.containsKey(MAXIMUM_AGE)) {
            env.setProperty(MAXIMUM_AGE, "0");
        }
        if (!env.containsKey(RESOURCE_RECAPTURE_FRACTION)) {
            env.setProperty(RESOURCE_RECAPTURE_FRACTION, RESOURCE_RECAPTURE_FRACTION_DEFAULT_VALUE);
        }
        if (!env.containsKey(RESOURCE_RECAPTURE_INTERVAL)) {
            if (inLineMode) {
                env.setProperty(RESOURCE_RECAPTURE_INTERVAL, RESOURCE_RECAPTURE_INTERVAL_DEFAULT_IL_VALUE);
            } else {
                env.setProperty(RESOURCE_RECAPTURE_INTERVAL, RESOURCE_RECAPTURE_INTERVAL_DEFAULT_ST_VALUE);
            }
        }
        if (env.containsKey(RESOURCE_RECAPTURE_INTERVAL_RATE)) {
            int rateValue = 0;
            try {
                rateValue = Integer.parseInt(env.getProperty(RESOURCE_RECAPTURE_INTERVAL_RATE));
            }
            catch (Exception e) {
                throw new ObjectCacheException(e, "ERR.003.008.0003", CommonPlugin.Util.getString("ERR.003.008.0003", (Object)RESOURCE_RECAPTURE_INTERVAL_RATE));
            }
            if (!env.containsKey(RESOURCE_RECAPTURE_INTERVAL_CEILING)) {
                Integer ceiling = new Integer(rateValue * 20);
                env.setProperty(RESOURCE_RECAPTURE_INTERVAL_CEILING, ceiling.toString());
            }
            if (!env.containsKey(RESOURCE_RECAPTURE_INTERVAL_INCREMENT)) {
                env.setProperty(RESOURCE_RECAPTURE_INTERVAL_INCREMENT, RESOURCE_RECAPTURE_INTERVAL_INCREMENT_DEFAULT_VALUE);
            }
            if (!env.containsKey(RESOURCE_RECAPTURE_INTERVAL_DECREMENT)) {
                env.setProperty(RESOURCE_RECAPTURE_INTERVAL_DECREMENT, RESOURCE_RECAPTURE_INTERVAL_DECREMENT_DEFAULT_VALUE);
            }
        }
        this.immutableEnvironment = new UnmodifiableProperties(env);
        String factoryClassName = env.getProperty(POLICY_FACTORY);
        try {
            ObjectCachePolicyFactory factory = (ObjectCachePolicyFactory)ReflectionHelper.create((String)factoryClassName, null, (ClassLoader)this.getClass().getClassLoader());
            this.policy = factory.create(env);
        }
        catch (Exception e) {
            throw new ObjectCacheException(e, "ERR.003.008.0004", CommonPlugin.Util.getString("ERR.003.008.0004", (Object)factoryClassName));
        }
        if (this.policy == null) {
            throw new ObjectCacheException("ERR.003.008.0005", CommonPlugin.Util.getString("ERR.003.008.0005", (Object)factoryClassName));
        }
        this.strategy.setPolicy(this.policy);
    }

    public void shutdown() {
        this.strategy.stop();
        this.strategy = null;
        this.policy.clear();
    }

    public float getResourceUtilization() {
        return this.policy.getResourceUtilization();
    }

    public int size() {
        return this.policy.size();
    }

    public boolean isEmpty() {
        return this.policy.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectCacheStatistics getStatistics() {
        ObjectCacheStatistics result = null;
        ResourceRecaptureStrategy resourceRecaptureStrategy = this.strategy;
        synchronized (resourceRecaptureStrategy) {
            result = this.strategy.getStatistics();
        }
        return result;
    }

    public Properties getEnvironment() {
        return this.immutableEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object find(Object key) {
        Object result = null;
        ResourceRecaptureStrategy resourceRecaptureStrategy = this.strategy;
        synchronized (resourceRecaptureStrategy) {
            result = this.strategy.find(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(Object key, Object value) {
        ResourceRecaptureStrategy resourceRecaptureStrategy = this.strategy;
        synchronized (resourceRecaptureStrategy) {
            this.strategy.mark(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object key) {
        boolean result = false;
        ResourceRecaptureStrategy resourceRecaptureStrategy = this.strategy;
        synchronized (resourceRecaptureStrategy) {
            result = this.strategy.containsValue(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getKeysNotInCache(Collection keys) {
        Collection result = null;
        ResourceRecaptureStrategy resourceRecaptureStrategy = this.strategy;
        synchronized (resourceRecaptureStrategy) {
            result = this.strategy.getKeysNotInCache(keys);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        ResourceRecaptureStrategy resourceRecaptureStrategy = this.strategy;
        synchronized (resourceRecaptureStrategy) {
            this.strategy.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ResourceRecaptureStrategy resourceRecaptureStrategy = this.strategy;
        synchronized (resourceRecaptureStrategy) {
            this.strategy.clear();
        }
    }

    public Map getCopyOfCacheContents() {
        return this.policy.getCopyOfCacheContents();
    }

    public String toString() {
        Properties env = this.getEnvironment();
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString() + "\n");
        sb.append("  Policy Class:                       ");
        sb.append(this.policy.getClass().getName());
        sb.append("\n");
        sb.append("  Environment Properties\n");
        sb.append("       Policy Factory:                ");
        sb.append(env.getProperty(POLICY_FACTORY));
        sb.append("\n");
        sb.append("       Recapture Mode:                ");
        String value = env.getProperty(RESOURCE_RECAPTURE_MODE);
        sb.append(value.equals("InLine") ? "In Line" : "Separate Thread");
        sb.append("\n");
        sb.append("       Maximum Capacity:              ");
        value = env.getProperty(MAXIMUM_CAPACITY);
        sb.append(!value.equals("0") ? value : "Unlimited");
        sb.append("\n");
        sb.append("       Maximum Cost:                  ");
        value = env.getProperty(MAXIMUM_COST);
        sb.append(!value.equals("0") ? value : "Unlimited");
        sb.append("\n");
        sb.append("       Recapture Fraction:            ");
        sb.append(env.getProperty(RESOURCE_RECAPTURE_FRACTION));
        sb.append("\n");
        sb.append("       Recapture Interval:            ");
        sb.append(env.getProperty(RESOURCE_RECAPTURE_INTERVAL));
        sb.append("\n");
        sb.append("       Recapture Rate:                ");
        if (env.containsKey(RESOURCE_RECAPTURE_INTERVAL_RATE)) {
            sb.append(env.getProperty(RESOURCE_RECAPTURE_INTERVAL_RATE));
            sb.append("\n");
            sb.append("       Recapture Interval Ceiling:    ");
            sb.append(env.getProperty(RESOURCE_RECAPTURE_INTERVAL_CEILING));
            sb.append("\n");
            sb.append("       Recapture Interval Increment:  ");
            sb.append(env.getProperty(RESOURCE_RECAPTURE_INTERVAL_INCREMENT));
            sb.append("\n");
            sb.append("       Recapture Interval Decrement:  ");
            sb.append(env.getProperty(RESOURCE_RECAPTURE_INTERVAL_DECREMENT));
            sb.append("\n");
        } else {
            sb.append("None (interval is fixed)\n");
        }
        sb.append("\n");
        sb.append("  Statistics\n");
        ObjectCacheStatistics stats = this.strategy.getStatistics();
        sb.append("       Current size:                  " + stats.getSize());
        sb.append("\n");
        sb.append("       Size watermark:                " + stats.getSizeWatermark());
        sb.append("\n");
        sb.append("       Current cost:                  " + stats.getCost());
        sb.append("\n");
        sb.append("       Cost watermark:                " + stats.getCostWatermark());
        sb.append("\n");
        sb.append("       Total Successful Finds:        " + stats.getTotalSuccessfulFinds());
        sb.append("\n");
        sb.append("       Total Failed Finds:            " + stats.getTotalFailedFinds());
        sb.append("\n");
        sb.append("       Total Additions:               " + stats.getTotalAdds());
        sb.append("\n");
        sb.append("       Total Purges:                  " + stats.getTotalPurges());
        sb.append("\n");
        sb.append("       Last modified:                 " + stats.getDateLastModified());
        sb.append("\n");
        sb.append(((Object)this.policy).toString());
        return sb.toString();
    }

    public static final class ResourceRecaptureModes {
        public static final String SEPARATE_THREAD = "SeparateThread";
        public static final String IN_LINE = "InLine";
    }
}

