/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.cache.mru;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.cache.ObjectCacheException;
import com.metamatrix.common.cache.mru.AgeValueHolder;
import com.metamatrix.common.cache.policy.ObjectCacheHelper;
import java.util.Properties;

public class AgeMRUCacheHelper
implements ObjectCacheHelper {
    private long maximumAge = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Properties env) throws ObjectCacheException {
        String maximumAgeString = null;
        Properties properties = env;
        synchronized (properties) {
            maximumAgeString = env.getProperty("com.metamatrix.common.cache.ObjectCache.MaximumAge");
        }
        if (maximumAgeString != null) {
            try {
                this.maximumAge = Long.parseLong(maximumAgeString);
            }
            catch (Exception e) {
                throw new ObjectCacheException(e, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{maximumAgeString, "com.metamatrix.common.cache.ObjectCache.MaximumAge"}));
            }
        } else {
            throw new ObjectCacheException("ERR.003.008.0017", CommonPlugin.Util.getString("ERR.003.008.0017", (Object)"com.metamatrix.common.cache.ObjectCache.MaximumAge"));
        }
    }

    public Object getValueHolder(Object value) {
        return new AgeValueHolder(value);
    }

    public Object getValueFromHolder(Object valueHolder) {
        AgeValueHolder holder = (AgeValueHolder)valueHolder;
        holder.resetAge();
        return holder.getValue();
    }

    public long getValueCost(Object valueHolder) {
        return 0L;
    }

    public boolean isRemovable(Object valueHolder) {
        return true;
    }

    public boolean isExpired(Object valueHolder) {
        if (this.maximumAge == 0L) {
            return false;
        }
        AgeValueHolder holder = (AgeValueHolder)valueHolder;
        return System.currentTimeMillis() - holder.getAge() >= this.maximumAge;
    }
}

