/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.cache.policy;

import com.metamatrix.common.cache.policy.ObjectCachePolicy;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractObjectCachePolicy
implements ObjectCachePolicy {
    private Properties environment;

    protected AbstractObjectCachePolicy(Properties environment) {
        this.environment = (Properties)environment.clone();
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    protected int intEnvironmentValue(String propertyName, int defaultValue) {
        int result = defaultValue;
        String value = this.environment.getProperty(propertyName);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    protected long longEnvironmentValue(String propertyName, long defaultValue) {
        long result = defaultValue;
        String value = this.environment.getProperty(propertyName);
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    public Map getCopyOfCacheContents() {
        throw new UnsupportedOperationException("getCopyOfCacheContents has not been implemented in this policy.");
    }
}

