/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.cache.policy;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.cache.ObjectCacheException;
import com.metamatrix.common.cache.policy.ResourceRecaptureStrategy;
import java.util.Collection;
import java.util.Properties;

public class InLineResourceRecaptureStrategy
extends ResourceRecaptureStrategy {
    private int initialInterval = 10;
    private int currentInterval = 0;
    private int maximumInterval = 300;
    private float intervalIncreaseFactor = 1.1f;
    private float intervalDecreaseFactor = 0.97f;
    private int intervalAdjustmentRate = 2;
    private int successfulChecks = 0;
    private int failedChecks = 0;
    private int totalChecks = 0;
    private int checksSinceLastAdjustment = 0;
    private int accessesSinceLastCheck = 0;
    private int totalIntervalIncreases = 0;
    private int totalIntervalDecreases = 0;

    public synchronized Object find(Object key) {
        this.recordAccessToCache();
        Object result = this.getPolicy().find(key);
        this.recoverResourcesIfRequired();
        return result;
    }

    public synchronized void mark(Object key, Object value) {
        this.recordAccessToCache();
        this.getPolicy().mark(key, value);
        this.recoverResourcesIfRequired();
    }

    public synchronized boolean containsValue(Object key) {
        this.recordAccessToCache();
        boolean result = this.getPolicy().containsValue(key);
        this.recoverResourcesIfRequired();
        return result;
    }

    public synchronized Collection getKeysNotInCache(Collection keys) {
        this.recordAccessToCache();
        Collection result = this.getPolicy().getKeysNotInCache(keys);
        this.recoverResourcesIfRequired();
        return result;
    }

    public synchronized void remove(Object key) {
        this.recordAccessToCache();
        this.getPolicy().remove(key);
        this.recoverResourcesIfRequired();
    }

    public synchronized void clear() {
        this.getPolicy().clear();
    }

    protected synchronized void recordAccessToCache() {
        ++this.accessesSinceLastCheck;
    }

    protected synchronized void recordResourceUsageCheckResult(boolean cacheExceedsCapacity) {
        this.accessesSinceLastCheck = 0;
        ++this.checksSinceLastAdjustment;
        ++this.totalChecks;
        if (cacheExceedsCapacity) {
            ++this.successfulChecks;
        } else {
            ++this.failedChecks;
        }
        if (this.checksSinceLastAdjustment >= this.intervalAdjustmentRate && this.currentInterval != this.maximumInterval) {
            int newInterval = this.computeNewInterval(this.currentInterval, this.successfulChecks, this.failedChecks);
            if (newInterval >= this.maximumInterval) {
                this.currentInterval = this.maximumInterval;
            } else if (newInterval > this.currentInterval) {
                ++this.totalIntervalIncreases;
                this.currentInterval = newInterval;
            } else if (newInterval < this.currentInterval) {
                ++this.totalIntervalDecreases;
                this.currentInterval = newInterval;
            }
            this.successfulChecks = 0;
            this.failedChecks = 0;
            this.checksSinceLastAdjustment = 0;
        }
    }

    protected synchronized void recoverResourcesIfRequired() {
        if (this.accessesSinceLastCheck >= this.currentInterval) {
            if (this.getPolicy().exceedsResources()) {
                this.recordResourceUsageCheckResult(true);
                this.getPolicy().reduceResourceUsage();
            } else {
                this.recordResourceUsageCheckResult(false);
            }
        }
    }

    protected int computeNewInterval(int currentInterval, int successfulChecks, int failedChecks) {
        float newInterval = 0.0f;
        if (successfulChecks == 0) {
            newInterval = (float)currentInterval * this.intervalDecreaseFactor;
        } else if (failedChecks == 0) {
            newInterval = (float)currentInterval * this.intervalIncreaseFactor;
        }
        int result = (int)newInterval;
        return result != 0 ? result : 1;
    }

    protected void initialize() throws ObjectCacheException {
        Properties env = this.getPolicy().getEnvironment();
        String value = env.getProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalRate");
        if (value != null) {
            try {
                this.intervalAdjustmentRate = Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new ObjectCacheException(e, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalRate"}));
            }
            value = env.getProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalCeiling");
            if (value != null) {
                try {
                    this.maximumInterval = Integer.parseInt(value);
                }
                catch (Exception e) {
                    throw new ObjectCacheException(e, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalCeiling"}));
                }
            }
            if ((value = env.getProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalIncrement")) != null) {
                try {
                    this.intervalIncreaseFactor = Float.parseFloat(value);
                }
                catch (Exception e) {
                    throw new ObjectCacheException(e, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalIncrement"}));
                }
            }
            if ((value = env.getProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalDecrement")) != null) {
                try {
                    this.intervalDecreaseFactor = Float.parseFloat(value);
                }
                catch (Exception e) {
                    throw new ObjectCacheException(e, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureIntervalDecrement"}));
                }
            }
        }
        if ((value = env.getProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureInterval")) != null) {
            try {
                this.currentInterval = this.initialInterval = Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new ObjectCacheException(e, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureInterval"}));
            }
        }
    }
}

