/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.classloader;

import com.metamatrix.common.classloader.NonDelegatingClassLoader;
import com.metamatrix.common.protocol.classpath.ClasspathURLConnection;
import com.metamatrix.common.protocol.mmfile.MMFileURLConnection;
import com.metamatrix.common.protocol.mmrofile.MMROFileURLConnection;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashSet;

public class URLFilteringClassLoader
extends NonDelegatingClassLoader {
    private static HashSet excludeProtocols = null;

    public URLFilteringClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public URLFilteringClassLoader(URL[] urls) {
        super(urls);
    }

    public URLFilteringClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    public URL[] getURLs() {
        ArrayList<URL> temp = new ArrayList<URL>();
        URL[] all = super.getURLs();
        for (int i = 0; i < all.length; ++i) {
            String protocol = all[i].getProtocol();
            if (excludeProtocols.contains(protocol)) continue;
            temp.add(all[i]);
        }
        return temp.toArray(new URL[temp.size()]);
    }

    static {
        excludeProtocols = new HashSet();
        excludeProtocols.add("extensionjar");
        excludeProtocols.add(ClasspathURLConnection.PROTOCOL);
        excludeProtocols.add(MMFileURLConnection.PROTOCOL);
        excludeProtocols.add(MMROFileURLConnection.PROTOCOL);
    }
}

