/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.pooling.api.Resource;
import com.metamatrix.common.pooling.api.ResourceHelper;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import java.sql.Connection;
import java.util.Properties;

public final class JDBCConnectionPoolHelper {
    private static BasicConfigurationObjectEditor editor = null;
    private static final String DEFAULT_ADAPTER = "com.metamatrix.common.pooling.jdbc.JDBCConnectionResourceAdapter";
    private static final String DEFAULT_POOL = "com.metamatrix.common.pooling.impl.BasicResourcePool";

    public static Connection getConnection(Properties properties, String userName) throws ResourcePoolException {
        String poolName = properties.getProperty("metamatrix.common.pooling.resource.name");
        if (poolName == null) {
            throw new ResourcePoolException("ERR.003.001.0026", CommonPlugin.Util.getString("ERR.003.001.0026", (Object)userName));
        }
        ResourceDescriptor descriptor = JDBCConnectionPoolHelper.getDescriptor(poolName);
        if (descriptor == null) {
            descriptor = JDBCConnectionPoolHelper.createDescriptor(Configuration.NEXT_STARTUP_ID, poolName, properties);
        }
        if (descriptor != null) {
            return JDBCConnectionPoolHelper.getConnection(descriptor, userName);
        }
        throw new ResourcePoolException("ERR.003.001.0027", CommonPlugin.Util.getString("ERR.003.001.0027", new Object[]{poolName, userName}));
    }

    public static Connection getConnection(String poolName, String userName) throws ResourcePoolException {
        return (Connection)((Object)ResourceHelper.getResource(poolName, userName));
    }

    public static Connection getConnection(ResourceDescriptor descriptor, String userName) throws ResourcePoolException {
        try {
            Resource resource = ResourceHelper.getResourceFromPool(descriptor, userName);
            if (resource instanceof Connection) {
                return (Connection)((Object)resource);
            }
            throw new ResourcePoolException("ERR.003.001.0029", CommonPlugin.Util.getString("ERR.003.001.0029", new Object[]{descriptor.getName(), userName, resource.getClass().getName()}));
        }
        catch (Exception e) {
            throw new ResourcePoolException(e, "ERR.003.001.0028", CommonPlugin.Util.getString("ERR.003.001.0028", new Object[]{descriptor.getName(), userName}));
        }
    }

    static ResourceDescriptor getDescriptor(String poolName) throws ResourcePoolException {
        ResourceDescriptor descriptor = null;
        try {
            descriptor = CurrentConfiguration.getResourceDescriptor(poolName);
        }
        catch (Exception e) {
            throw new ResourcePoolException(e, "ERR.003.001.0030", CommonPlugin.Util.getString("ERR.003.001.0030", (Object)poolName));
        }
        return descriptor;
    }

    public static ResourceDescriptor createDescriptor(ConfigurationID configID, String poolName, Properties properties) throws ResourcePoolException {
        String driver = properties.getProperty("metamatrix.common.pooling.jdbc.Driver");
        if (driver == null || driver.length() == 0) {
            return null;
        }
        ResourceDescriptor descriptor = editor.createResourceDescriptor(configID, SharedResource.JDBC_COMPONENT_TYPE_ID, poolName);
        descriptor = (ResourceDescriptor)editor.modifyProperties(descriptor, properties, 1);
        Properties def = new Properties();
        if (!properties.containsKey("metamatrix.common.pooling.resource.name")) {
            def.setProperty("metamatrix.common.pooling.resource.name", poolName);
        }
        if (!properties.containsKey("pooling.resource.adapter.class.name")) {
            def.setProperty("pooling.resource.adapter.class.name", DEFAULT_ADAPTER);
        }
        if (!properties.containsKey("pooling.resource.pool.class.name")) {
            def.setProperty("pooling.resource.pool.class.name", DEFAULT_POOL);
        }
        if (!def.isEmpty()) {
            descriptor = (ResourceDescriptor)editor.modifyProperties(descriptor, def, 1);
        }
        return descriptor;
    }

    public static ResourceDescriptor createDescriptor(ConfigurationID configID, String poolName, String driver, String protocol, String url, String userName, String password) throws ResourcePoolException {
        Properties props = new Properties();
        props.setProperty("metamatrix.common.pooling.jdbc.Driver", driver);
        props.setProperty("metamatrix.common.pooling.jdbc.Database", url);
        props.setProperty("metamatrix.common.pooling.jdbc.Protocol", protocol);
        props.setProperty("metamatrix.common.pooling.jdbc.User", userName);
        props.setProperty("metamatrix.common.pooling.jdbc.Password", password);
        return JDBCConnectionPoolHelper.createDescriptor(configID, poolName, props);
    }

    static {
        editor = new BasicConfigurationObjectEditor();
    }
}

