/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.api;

import com.metamatrix.common.config.api.ComponentObjectID;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.core.util.Assertion;

public class DeployedComponentID
extends ComponentObjectID {
    private final ConfigurationID configID;
    private final HostID hostID;
    private final VMComponentDefnID vmID;
    private final ServiceComponentDefnID serviceID;
    private final ProductServiceConfigID pscID;

    public DeployedComponentID(String name, ConfigurationID configId, HostID hostId, VMComponentDefnID vmId) {
        super(DeployedComponentID.createDeployedName(name, configId, hostId, vmId));
        this.configID = configId;
        this.hostID = hostId;
        this.vmID = vmId;
        this.serviceID = null;
        this.pscID = null;
    }

    public DeployedComponentID(String name, ConfigurationID configId, HostID hostId, VMComponentDefnID vmId, ProductServiceConfigID pscID, ServiceComponentDefnID serviceId) {
        super(DeployedComponentID.createDeployedName(name, configId, hostId, vmId, pscID, serviceId));
        this.configID = configId;
        this.hostID = hostId;
        this.vmID = vmId;
        this.serviceID = serviceId;
        this.pscID = pscID;
    }

    private static final String createDeployedName(String name, ConfigurationID configID, HostID hostID, VMComponentDefnID vmComponentID) {
        Assertion.isNotNull((Object)configID);
        Assertion.isNotNull((Object)name);
        Assertion.isNotNull((Object)hostID);
        Assertion.isNotNull((Object)vmComponentID);
        StringBuffer sb = new StringBuffer(configID.getName());
        sb.append('.');
        sb.append(hostID.getName());
        sb.append('.');
        sb.append(vmComponentID.getName());
        sb.append('.');
        sb.append(name);
        return sb.toString();
    }

    private static final String createDeployedName(String name, ConfigurationID configID, HostID hostID, VMComponentDefnID vmComponentID, ProductServiceConfigID pscID, ServiceComponentDefnID serviceComponentID) {
        Assertion.isNotNull((Object)configID);
        Assertion.isNotNull((Object)pscID);
        Assertion.isNotNull((Object)hostID);
        Assertion.isNotNull((Object)vmComponentID);
        Assertion.isNotNull((Object)serviceComponentID);
        StringBuffer sb = new StringBuffer(configID.getName());
        sb.append('.');
        sb.append(hostID.getName());
        sb.append('.');
        sb.append(vmComponentID.getName());
        sb.append('.');
        sb.append(pscID.getName());
        sb.append('.');
        sb.append(serviceComponentID.getName());
        sb.append('.');
        sb.append(name);
        return sb.toString();
    }

    public ConfigurationID getConfigID() {
        return this.configID;
    }

    public HostID getHostID() {
        return this.hostID;
    }

    public VMComponentDefnID getVMID() {
        return this.vmID;
    }

    public ServiceComponentDefnID getServiceID() {
        return this.serviceID;
    }

    public ProductServiceConfigID getPscID() {
        return this.pscID;
    }
}

