/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.xml;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.util.ConfigObjectsNotResolvableException;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLConfig_42_HelperImpl;
import com.metamatrix.common.config.xml.XMLConfig_42_Visitor;
import com.metamatrix.common.config.xml.XMLConfig_Base_ImportExportUtility;
import com.metamatrix.common.config.xml.XMLHelper;
import com.metamatrix.common.config.xml.XMLHelperUtil;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.namedobject.BaseObject;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.ReflectionHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class XMLConfig_42_ImportExportUtility
extends XMLConfig_Base_ImportExportUtility {
    private static final String CONFIG_MODEL_CLASS = "com.metamatrix.common.config.model.ConfigurationModelContainerImpl";
    private XMLConfig_42_HelperImpl xmlHelper = null;

    public void exportConfiguration(OutputStream stream, Collection configurationObjects, Properties props) throws IOException, ConfigObjectsNotResolvableException {
        Assertion.isNotNull((Object)configurationObjects);
        Assertion.isNotNull((Object)stream);
        List[] lists = this.segregateConfigurationObjects(configurationObjects);
        this.resolveConfigurationObjects(lists);
        ConfigurationModelContainer cmc = null;
        try {
            ArrayList<Collection> parms = new ArrayList<Collection>(1);
            parms.add(configurationObjects);
            cmc = (ConfigurationModelContainer)ReflectionHelper.create((String)CONFIG_MODEL_CLASS, parms, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (MetaMatrixCoreException err) {
            throw new IOException(err.getMessage());
        }
        this.getXMLHelper();
        XMLConfig_42_Visitor visitor = new XMLConfig_42_Visitor(this.xmlHelper);
        Element root = this.xmlHelper.createRootConfigurationDocumentElement();
        Document doc = new Document(root);
        root = XMLHelperUtil.addHeaderElement(root, props);
        Configuration config = cmc.getConfiguration();
        Element configElement = visitor.visitComponent(config);
        root.addContent((Content)configElement);
        try {
            Iterator hostIt = cmc.getHosts().iterator();
            while (hostIt.hasNext()) {
                Host h = (Host)hostIt.next();
                Element hostElement = visitor.visitComponent(h);
                configElement.addContent((Content)hostElement);
                Iterator vmsIt = cmc.getConfiguration().getVMsForHost((HostID)h.getID()).iterator();
                while (vmsIt.hasNext()) {
                    VMComponentDefn vm = (VMComponentDefn)vmsIt.next();
                    Element vmElement = visitor.visitComponent(vm);
                    hostElement.addContent((Content)vmElement);
                    HashMap pscSvcMap = new HashMap(10);
                    Iterator depIt = cmc.getConfiguration().getDeployedServicesForVM(vm).iterator();
                    Collection<DeployedComponent> svcs = null;
                    while (depIt.hasNext()) {
                        DeployedComponent dc = (DeployedComponent)depIt.next();
                        if (!pscSvcMap.containsKey(dc.getProductServiceConfigID())) {
                            svcs = new ArrayList();
                            pscSvcMap.put(dc.getProductServiceConfigID(), svcs);
                        } else {
                            svcs = (Collection)pscSvcMap.get(dc.getProductServiceConfigID());
                        }
                        svcs.add(dc);
                    }
                    Iterator pscIt = pscSvcMap.keySet().iterator();
                    while (pscIt.hasNext()) {
                        ProductServiceConfigID pscID = (ProductServiceConfigID)pscIt.next();
                        ProductServiceConfig psc = cmc.getConfiguration().getPSC(pscID);
                        Element pscElement = this.getXMLHelper().createDeployedProductServiceConfigElement(psc);
                        vmElement.addContent((Content)pscElement);
                        Collection depsvcs = (Collection)pscSvcMap.get(pscID);
                        Iterator svcIt = depsvcs.iterator();
                        while (svcIt.hasNext()) {
                            DeployedComponent dc = (DeployedComponent)svcIt.next();
                            Element svcElement = visitor.visitComponent(dc);
                            pscElement.addContent((Content)svcElement);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ConfigObjectsNotResolvableException((Throwable)e, (Object)"Error exporting configuration");
        }
        Element pscsElement = this.xmlHelper.createProductServiceConfigsElement();
        root.addContent((Content)pscsElement);
        Collection pscs = cmc.getConfiguration().getPSCs();
        if (pscs != null && pscs.size() > 0) {
            Iterator iterator = pscs.iterator();
            while (iterator.hasNext()) {
                ProductServiceConfig type = (ProductServiceConfig)iterator.next();
                Element productTypeElement = visitor.visitComponent(type);
                pscsElement.addContent((Content)productTypeElement);
            }
        }
        Element productTypesElement = this.xmlHelper.createProductTypesElement();
        root.addContent((Content)productTypesElement);
        Collection productTypes = cmc.getProductTypes();
        if (productTypes != null && productTypes.size() > 0) {
            Iterator iterator = productTypes.iterator();
            while (iterator.hasNext()) {
                ProductType type = (ProductType)iterator.next();
                Element productTypeElement = visitor.visitComponent(type);
                productTypesElement.addContent((Content)productTypeElement);
            }
        }
        Element resourcePoolsElement = this.xmlHelper.createResourcePoolsElement();
        root.addContent((Content)resourcePoolsElement);
        Collection pools = cmc.getConnectionPools();
        if (pools != null && pools.size() > 0) {
            Iterator iterator = pools.iterator();
            while (iterator.hasNext()) {
                ResourceDescriptor type = (ResourceDescriptor)iterator.next();
                Element resourceElement = visitor.visitComponent(type);
                resourcePoolsElement.addContent((Content)resourceElement);
            }
        }
        Element connectorsElement = this.xmlHelper.createConnectorBindingsElement();
        root.addContent((Content)connectorsElement);
        Collection bindings = cmc.getConfiguration().getConnectorBindings();
        if (bindings != null && bindings.size() > 0) {
            Iterator iterator = bindings.iterator();
            while (iterator.hasNext()) {
                ConnectorBinding connector = (ConnectorBinding)iterator.next();
                Element connElement = visitor.visitConnectorBindingComponent(connector);
                connectorsElement.addContent((Content)connElement);
            }
        }
        Element servicessElement = this.xmlHelper.createServiceComponentDefnsElement();
        root.addContent((Content)servicessElement);
        Collection svcdefns = cmc.getConfiguration().getServiceComponentDefns();
        if (svcdefns != null && svcdefns.size() > 0) {
            Iterator iterator = svcdefns.iterator();
            while (iterator.hasNext()) {
                ServiceComponentDefn svc = (ServiceComponentDefn)iterator.next();
                Element svcElement = visitor.visitComponent(svc);
                servicessElement.addContent((Content)svcElement);
            }
        }
        Element resourcesElement = this.xmlHelper.createSharedResourcesElement();
        root.addContent((Content)resourcesElement);
        Collection sharedResources = cmc.getResources();
        if (sharedResources != null && sharedResources.size() > 0) {
            Iterator iterator = sharedResources.iterator();
            while (iterator.hasNext()) {
                SharedResource resource = (SharedResource)iterator.next();
                Element resourceElement = visitor.visitComponent(resource);
                resourcesElement.addContent((Content)resourceElement);
            }
        }
        Element componentTypesElement = this.xmlHelper.createComponentTypesElement();
        root.addContent((Content)componentTypesElement);
        Map compTypes = cmc.getComponentTypes();
        if (compTypes != null && compTypes.size() > 0) {
            Iterator iterator = compTypes.values().iterator();
            while (iterator.hasNext()) {
                ComponentType componentType = (ComponentType)iterator.next();
                Element componentTypeElement = visitor.visitComponent(componentType);
                componentTypesElement.addContent((Content)componentTypeElement);
            }
        }
        this.getXMLReaderWriter().writeDocument(doc, stream);
        stream.close();
        LogManager.logInfo("CONFIG", CommonPlugin.Util.getString("MSG.003.001.0003", (Object)cmc.getConfigurationID().getFullName()));
    }

    public Collection importConfigurationObjects(Element root, ConfigurationObjectEditor editor, String name) throws IOException, ConfigObjectsNotResolvableException, InvalidConfigurationElementException {
        Element resourcePoolsElement;
        ArrayList productTypes;
        Element productTypesElement;
        Assertion.isNotNull((Object)root);
        Assertion.isNotNull((Object)editor);
        ArrayList<BaseObject> configurationObjects = new ArrayList<BaseObject>();
        this.getXMLHelper();
        Element configurationElement = root.getChild("Configuration");
        if (configurationElement == null) {
            throw new ConfigObjectsNotResolvableException("ERR.003.001.0004", (Object)CommonPlugin.Util.getString("ERR.003.001.0004"));
        }
        Configuration config = this.xmlHelper.createConfiguration(configurationElement, editor, name);
        ConfigurationID configID = (ConfigurationID)config.getID();
        configurationObjects.add(config);
        this.xmlHelper.addProperties(configurationElement, config, editor);
        Collection componentTypes = this.createComponentTypes(root, editor);
        HashMap<BaseID, ComponentType> componentTypeMap = new HashMap<BaseID, ComponentType>();
        if (componentTypes != null) {
            Iterator it = componentTypes.iterator();
            while (it.hasNext()) {
                ComponentType type = (ComponentType)it.next();
                componentTypeMap.put(type.getID(), type);
                configurationObjects.add(type);
            }
        }
        if ((productTypesElement = root.getChild("ProductTypes")) != null && (productTypes = productTypesElement.getChildren("ProductType")) != null && productTypes.size() > 0) {
            productTypes = new ArrayList(productTypes);
            this.xmlHelper.orderComponentTypeElementList(productTypes);
            Iterator iterator = productTypes.iterator();
            while (iterator.hasNext()) {
                Element productTypeElement = (Element)iterator.next();
                ProductType type = this.xmlHelper.createProductType(productTypeElement, editor, componentTypeMap, null);
                configurationObjects.add(type);
            }
        }
        Element resourcesElement = root.getChild("SharedResources");
        List resources = null;
        resources = resourcesElement != null ? resourcesElement.getChildren("Resource") : Collections.EMPTY_LIST;
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            Element resourceElement = (Element)iterator.next();
            SharedResource resource = this.xmlHelper.createSharedResource(resourceElement, editor);
            configurationObjects.add(resource);
        }
        HashMap<String, ProductServiceConfig> pscMap = new HashMap<String, ProductServiceConfig>(1);
        Element productServiceConfigsElement = root.getChild("ProductServiceConfigs");
        if (productServiceConfigsElement != null) {
            List productServiceConfigElements = productServiceConfigsElement.getChildren("PSC");
            pscMap = new HashMap(productServiceConfigElements.size());
            iterator = productServiceConfigElements.iterator();
            while (iterator.hasNext()) {
                Element productServiceConfigElement = (Element)iterator.next();
                ProductServiceConfig productServiceConfig = this.xmlHelper.createProductServiceConfig(productServiceConfigElement, configID, editor, null);
                configurationObjects.add(productServiceConfig);
                pscMap.put(productServiceConfig.getName(), productServiceConfig);
            }
        }
        if ((resourcePoolsElement = root.getChild("ConnectionPools")) != null) {
            List resourcePoolsElements = resourcePoolsElement.getChildren("ConnectionPool");
            iterator = resourcePoolsElements.iterator();
            while (iterator.hasNext()) {
                Element resourcePoolElement = (Element)iterator.next();
                ResourceDescriptor pool = this.xmlHelper.createResourcePool(resourcePoolElement, configID, editor);
                configurationObjects.add(pool);
            }
        }
        Collection bindings = this.createConnectorBindings(configID, root, editor, true);
        HashMap<BaseID, ComponentDefn> serviceComponentDefnMap = new HashMap<BaseID, ComponentDefn>();
        Iterator itb = bindings.iterator();
        while (itb.hasNext()) {
            ComponentDefn defn = (ComponentDefn)itb.next();
            serviceComponentDefnMap.put(defn.getID(), defn);
        }
        Element serviceComponentDefnsElement = root.getChild("Services");
        if (serviceComponentDefnsElement != null) {
            List serviceComponentDefnElements = serviceComponentDefnsElement.getChildren("Service");
            iterator = serviceComponentDefnElements.iterator();
            while (iterator.hasNext()) {
                Element serviceComponentDefnElement = (Element)iterator.next();
                ComponentDefn defn = this.xmlHelper.createServiceComponentDefn(serviceComponentDefnElement, config, editor, null);
                serviceComponentDefnMap.put(defn.getID(), defn);
                configurationObjects.add(defn);
            }
        }
        configurationObjects.addAll(bindings);
        List hostElements = configurationElement.getChildren("Host");
        Iterator hostiterator = hostElements.iterator();
        Host host = null;
        HostID hostID = null;
        while (hostiterator.hasNext()) {
            Element hostElement = (Element)hostiterator.next();
            host = this.xmlHelper.createHost(hostElement, configID, editor, null);
            hostID = (HostID)host.getID();
            configurationObjects.add(host);
            List vmElements = hostElement.getChildren("Process");
            Iterator vmIt = vmElements.iterator();
            while (vmIt.hasNext()) {
                Element vmElement = (Element)vmIt.next();
                VMComponentDefn vm = this.xmlHelper.createVMComponentDefn(vmElement, configID, hostID, editor, null);
                VMComponentDefnID vmID = (VMComponentDefnID)vm.getID();
                configurationObjects.add(vm);
                List pscElements = vmElement.getChildren("PSC");
                Iterator pscIt = pscElements.iterator();
                while (pscIt.hasNext()) {
                    Element pscElement = (Element)pscIt.next();
                    String pscName = pscElement.getAttributeValue("Name");
                    ProductServiceConfig psc = (ProductServiceConfig)pscMap.get(pscName);
                    List svcElements = pscElement.getChildren("Service");
                    Iterator svcIt = svcElements.iterator();
                    while (svcIt.hasNext()) {
                        Element svcElement = (Element)svcIt.next();
                        DeployedComponent dc = this.xmlHelper.createDeployedServiceComponent(svcElement, configID, hostID, vmID, (ProductServiceConfigID)psc.getID(), componentTypeMap, editor);
                        configurationObjects.add(dc);
                    }
                }
            }
        }
        this.resolveConfigurationObjects(configurationObjects);
        return configurationObjects;
    }

    protected XMLHelper getXMLHelper() {
        if (this.xmlHelper == null) {
            this.xmlHelper = new XMLConfig_42_HelperImpl();
        }
        return this.xmlHelper;
    }

    public ComponentType importComponentType(Element root, ConfigurationObjectEditor editor, String name) throws IOException, InvalidConfigurationElementException {
        Assertion.isNotNull((Object)editor);
        ComponentType t = this.createComponentType(root, editor, name);
        return t;
    }

    public Collection importComponentTypes(Element root, ConfigurationObjectEditor editor) throws IOException, InvalidConfigurationElementException {
        Assertion.isNotNull((Object)editor);
        Collection connectorTypes = this.createComponentTypes(root, editor);
        return connectorTypes;
    }

    protected ComponentType createComponentType(Element root, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        XMLHelper helper = this.getXMLHelper();
        Element componentTypesElement = root.getChild("ComponentTypes");
        if (componentTypesElement == null) {
            throw new InvalidConfigurationElementException("ERR.003.001.0008", (Object)CommonPlugin.Util.getString("ERR.003.001.0008", (Object)"ComponentTypes"));
        }
        Element componentTypeElement = componentTypesElement.getChild("ComponentType");
        if (componentTypeElement == null) {
            throw new InvalidConfigurationElementException("ERR.003.001.0008", (Object)CommonPlugin.Util.getString("ERR.003.001.0008", (Object)"ComponentType"));
        }
        return helper.createComponentType(componentTypeElement, editor, name, true);
    }

    protected Collection createComponentTypes(Element root, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        Element componentTypesElement = root.getChild("ComponentTypes");
        if (componentTypesElement == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList componentTypes = new ArrayList(componentTypesElement.getChildren("ComponentType"));
        ArrayList<ComponentType> connObjects = null;
        if (componentTypes != null) {
            connObjects = new ArrayList<ComponentType>(componentTypes.size());
            this.getXMLHelper().orderComponentTypeElementList(componentTypes);
            Iterator iterator = componentTypes.iterator();
            while (iterator.hasNext()) {
                Element connElement = (Element)iterator.next();
                ComponentType type = this.getXMLHelper().createComponentType(connElement, editor, null, true);
                connObjects.add(type);
            }
        } else {
            return Collections.EMPTY_LIST;
        }
        return connObjects;
    }
}

