/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.connection.jdbc;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.connection.ManagedConnection;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class JDBCMgdResourceConnection
extends ManagedConnection {
    private Connection jdbcConnection;

    public JDBCMgdResourceConnection(Properties env, String userName) {
        super(env);
        super.setUserName(userName);
    }

    public Connection getConnection() {
        return this.jdbcConnection;
    }

    protected void openConnection() throws ManagedConnectionException {
        try {
            this.jdbcConnection = JDBCConnectionPoolHelper.getConnection(this.getEnvironment(), this.getUserName());
        }
        catch (ResourcePoolException rpe) {
            throw new ManagedConnectionException((Throwable)((Object)rpe), "ERR.003.010.0010", CommonPlugin.Util.getString("ERR.003.010.0010", (Object)this.getUserName()));
        }
    }

    protected void closeConnection() throws ManagedConnectionException {
        if (this.jdbcConnection != null) {
            LogManager.logTrace("RESOURCE_POOLING", "Closing connection to JDBC");
            try {
                boolean isClosed = false;
                try {
                    isClosed = this.jdbcConnection.isClosed();
                    if (!isClosed) {
                        this.jdbcConnection.commit();
                    }
                }
                catch (Exception sqle) {
                    LogManager.logWarning("RESOURCE_POOLING", (Throwable)sqle, CommonPlugin.Util.getString("ERR.003.010.0011"));
                }
                if (!isClosed) {
                    this.jdbcConnection.close();
                }
            }
            catch (Exception e) {
                throw new ManagedConnectionException(e, "ERR.003.010.0012", CommonPlugin.Util.getString("ERR.003.010.0012", (Object)this.getEnvironment().getProperty("com.metamatrix.common.connection.ManagedConnection.Database", "NoDatabaseProperty")));
            }
            finally {
                this.jdbcConnection = null;
            }
        }
    }

    protected void prepareForRead() throws ManagedConnectionException {
        if (this.jdbcConnection != null) {
            try {
                LogManager.logTrace("RESOURCE_POOLING", "Attempting to set JDBC transaction to READ ONLY");
                this.jdbcConnection.setReadOnly(true);
            }
            catch (SQLException e) {
                LogManager.logTrace("RESOURCE_POOLING", "UNABLE to set JDBC transaction to READ ONLY");
            }
        }
    }

    protected void prepareForWrite() throws ManagedConnectionException {
        if (this.jdbcConnection != null) {
            try {
                LogManager.logTrace("RESOURCE_POOLING", "Attempting to set JDBC transaction to WRITE");
                this.jdbcConnection.setReadOnly(false);
            }
            catch (SQLException e) {
                LogManager.logTrace("RESOURCE_POOLING", "UNABLE to set JDBC transaction to WRITE");
            }
        }
    }

    protected void performCommit() throws ManagedConnectionException {
        if (this.jdbcConnection != null) {
            try {
                LogManager.logTrace("RESOURCE_POOLING", "Attempting to commit JDBC transaction");
                this.jdbcConnection.commit();
            }
            catch (SQLException e) {
                throw new ManagedConnectionException(e, "ERR.003.010.0013", CommonPlugin.Util.getString("ERR.003.010.0013", (Object)this.getEnvironment().getProperty("com.metamatrix.common.connection.ManagedConnection.Database", "NoDatabaseProperty")));
            }
        }
    }

    protected void performRollback() throws ManagedConnectionException {
        if (this.jdbcConnection != null) {
            try {
                this.jdbcConnection.rollback();
            }
            catch (SQLException e) {
                throw new ManagedConnectionException(e, "ERR.003.010.0014", CommonPlugin.Util.getString("ERR.003.010.0014", (Object)this.getEnvironment().getProperty("com.metamatrix.common.connection.ManagedConnection.Database", "NoDatabaseProperty")));
            }
        }
    }
}

