/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.connection.ManagedConnectionException;
import com.metamatrix.common.connection.TransactionMgr;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.ExtensionModuleEvent;
import com.metamatrix.common.extensionmodule.ExtensionModuleTypes;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleOrderingException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleRuntimeException;
import com.metamatrix.common.extensionmodule.exception.InvalidExtensionModuleTypeException;
import com.metamatrix.common.extensionmodule.spi.ExtensionModuleTransaction;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.VMMessageBus;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.ArgCheck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;

public class ExtensionModuleManager {
    public static final int SOURCE_NAME_LENGTH_LIMIT = 255;
    public static final int SOURCE_DESCRIPTION_LENGTH_LIMIT = 255;
    public static final int SOURCE_CONTENTS_LENGTH_LIMIT = 1000000000;
    private static final String LOG_CONTEXT = "EXTENSION_MODULE";
    private TransactionMgr transMgr;
    private static ExtensionModuleManager extensionModuleManager;
    private boolean isInitialized = false;
    private static final String NOT_INITIALIZED_MESSAGE;
    static /* synthetic */ Class class$com$metamatrix$common$extensionmodule$spi$jdbc$JDBCExtensionModuleWriter;

    public static synchronized ExtensionModuleManager getInstance() {
        if (extensionModuleManager == null) {
            extensionModuleManager = new ExtensionModuleManager();
            extensionModuleManager.init();
        }
        return extensionModuleManager;
    }

    static synchronized ExtensionModuleManager getInstance(Properties env) {
        if (extensionModuleManager == null) {
            extensionModuleManager = new ExtensionModuleManager();
            extensionModuleManager.init(env);
        }
        return extensionModuleManager;
    }

    /*
     * Loose catch block
     */
    public ExtensionModuleDescriptor addSource(String principalName, String type, String sourceName, byte[] source, String description, boolean enabled) throws DuplicateExtensionModuleException, InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        ExtensionModuleDescriptor result;
        block10: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
            ArgCheck.isNotNull((Object)principalName);
            ArgCheck.isNotNull((Object)type);
            ArgCheck.isNotNull((Object)sourceName);
            ArgCheck.isNotNull((Object)source);
            ArgCheck.isNotZeroLength((String)principalName);
            ArgCheck.isNotZeroLength((String)type);
            ArgCheck.isNotZeroLength((String)sourceName);
            ArgCheck.isTrue((sourceName.length() <= 255 ? 1 : 0) != 0, (String)CommonPlugin.Util.getString("ERR.014.004.0009", 255));
            ArgCheck.isTrue((source.length <= 1000000000 ? 1 : 0) != 0, (String)CommonPlugin.Util.getString("ERR.014.004.0011", 1000000000));
            ExtensionModuleTypes.checkTypeIsValid(type);
            description = this.adjustLengthToFit(description);
            LogManager.logDetail(LOG_CONTEXT, new Object[]{"Adding module", sourceName, "of type", type, "for principal", principalName});
            result = null;
            ExtensionModuleTransaction transaction = null;
            transaction = this.getWriteTransaction();
            result = transaction.addSource(principalName, type, sourceName, source, this.getChecksum(source), description, enabled);
            transaction.commit();
            ExtensionModuleManager.notifyFileChanged();
            Object var11_9 = null;
            if (transaction == null) break block10;
            try {
                transaction.close();
            }
            catch (Exception txne) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
            transaction = null;
            {
                break block10;
                catch (DuplicateExtensionModuleException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.014.004.0013", new Object[]{sourceName, principalName}));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0013", new Object[]{sourceName, principalName}));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0013", CommonPlugin.Util.getString("ERR.014.004.0013", (Object)sourceName, (Object)principalName));
                }
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                    }
                    transaction = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    private String adjustLengthToFit(String oriString) {
        if (oriString != null && oriString.length() > 255) {
            oriString = oriString.substring(0, 255);
        }
        return oriString;
    }

    /*
     * Loose catch block
     */
    public void removeSource(String principalName, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        block10: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
            ArgCheck.isNotNull((Object)principalName);
            ArgCheck.isNotNull((Object)sourceName);
            ArgCheck.isNotZeroLength((String)principalName);
            ArgCheck.isNotZeroLength((String)sourceName);
            LogManager.logTrace(LOG_CONTEXT, new Object[]{"Removing module", sourceName, "for principal", principalName});
            ExtensionModuleTransaction transaction = null;
            transaction = this.getWriteTransaction();
            transaction.removeSource(principalName, sourceName);
            transaction.commit();
            ExtensionModuleManager.notifyFileChanged();
            Object var6_4 = null;
            if (transaction == null) break block10;
            try {
                transaction.close();
            }
            catch (Exception txne) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
            transaction = null;
            {
                break block10;
                catch (ExtensionModuleNotFoundException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.014.004.0015", new Object[]{sourceName, principalName}));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0015", new Object[]{sourceName, principalName}));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0015", CommonPlugin.Util.getString("ERR.014.004.0015", (Object)sourceName, (Object)principalName));
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                    }
                    transaction = null;
                }
                throw throwable;
            }
        }
    }

    public Collection getSourceTypes() throws MetaMatrixComponentException {
        ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
        return ExtensionModuleTypes.ALL_TYPES;
    }

    /*
     * Loose catch block
     */
    public List getSourceNames() throws MetaMatrixComponentException {
        List result;
        block9: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
            result = null;
            ExtensionModuleTransaction transaction = null;
            transaction = this.getReadTransaction();
            result = transaction.getSourceNames();
            transaction.commit();
            Object var5_3 = null;
            if (transaction == null) break block9;
            try {
                transaction.close();
            }
            catch (Exception txne) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
            transaction = null;
            {
                break block9;
                catch (MetaMatrixComponentException e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.014.004.0016"));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0016"));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0016", CommonPlugin.Util.getString("ERR.014.004.0016"));
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                    }
                    transaction = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public List getSourceDescriptors() throws MetaMatrixComponentException {
        List result;
        block9: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
            result = null;
            ExtensionModuleTransaction transaction = null;
            transaction = this.getReadTransaction();
            result = transaction.getSourceDescriptors();
            transaction.commit();
            Object var5_3 = null;
            if (transaction == null) break block9;
            try {
                transaction.close();
            }
            catch (Exception txne) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
            transaction = null;
            {
                break block9;
                catch (MetaMatrixComponentException e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.014.004.0017"));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0017"));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0017", CommonPlugin.Util.getString("ERR.014.004.0017"));
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                    }
                    transaction = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public List getSourceDescriptors(String type) throws InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        List result;
        block9: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
            ArgCheck.isNotNull((Object)type);
            ArgCheck.isNotZeroLength((String)type);
            ExtensionModuleTypes.checkTypeIsValid(type);
            result = null;
            ExtensionModuleTransaction transaction = null;
            transaction = this.getReadTransaction();
            boolean includeDisabled = true;
            result = transaction.getSourceDescriptors(type, includeDisabled);
            transaction.commit();
            Object var6_7 = null;
            if (transaction == null) break block9;
            try {
                transaction.close();
            }
            catch (Exception txne) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
            transaction = null;
            {
                break block9;
                catch (MetaMatrixComponentException e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.014.004.0018", (Object)type));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0018", (Object)type));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0018", CommonPlugin.Util.getString("ERR.014.004.0018", (Object)type));
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                    }
                    transaction = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSourceInUse(String sourceName) throws MetaMatrixComponentException {
        block11: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, ExtensionModuleManager.NOT_INITIALIZED_MESSAGE);
            ArgCheck.isNotNull((Object)sourceName);
            ArgCheck.isNotZeroLength((String)sourceName);
            transaction = null;
            try {
                try {
                    transaction = this.getReadTransaction();
                    result = transaction.isNameInUse(sourceName);
                    transaction.commit();
                    var4_6 = result;
                    var6_7 = null;
                    if (transaction == null) return var4_6;
                }
                catch (MetaMatrixComponentException e) {
                    LogManager.logError("EXTENSION_MODULE", (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0019", (Object)sourceName));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError("EXTENSION_MODULE", (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0019", (Object)sourceName));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0019", CommonPlugin.Util.getString("ERR.014.004.0019", (Object)sourceName));
                }
            }
            catch (Throwable var5_11) {
                var6_8 = null;
                if (transaction == null) throw var5_11;
                try {
                    transaction.close();
                }
                catch (Exception txne) {
                    LogManager.logWarning("EXTENSION_MODULE", (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                }
                transaction = null;
                throw var5_11;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 122->131)] { 
lbl35:
            // 1 sources

            transaction.close();
            break block11;
lbl37:
            // 1 sources

            catch (Exception txne) {
                LogManager.logWarning("EXTENSION_MODULE", (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
        }
        transaction = null;
        return var4_6;
    }

    /*
     * Loose catch block
     */
    public ExtensionModuleDescriptor getSourceDescriptor(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleDescriptor result;
        block10: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
            ArgCheck.isNotNull((Object)sourceName);
            ArgCheck.isNotZeroLength((String)sourceName);
            result = null;
            ExtensionModuleTransaction transaction = null;
            transaction = this.getReadTransaction();
            result = transaction.getSourceDescriptor(sourceName);
            transaction.commit();
            Object var6_4 = null;
            if (transaction == null) break block10;
            try {
                transaction.close();
            }
            catch (Exception txne) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
            transaction = null;
            {
                break block10;
                catch (ExtensionModuleNotFoundException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.014.004.0019", (Object)sourceName));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0019", (Object)sourceName));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0019", CommonPlugin.Util.getString("ERR.014.004.0019", (Object)sourceName));
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                    }
                    transaction = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public List setSearchOrder(String principalName, List sourceNames) throws ExtensionModuleOrderingException, MetaMatrixComponentException {
        List result;
        block10: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
            ArgCheck.isNotNull((Object)principalName);
            ArgCheck.isNotNull((Object)sourceNames);
            ArgCheck.isNotZeroLength((String)principalName);
            LogManager.logTrace(LOG_CONTEXT, new Object[]{"Setting search order for module(s)", sourceNames, "for principal", principalName});
            result = null;
            ExtensionModuleTransaction transaction = null;
            transaction = this.getWriteTransaction();
            transaction.setSearchOrder(principalName, sourceNames);
            transaction.commit();
            transaction = this.getReadTransaction();
            result = transaction.getSourceDescriptors();
            transaction.commit();
            ExtensionModuleManager.notifyFileChanged();
            Object var7_5 = null;
            if (transaction == null) break block10;
            try {
                transaction.close();
            }
            catch (Exception txne) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
            transaction = null;
            {
                break block10;
                catch (ExtensionModuleOrderingException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.014.004.0020", (Object)principalName));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0020", (Object)principalName));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0020", CommonPlugin.Util.getString("ERR.014.004.0020", (Object)principalName));
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                    }
                    transaction = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public List setEnabled(String principalName, Collection sourceNames, boolean enabled) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ArrayList<ExtensionModuleDescriptor> result;
        block11: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
            ArgCheck.isNotNull((Object)principalName);
            ArgCheck.isNotNull((Object)sourceNames);
            ArgCheck.isNotZeroLength((String)principalName);
            LogManager.logTrace(LOG_CONTEXT, new Object[]{"Setting 'enabled' attribute of module(s)", sourceNames, "to", enabled ? Boolean.TRUE : Boolean.FALSE, "for principal", principalName});
            result = null;
            ExtensionModuleTransaction transaction = null;
            transaction = this.getWriteTransaction();
            transaction.setEnabled(principalName, sourceNames, enabled);
            transaction.commit();
            transaction = this.getReadTransaction();
            List descriptors = transaction.getSourceDescriptors();
            transaction.commit();
            ExtensionModuleManager.notifyFileChanged();
            result = new ArrayList<ExtensionModuleDescriptor>(descriptors.size());
            ExtensionModuleDescriptor descriptor = null;
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                descriptor = (ExtensionModuleDescriptor)i.next();
                if (!sourceNames.contains(descriptor.getName())) continue;
                result.add(descriptor);
            }
            Object var10_12 = null;
            if (transaction == null) break block11;
            try {
                transaction.close();
            }
            catch (Exception txne) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
            transaction = null;
            {
                break block11;
                catch (ExtensionModuleNotFoundException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.014.004.0021", (Object)principalName));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0021", (Object)principalName));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0021", CommonPlugin.Util.getString("ERR.014.004.0021", (Object)principalName));
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                    }
                    transaction = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public byte[] getSource(String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        byte[] result;
        block10: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
            ArgCheck.isNotNull((Object)sourceName);
            ArgCheck.isNotZeroLength((String)sourceName);
            LogManager.logDetail(LOG_CONTEXT, new Object[]{"Attempting to load extension module", sourceName});
            result = null;
            ExtensionModuleTransaction transaction = null;
            transaction = this.getReadTransaction();
            result = transaction.getSource(sourceName);
            transaction.commit();
            Object var6_4 = null;
            if (transaction == null) break block10;
            try {
                transaction.close();
            }
            catch (Exception txne) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
            transaction = null;
            {
                break block10;
                catch (ExtensionModuleNotFoundException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.014.004.0022", (Object)sourceName));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0022", (Object)sourceName));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0022", CommonPlugin.Util.getString("ERR.014.004.0022", (Object)sourceName));
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                    }
                    transaction = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public ExtensionModuleDescriptor setSource(String principalName, String sourceName, byte[] source) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleDescriptor result;
        block10: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
            ArgCheck.isNotNull((Object)principalName);
            ArgCheck.isNotNull((Object)sourceName);
            ArgCheck.isNotZeroLength((String)principalName);
            ArgCheck.isNotZeroLength((String)sourceName);
            ArgCheck.isTrue((source.length <= 1000000000 ? 1 : 0) != 0, (String)CommonPlugin.Util.getString("ERR.014.004.0011", 1000000000));
            LogManager.logTrace(LOG_CONTEXT, new Object[]{"Setting content of module", sourceName, "for principal", principalName});
            result = null;
            ExtensionModuleTransaction transaction = null;
            transaction = this.getWriteTransaction();
            result = transaction.setSource(principalName, sourceName, source, this.getChecksum(source));
            transaction.commit();
            ExtensionModuleManager.notifyFileChanged();
            Object var8_6 = null;
            if (transaction == null) break block10;
            try {
                transaction.close();
            }
            catch (Exception txne) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
            transaction = null;
            {
                break block10;
                catch (ExtensionModuleNotFoundException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.014.004.0012", (Object)sourceName));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0012", (Object)sourceName));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0012", CommonPlugin.Util.getString("ERR.014.004.0012", (Object)sourceName));
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                    }
                    transaction = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public ExtensionModuleDescriptor setSourceName(String principalName, String sourceName, String newName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleDescriptor result;
        block10: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
            ArgCheck.isNotNull((Object)principalName);
            ArgCheck.isNotNull((Object)sourceName);
            ArgCheck.isNotNull((Object)newName);
            ArgCheck.isNotZeroLength((String)principalName);
            ArgCheck.isNotZeroLength((String)sourceName);
            ArgCheck.isNotZeroLength((String)newName);
            ArgCheck.isTrue((sourceName.length() <= 255 ? 1 : 0) != 0, (String)CommonPlugin.Util.getString("ERR.014.004.0009", 255));
            LogManager.logTrace(LOG_CONTEXT, new Object[]{"Changing name of module from", sourceName, "to", newName, "for principal", principalName});
            result = null;
            ExtensionModuleTransaction transaction = null;
            transaction = this.getWriteTransaction();
            result = transaction.setSourceName(principalName, sourceName, newName);
            transaction.commit();
            ExtensionModuleManager.notifyFileChanged();
            Object var8_6 = null;
            if (transaction == null) break block10;
            try {
                transaction.close();
            }
            catch (Exception txne) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
            transaction = null;
            {
                break block10;
                catch (ExtensionModuleNotFoundException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.014.004.0023", (Object)sourceName));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0023", (Object)sourceName));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0023", CommonPlugin.Util.getString("ERR.014.004.0023", (Object)sourceName));
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                    }
                    transaction = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public ExtensionModuleDescriptor setSourceDescription(String principalName, String sourceName, String description) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleDescriptor result;
        block10: {
            ExtensionModuleManager.checkIsTrue(this.isInitialized, NOT_INITIALIZED_MESSAGE);
            ArgCheck.isNotNull((Object)principalName);
            ArgCheck.isNotNull((Object)sourceName);
            ArgCheck.isNotZeroLength((String)principalName);
            ArgCheck.isNotZeroLength((String)sourceName);
            description = this.adjustLengthToFit(description);
            LogManager.logTrace(LOG_CONTEXT, new Object[]{"Setting description of module", sourceName, "for principal", principalName});
            result = null;
            ExtensionModuleTransaction transaction = null;
            transaction = this.getWriteTransaction();
            result = transaction.setSourceDescription(principalName, sourceName, description);
            transaction.commit();
            Object var8_6 = null;
            if (transaction == null) break block10;
            try {
                transaction.close();
            }
            catch (Exception txne) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
            }
            transaction = null;
            {
                break block10;
                catch (ExtensionModuleNotFoundException e) {
                    throw e;
                }
                catch (MetaMatrixComponentException e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)((Object)e), CommonPlugin.Util.getString("ERR.014.004.0024", (Object)sourceName));
                    throw e;
                }
                catch (Exception e) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0024", (Object)sourceName));
                    throw new MetaMatrixComponentException(e, "ERR.014.004.0024", CommonPlugin.Util.getString("ERR.014.004.0024", (Object)sourceName));
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (transaction != null) {
                    try {
                        transaction.close();
                    }
                    catch (Exception txne) {
                        LogManager.logWarning(LOG_CONTEXT, (Throwable)txne, CommonPlugin.Util.getString("ERR.014.004.0014"));
                    }
                    transaction = null;
                }
                throw throwable;
            }
        }
        return result;
    }

    public void init() {
        Properties resourceProps = null;
        try {
            String value;
            resourceProps = CurrentConfiguration.getResourceProperties("ExtensionSourceManager");
            resourceProps = PropertiesUtils.clone(resourceProps, false);
            String key = "metamatrix.extensionsource.connection.Factory";
            if (resourceProps.getProperty(key) == null && (value = CurrentConfiguration.getProperty(key)) != null) {
                resourceProps.setProperty(key, value);
            }
        }
        catch (Exception e) {
            LogManager.logError(LOG_CONTEXT, (Throwable)e, CommonPlugin.Util.getString("ERR.014.004.0001"));
        }
        this.init(resourceProps);
    }

    protected void init(Properties env) {
        LogManager.logDetail(LOG_CONTEXT, new Object[]{"Initializing with Properties:", env});
        this.isInitialized = true;
        try {
            env.setProperty("metamatrix.common.connection.transaction.factory", env.getProperty("metamatrix.extensionsource.connection.Factory"));
            this.transMgr = new TransactionMgr(env, "ExtensionModuleManager");
        }
        catch (Throwable e) {
            LogManager.logError(LOG_CONTEXT, e, CommonPlugin.Util.getString("ERR.014.004.0028"));
            this.isInitialized = false;
        }
        if (!this.isInitialized) {
            LogManager.logDetail(LOG_CONTEXT, new Object[]{"ExtensionModuleManager could not be initialized with properties ", env});
        }
    }

    private long getChecksum(byte[] data) {
        CRC32 algorithm = new CRC32();
        algorithm.update(data, 0, data.length);
        return algorithm.getValue();
    }

    protected ExtensionModuleTransaction getReadTransaction() throws ManagedConnectionException {
        return (ExtensionModuleTransaction)this.transMgr.getReadTransaction();
    }

    protected ExtensionModuleTransaction getWriteTransaction() throws ManagedConnectionException {
        return (ExtensionModuleTransaction)this.transMgr.getWriteTransaction();
    }

    private static final void checkIsTrue(boolean condition, String failMessage) {
        if (!condition) {
            throw new ExtensionModuleRuntimeException(failMessage);
        }
    }

    public static void notifyFileChanged() {
        try {
            VMMessageBus vmb = new VMMessageBus();
            vmb.processEvent(new ExtensionModuleEvent(class$com$metamatrix$common$extensionmodule$spi$jdbc$JDBCExtensionModuleWriter == null ? (class$com$metamatrix$common$extensionmodule$spi$jdbc$JDBCExtensionModuleWriter = ExtensionModuleManager.class$("com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleWriter")) : class$com$metamatrix$common$extensionmodule$spi$jdbc$JDBCExtensionModuleWriter, -100));
        }
        catch (Exception e) {
            LogManager.logError(LOG_CONTEXT, (Throwable)e, e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NOT_INITIALIZED_MESSAGE = CommonPlugin.Util.getString("ERR.014.004.0007");
    }
}

