/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.jdbc.metadata.Column;
import com.metamatrix.common.jdbc.metadata.Table;
import com.metamatrix.common.jdbc.metadata.UniqueKey;
import com.metamatrix.common.jdbc.syntax.ExpressionOperator;
import com.metamatrix.common.types.TransformationException;
import com.metamatrix.core.util.ReflectionHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class JDBCPlatform
implements Serializable,
Cloneable {
    private DatabaseMetaData metadata;
    protected boolean usesStreamsForBlobBinding = false;
    protected boolean usesStreamsForClobBinding;
    protected boolean isSecure = false;
    private String platformName;
    protected transient Map fieldTypes;
    protected transient String[] tableTypes = null;
    protected transient Map platformOperators;
    protected transient Map classTypes;
    protected transient Map minimumValues;
    protected transient Map maximumValues;
    protected static final String SPACE = " ";
    protected static final String COMMA = ", ";
    protected static final String PARAM = "?";
    protected static final String PERIOD = ".";
    protected static final String INSERT_INTO = "INSERT INTO ";
    protected static final String DELETE_FROM = "DELETE FROM ";
    protected static final String UPDATE = "UPDATE ";
    protected static final String SELECT = "SELECT ";
    protected static final String EQUAL = " = ";
    protected static final String FROM = " FROM ";
    protected static final String WHERE = " WHERE ";
    protected static final String ORDER_BY = " ORDER BY ";
    protected static final String GROUP_BY = " GROUP BY ";
    protected static final String SET = " SET ";
    protected static final String ON = " ON ";
    protected static final String INTO = " INTO ";
    protected static final String IN = " IN ";
    protected static final String DISTINCT = " DISTINCT ";
    protected static final String VALUES = " VALUES ";
    protected static final String AND = " AND ";
    protected static final String LENGTH = " LEN";

    protected JDBCPlatform() {
    }

    public void setConnection(Connection conn) throws MetaMatrixException {
        try {
            this.metadata = conn.getMetaData();
            this.getTableTypes();
            this.metadata = null;
        }
        catch (SQLException sqle) {
            throw new MetaMatrixException(sqle);
        }
    }

    public boolean isClosed(Connection connection) {
        try {
            return connection.isClosed();
        }
        catch (SQLException e) {
            return true;
        }
    }

    public void setIsSecure(boolean secure) {
        this.isSecure = secure;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public boolean isOracle() {
        return false;
    }

    public boolean isDefault() {
        return true;
    }

    public boolean isMetaMatrix() {
        return false;
    }

    public boolean isDB2() {
        return false;
    }

    public boolean isSybase() {
        return false;
    }

    public boolean isMSSQL() {
        return false;
    }

    public boolean isInformix() {
        return false;
    }

    public boolean isDerby() {
        return false;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public boolean usesStreamsForBlobBinding() {
        return this.usesStreamsForBlobBinding;
    }

    public boolean usesStreamsForClobBinding() {
        return this.usesStreamsForClobBinding;
    }

    public int setBlob(ResultSet results, byte[] data, String columnName) throws SQLException, IOException {
        int n;
        OutputStream l_blobOutputStream;
        block7: {
            Blob blob = results.getBlob(columnName);
            l_blobOutputStream = null;
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            BufferedInputStream is = new BufferedInputStream(bais);
            try {
                ReflectionHelper helper = new ReflectionHelper(blob.getClass());
                Object[] args = new Object[]{};
                Method m = helper.findBestMethodOnTarget("getBinaryOutputStream", args);
                l_blobOutputStream = (OutputStream)m.invoke((Object)blob, args);
                byte[] l_buffer = new byte[10240];
                int cnt = ((InputStream)is).available();
                int l_nread = 0;
                while ((l_nread = ((InputStream)is).read(l_buffer)) != -1) {
                    l_blobOutputStream.write(l_buffer, 0, l_nread);
                }
                n = cnt;
                Object var16_16 = null;
                if (is == null) break block7;
            }
            catch (Exception nsme) {
                try {
                    throw new IOException(nsme.getMessage());
                }
                catch (Throwable throwable) {
                    block8: {
                        Object var16_17 = null;
                        if (is != null) {
                            ((InputStream)is).close();
                            is = null;
                        }
                        if (l_blobOutputStream == null) break block8;
                        l_blobOutputStream.close();
                        l_blobOutputStream = null;
                    }
                    throw throwable;
                }
            }
            ((InputStream)is).close();
            is = null;
        }
        if (l_blobOutputStream != null) {
            l_blobOutputStream.close();
            l_blobOutputStream = null;
        }
        return n;
    }

    public void setBlob(PreparedStatement statement, byte[] data, int column) throws SQLException, IOException {
        statement.setBytes(column, data);
    }

    public void setClob(ResultSet results, byte[] data, String columnName) throws SQLException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedInputStream is = new BufferedInputStream(bais);
        this.setClob(results, is, columnName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClob(ResultSet results, InputStream is, String columnName) throws SQLException, IOException {
        OutputStream l_clobOutputStream;
        block6: {
            l_clobOutputStream = null;
            Clob clob = results.getClob(columnName);
            try {
                try {
                    ReflectionHelper helper = new ReflectionHelper(clob.getClass());
                    Object[] args = new Object[]{};
                    Method m = helper.findBestMethodOnTarget("getAsciiOutputStream", args);
                    l_clobOutputStream = (OutputStream)m.invoke((Object)clob, args);
                    byte[] l_buffer = new byte[10240];
                    int l_nread = 0;
                    while ((l_nread = is.read(l_buffer)) != -1) {
                        l_clobOutputStream.write(l_buffer, 0, l_nread);
                    }
                    Object var12_12 = null;
                    if (is == null) break block6;
                }
                catch (Exception nsme) {
                    nsme.printStackTrace();
                    throw new IOException(nsme.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (is != null) {
                    is.close();
                    is = null;
                }
                if (l_clobOutputStream == null) throw throwable;
                l_clobOutputStream.close();
                l_clobOutputStream = null;
                throw throwable;
            }
            is.close();
            is = null;
        }
        if (l_clobOutputStream == null) return;
        l_clobOutputStream.close();
    }

    public void setClob(PreparedStatement statement, byte[] data, int column) throws SQLException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedInputStream is = new BufferedInputStream(bais);
        statement.setAsciiStream(column, (InputStream)is, is.available());
    }

    public String createSelectStatement(Table tableMetadata) {
        return this.createSelectStatement(tableMetadata, null);
    }

    public String createSelectStatement(Table tableMetadata, String tablePrefix) {
        return this.createSelectStatement(tableMetadata, tablePrefix, null);
    }

    public String createSelectStatement(Table tableMetadata, String tablePrefix, Column[] whereColumns) {
        StringBuffer sql = new StringBuffer();
        sql.append(SELECT);
        List columns = tableMetadata.getColumns();
        String columnString = this.buildCommaSeperatedColumns(columns);
        sql.append(columnString);
        sql.append(FROM);
        if (tablePrefix != null && tablePrefix.length() > 0) {
            sql.append(tablePrefix);
            sql.append(PERIOD);
        } else {
            sql.append(SPACE);
        }
        sql.append(tableMetadata.getFullName());
        if (whereColumns != null) {
            String whereClause = this.buildWhereParameterClause(whereColumns);
            sql.append(SPACE);
            sql.append(whereClause);
        }
        return sql.toString();
    }

    public String createInsertStatement(Table tableMetadata) {
        return this.createInsertStatement(tableMetadata, "");
    }

    public String createInsertStatement(Table tableMetadata, String tablePrefix) {
        StringBuffer sql = new StringBuffer();
        sql.append(INSERT_INTO);
        if (tablePrefix != null && tablePrefix.length() > 0) {
            sql.append(tablePrefix);
            sql.append(PERIOD);
        }
        sql.append(tableMetadata.getFullName());
        sql.append(" (");
        List columns = tableMetadata.getColumns();
        String columnString = this.buildCommaSeperatedColumns(columns);
        sql.append(columnString);
        int size = columns.size();
        sql.append(")");
        sql.append(VALUES);
        sql.append("(");
        for (int k = 1; k <= size; ++k) {
            sql.append(PARAM);
            if (k >= size) continue;
            sql.append(COMMA);
        }
        sql.append(")");
        return sql.toString();
    }

    public String createInsertStatement(Table tableMetadata, String[] values) {
        return "";
    }

    public String createUpdateStatement(Table tableMetadata) {
        return this.createUpdateStatement(tableMetadata, null);
    }

    public String createUpdateStatement(Table tableMetadata, String[] values) {
        StringBuffer sql = new StringBuffer();
        sql.append(UPDATE);
        sql.append(tableMetadata.getFullName());
        if (values != null) {
            return "NEED TO UPDATE method createUpdateStatement";
        }
        String setClause = this.buildSetParmClause(tableMetadata.getColumns().toArray());
        sql.append(setClause);
        if (!tableMetadata.getUniqueKeys().isEmpty()) {
            String whereClause = this.buildWhereUsingUiqueKeys(tableMetadata.getUniqueKeys());
            sql.append(SPACE);
            sql.append(whereClause);
        }
        return sql.toString();
    }

    protected String buildSetParmClause(Object[] setColumns) {
        StringBuffer sql = new StringBuffer();
        sql.append(SET);
        int size = setColumns.length;
        for (int k = 0; k < size; ++k) {
            Column col = (Column)setColumns[k];
            sql.append(col.getName());
            sql.append(EQUAL);
            sql.append(PARAM);
            if (k >= size - 1) continue;
            sql.append(COMMA);
        }
        return sql.toString();
    }

    protected String buildWhereUsingUiqueKeys(Collection uniqueKeys) {
        StringBuffer sql = new StringBuffer();
        sql.append(WHERE);
        int size = uniqueKeys.size();
        int k = 0;
        Iterator it = uniqueKeys.iterator();
        while (it.hasNext()) {
            UniqueKey key = (UniqueKey)it.next();
            sql.append(key.getName());
            sql.append(EQUAL);
            sql.append(PARAM);
            if (k < size - 1) {
                sql.append(AND);
            }
            ++k;
        }
        return sql.toString();
    }

    public String createDeleteStatement(Table table) {
        return this.createDeleteStatement(table, null);
    }

    public String createDeleteStatement(Table table, String tablePrefix) {
        if (tablePrefix != null && tablePrefix.length() > 0) {
            return DELETE_FROM + tablePrefix + PERIOD + table.getName();
        }
        return DELETE_FROM + table.getName();
    }

    public String createDeleteStatement(Table table, Column[] whereColumns, String tablePrefix) {
        String prefix = tablePrefix != null && tablePrefix.length() > 0 ? DELETE_FROM + tablePrefix + PERIOD + table.getName() : DELETE_FROM + table.getName();
        StringBuffer sql = new StringBuffer(prefix);
        if (whereColumns != null) {
            String whereClause = this.buildWhereParameterClause(whereColumns);
            sql.append(SPACE);
            sql.append(whereClause);
        }
        return sql.toString();
    }

    public String createTruncateStatement(String tablename) {
        return this.createTruncateStatement(tablename, null);
    }

    public String createTruncateStatement(String tablename, String tablePrefix) {
        if (tablePrefix != null && tablePrefix.length() > 0) {
            return DELETE_FROM + tablePrefix + PERIOD + tablename;
        }
        return DELETE_FROM + tablename;
    }

    public int getMaxFieldNameSize() {
        return 50;
    }

    public String[] getTableTypes() throws MetaMatrixException {
        if (this.tableTypes != null) {
            return this.tableTypes;
        }
        HashSet<String> tableTypesSet = new HashSet<String>();
        try {
            ResultSet tableTypesResults = this.metadata.getTableTypes();
            while (tableTypesResults.next()) {
                tableTypesSet.add(tableTypesResults.getString(1).trim());
            }
        }
        catch (SQLException e) {
            throw new MetaMatrixException(e);
        }
        this.tableTypes = new String[tableTypesSet.size()];
        int index = -1;
        Iterator iter = tableTypesSet.iterator();
        while (iter.hasNext()) {
            this.tableTypes[++index] = iter.next().toString();
        }
        return this.tableTypes;
    }

    public Map getClassTypes() {
        if (this.classTypes == null) {
            this.classTypes = this.buildClassTypes();
        }
        return this.classTypes;
    }

    public Map getFieldTypes() {
        if (this.fieldTypes == null) {
            this.fieldTypes = this.buildFieldTypes();
        }
        return this.fieldTypes;
    }

    public synchronized Number getMaximumValue(Class clazz) {
        Object obj;
        if (clazz == null) {
            return null;
        }
        if (this.maximumValues == null) {
            this.maximumValues = this.maximumNumericValues();
        }
        if ((obj = this.maximumValues.get(clazz)) != null) {
            return (Number)obj;
        }
        return null;
    }

    public synchronized Number getMinimumValue(Class clazz) {
        Object obj;
        if (clazz == null) {
            return null;
        }
        if (this.minimumValues == null) {
            this.minimumValues = this.minimumNumericValues();
        }
        if ((obj = this.minimumValues.get(clazz)) != null) {
            return (Number)obj;
        }
        return null;
    }

    public ExpressionOperator getOperator(String name) {
        return (ExpressionOperator)this.getPlatformOperators().get(name);
    }

    public synchronized Map getPlatformOperators() {
        if (this.platformOperators == null) {
            this.platformOperators = this.buildPlatformOperators();
        }
        return this.platformOperators;
    }

    void initializePlatform() {
    }

    protected Map buildClassTypes() {
        HashMap types = new HashMap();
        return types;
    }

    protected Map buildFieldTypes() {
        HashMap types = new HashMap();
        return types;
    }

    protected void addOperator(ExpressionOperator op) {
        Iterator it = op.getSelectors().iterator();
        while (it.hasNext()) {
            this.platformOperators.put(it.next(), op);
        }
    }

    protected Map buildPlatformOperators() {
        this.platformOperators = new Hashtable();
        this.addOperator(ExpressionOperator.ascending());
        this.addOperator(ExpressionOperator.descending());
        this.addOperator(ExpressionOperator.toUpperCase());
        this.addOperator(ExpressionOperator.toLowerCase());
        this.addOperator(ExpressionOperator.maximum());
        this.addOperator(ExpressionOperator.minimum());
        this.addOperator(ExpressionOperator.sum());
        this.addOperator(ExpressionOperator.count());
        this.addOperator(ExpressionOperator.average());
        this.addOperator(ExpressionOperator.today());
        return this.platformOperators;
    }

    public Map maximumNumericValues() {
        HashMap values = new HashMap(1);
        return values;
    }

    public Map minimumNumericValues() {
        HashMap values = new HashMap(1);
        return values;
    }

    public byte[] convertToByteArray(Object sourceObject) throws TransformationException {
        if (sourceObject instanceof byte[]) {
            return (byte[])sourceObject;
        }
        if (sourceObject instanceof Clob) {
            return this.convertToByteArray((Clob)sourceObject);
        }
        if (sourceObject instanceof Blob) {
            return this.convertToByteArray((Blob)sourceObject);
        }
        throw new TransformationException("ERR.003.015.0001", CommonPlugin.Util.getString("ERR.003.015.0001", (Object)sourceObject.getClass().getName()));
    }

    protected byte[] convertToByteArray(Blob sourceObject) throws TransformationException {
        try {
            InputStream l_blobStream = sourceObject.getBinaryStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(out);
            byte[] l_buffer = new byte[1024];
            int l_nbytes = 0;
            while ((l_nbytes = l_blobStream.read(l_buffer)) != -1) {
                bos.write(l_buffer, 0, l_nbytes);
            }
            bos.flush();
            bos.close();
            l_blobStream.close();
            return out.toByteArray();
        }
        catch (IOException ioe) {
            throw new TransformationException(ioe, "ERR.003.015.0002", CommonPlugin.Util.getString("ERR.003.015.0002", (Object)sourceObject.getClass().getName()));
        }
        catch (SQLException sqe) {
            throw new TransformationException(sqe, "ERR.003.015.0002", CommonPlugin.Util.getString("ERR.003.015.0002", (Object)sourceObject.getClass().getName()));
        }
    }

    public byte[] convertClobToByteArray(ResultSet results, String columName) throws TransformationException {
        byte[] data = null;
        Clob clobResults = null;
        try {
            if (this.usesStreamsForClobBinding()) {
                clobResults = results.getClob(columName);
                if (clobResults != null) {
                    data = this.convertToByteArray(clobResults);
                }
            } else {
                String s = results.getString(columName);
                data = s.getBytes();
            }
        }
        catch (SQLException sqe) {
            throw new TransformationException(sqe, "ERR.003.015.0002", CommonPlugin.Util.getString("ERR.003.015.0002", (Object)columName));
        }
        return data;
    }

    protected byte[] convertToByteArray(Clob sourceObject) throws TransformationException {
        try {
            InputStream l_clobStream = sourceObject.getAsciiStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(out);
            byte[] l_buffer = new byte[1024];
            int l_nbytes = 0;
            while ((l_nbytes = l_clobStream.read(l_buffer)) != -1) {
                bos.write(l_buffer, 0, l_nbytes);
            }
            bos.flush();
            bos.close();
            l_clobStream.close();
            return out.toByteArray();
        }
        catch (IOException ioe) {
            throw new TransformationException(ioe, "ERR.003.015.0002", CommonPlugin.Util.getString("ERR.003.015.0002", (Object)sourceObject.getClass().getName()));
        }
        catch (SQLException sqe) {
            throw new TransformationException(sqe, "ERR.003.015.0002", CommonPlugin.Util.getString("ERR.003.015.0002", (Object)sourceObject.getClass().getName()));
        }
    }

    protected String buildCommaSeperatedColumns(Collection columns) {
        StringBuffer sql = new StringBuffer();
        int i = 1;
        int size = columns.size();
        Iterator cit = columns.iterator();
        while (cit.hasNext()) {
            Column column = (Column)cit.next();
            sql.append(column.getName());
            if (i < size) {
                sql.append(COMMA);
            }
            ++i;
        }
        return sql.toString();
    }

    protected String buildWhereParameterClause(Column[] whereColumns) {
        StringBuffer sql = new StringBuffer();
        sql.append(WHERE);
        int size = whereColumns.length;
        for (int k = 0; k < size; ++k) {
            Column col = whereColumns[k];
            sql.append(col.getName());
            sql.append(EQUAL);
            sql.append(PARAM);
            if (k >= size - 1) continue;
            sql.append(AND);
        }
        return sql.toString();
    }

    public int getDatabaseColumnSize(String tableName, String columnName, Connection jdbcConnection) throws SQLException {
        DatabaseMetaData dbMetadata = jdbcConnection.getMetaData();
        String catalogName = jdbcConnection.getCatalog();
        ResultSet columns = dbMetadata.getColumns(catalogName, null, tableName, "%");
        int s = -1;
        while (columns.next()) {
            String nis = columns.getString(4);
            if (!columnName.equals(nis)) continue;
            s = columns.getInt(7);
        }
        return s;
    }

    public List parseToExecutableStatements(BufferedReader reader, String delimiter) throws SQLException {
        StringBuffer buffer = new StringBuffer();
        LinkedList<StringBuffer> listOfStatements = new LinkedList<StringBuffer>();
        try {
            String line;
            List remove = this.getNonExecutableDelimiters();
            while (reader.ready() && (line = reader.readLine()) != null) {
                line = line.trim();
                boolean doNotRemove = true;
                if (line == null || line.length() == 0) continue;
                String UCASELINE = line.toUpperCase();
                Iterator it = remove.iterator();
                while (it.hasNext()) {
                    String removeItem = (String)it.next();
                    if (!UCASELINE.startsWith(removeItem)) continue;
                    doNotRemove = false;
                    break;
                }
                if (!doNotRemove) continue;
                if (line.endsWith(delimiter)) {
                    int x = line.lastIndexOf(delimiter);
                    buffer.append(line.substring(0, x));
                    listOfStatements.add(buffer);
                    buffer = new StringBuffer();
                    continue;
                }
                buffer.append(line + SPACE);
            }
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return listOfStatements;
    }

    protected List getNonExecutableDelimiters() {
        ArrayList<String> re = new ArrayList<String>(1);
        re.add("--");
        re.add("SET");
        re.add("COMMIT");
        re.add("SPOOL");
        return re;
    }

    public static interface TableTypes {
        public static final String TABLE = "TABLE";
        public static final String VIEW = "VIEW";
        public static final String SYSTEM_TABLE = "SYSTEM TABLE";
        public static final String GLOBAL_TEMPORARY = "GLOBAL TEMPORARY";
        public static final String LOCAL_TEMPORARY = "LOCAL TEMPORARY";
        public static final String ALIAS = "ALIAS";
        public static final String SYNONYM = "SYNONYM";
    }
}

