/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.messaging.rmi;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.messaging.rmi.RMIEventObjectListener;
import com.metamatrix.common.messaging.rmi.RemoteEventObjectListener;
import com.metamatrix.common.messaging.rmi.RemoteRMIMessageBusInterface;
import com.metamatrix.common.remote.MMRemoteObject;
import com.metamatrix.core.event.EventBroker;
import com.metamatrix.core.event.EventBrokerException;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.event.EventSourceException;
import com.metamatrix.core.event.SynchEventBroker;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

public class RemoteRMIMessageBus
extends MMRemoteObject
implements RemoteRMIMessageBusInterface {
    private static EventBroker eventBroker = new SynchEventBroker("RemoteRMIMessageBus");
    private Map listeners = new HashMap();
    private static int listenerID = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int addListener(Class eventClass, RemoteEventObjectListener listener) throws MessagingException {
        LogManager.logTrace("MESSAGE_BUS", "RemoteMessageBus.addListener() : listener = " + listener);
        RMIEventObjectListener rmiListener = new RMIEventObjectListener(this, listener);
        try {
            eventBroker.addListener(eventClass, (EventObjectListener)rmiListener);
            Map map = this.listeners;
            synchronized (map) {
                this.listeners.put(listener, rmiListener);
            }
        }
        catch (EventSourceException e) {
            throw new MessagingException(e, "ERR.003.017.0013", CommonPlugin.Util.getString("ERR.003.017.0013"));
        }
        return listenerID++;
    }

    public synchronized void processEvent(EventObject obj) throws MessagingException {
        LogManager.logTrace("MESSAGE_BUS", "RemoteMessageBus.processEvent() : EventObject = " + obj);
        eventBroker.processEvent(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws MessagingException {
        LogManager.logCritical("MESSAGE_BUS", CommonPlugin.Util.getString("MSG.003.017.0001"));
        try {
            eventBroker.shutdown();
            Map map = this.listeners;
            synchronized (map) {
                this.listeners.clear();
            }
        }
        catch (EventBrokerException e) {
            throw new MessagingException(e, "ERR.003.017.0014", CommonPlugin.Util.getString("ERR.003.017.0014"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeListener(Class eventClass, RemoteEventObjectListener listener) throws MessagingException {
        LogManager.logTrace("MESSAGE_BUS", "RemoteRMIMessageBus.removeListener " + listener + " for event " + eventClass);
        try {
            RMIEventObjectListener rmiListener = null;
            Map map = this.listeners;
            synchronized (map) {
                rmiListener = (RMIEventObjectListener)this.listeners.get(listener);
                this.listeners.remove(listener);
            }
            eventBroker.removeListener(eventClass, (EventObjectListener)rmiListener);
        }
        catch (EventSourceException e) {
            throw new MessagingException(e, "ERR.003.017.0015", CommonPlugin.Util.getString("ERR.003.017.0015"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeListener(RemoteEventObjectListener listener) throws MessagingException {
        LogManager.logTrace("MESSAGE_BUS", "RemoteRMIMessageBus.removeListener " + listener);
        try {
            RMIEventObjectListener rmiListener = null;
            Map map = this.listeners;
            synchronized (map) {
                rmiListener = (RMIEventObjectListener)this.listeners.get(listener);
                this.listeners.remove(listener);
            }
            eventBroker.removeListener((EventObjectListener)rmiListener);
        }
        catch (EventSourceException e) {
            throw new MessagingException(e, "ERR.003.017.0015", CommonPlugin.Util.getString("ERR.003.017.0015"));
        }
    }
}

