/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.impl;

import com.metamatrix.common.pooling.api.Resource;
import com.metamatrix.common.pooling.api.ResourceContainer;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.core.util.Assertion;
import java.sql.SQLException;

public abstract class BaseResource
implements Resource {
    private String checkedOutBy = null;
    private boolean isClosed = false;
    private ResourceContainer container = null;
    private boolean isAlive = true;
    protected static final String LOG_CONTEXT = "RESOURCE_POOLING";

    public void init(String checkedOutBy) throws ResourcePoolException {
        Assertion.isNotNull((Object)checkedOutBy);
        this.checkedOutBy = checkedOutBy;
        this.performInit();
        this.isAlive = true;
        this.isClosed = false;
    }

    public void init(ResourceContainer resourceContainer, String checkedOutBy) throws ResourcePoolException {
        this.init(checkedOutBy);
        this.container = resourceContainer;
    }

    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    public ResourceContainer getContainer() {
        return this.container;
    }

    public final synchronized void closeResource() throws ResourcePoolException {
        this.container.checkin(this, this.checkedOutBy);
        this.isClosed = true;
    }

    public final synchronized boolean isResourceAlive() {
        if (!this.isAlive) {
            return this.isAlive;
        }
        this.isAlive = this.checkIsResourceAlive();
        return this.isAlive;
    }

    public final boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    protected abstract void performInit() throws ResourcePoolException;

    protected abstract boolean checkIsResourceAlive();
}

