/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.passthru;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ResourceDescriptorID;
import com.metamatrix.common.log.I18nLogManager;
import com.metamatrix.common.pooling.api.Resource;
import com.metamatrix.common.pooling.api.ResourceAdapter;
import com.metamatrix.common.pooling.api.ResourceContainer;
import com.metamatrix.common.pooling.api.ResourcePool;
import com.metamatrix.common.pooling.api.ResourcePoolStatistics;
import com.metamatrix.common.pooling.api.exception.ResourcePoolException;
import com.metamatrix.common.pooling.api.exception.ResourceWaitTimeOutException;
import com.metamatrix.common.pooling.util.PoolingUtil;
import com.metamatrix.core.util.ArgCheck;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;

public class PassThruResourcePool
implements ResourcePool {
    protected ResourceDescriptor resourceDescriptor;
    private ResourceAdapter resourceAdapter;
    private boolean shutdownRequested = false;
    protected static final String CONTEXT = "RESOURCE_POOLING";
    static /* synthetic */ Class class$com$metamatrix$common$pooling$api$ResourceAdapter;

    public synchronized void init(ResourceDescriptor descriptor) throws ResourcePoolException {
        if (descriptor == null) {
            ArgCheck.isNotNull((Object)descriptor, (String)CommonPlugin.Util.getString("ERR.003.002.0015"));
        }
        try {
            this.resourceDescriptor = descriptor;
            this.initAdapter();
        }
        catch (Exception e) {
            throw new ResourcePoolException(e);
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public int getResourcePoolSize() {
        return -1;
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.resourceDescriptor;
    }

    public ResourceDescriptorID getResourceDescriptorID() {
        return (ResourceDescriptorID)this.resourceDescriptor.getID();
    }

    public ComponentTypeID getComponentTypeID() {
        return this.resourceDescriptor.getComponentTypeID();
    }

    public ResourcePoolStatistics getResourcePoolStatistics() {
        return null;
    }

    public Collection getPoolResourceStatistics() {
        return Collections.EMPTY_LIST;
    }

    public synchronized void shutDown() {
        try {
            this.shutdownRequested = true;
            this.cleanUp();
        }
        catch (Exception e) {
            I18nLogManager.logError(CONTEXT, "ERR.003.002.0017", (Throwable)e, new Object[]{this.resourceDescriptor.getName()});
        }
    }

    public synchronized void update(Properties properties) throws ResourcePoolException {
        if (properties == null || properties.isEmpty()) {
            return;
        }
    }

    protected void finalize() {
        this.cleanUp();
    }

    protected Resource checkResourceCache() {
        return null;
    }

    protected final void initAdapter() throws ResourcePoolException {
        Properties descriptorProperties = this.resourceDescriptor.getProperties();
        String resourceAdapterClassName = descriptorProperties.getProperty("pooling.resource.adapter.class.name");
        try {
            this.resourceAdapter = (ResourceAdapter)PoolingUtil.create(resourceAdapterClassName, null);
        }
        catch (ClassCastException e) {
            throw new ResourcePoolException(e, "ERR.003.002.0038", CommonPlugin.Util.getString("ERR.003.002.0038", new Object[]{resourceAdapterClassName, (class$com$metamatrix$common$pooling$api$ResourceAdapter == null ? (class$com$metamatrix$common$pooling$api$ResourceAdapter = PassThruResourcePool.class$("com.metamatrix.common.pooling.api.ResourceAdapter")) : class$com$metamatrix$common$pooling$api$ResourceAdapter).getName()}));
        }
    }

    public Resource checkOut(String userName) throws ResourcePoolException {
        if (this.shutdownRequested) {
            throw new ResourcePoolException("ERR.003.002.0026", CommonPlugin.Util.getString("ERR.003.002.0026", new Object[]{userName}));
        }
        Object m_object = null;
        Resource m_resource = null;
        int cnt = 0;
        int tries = 10;
        while (true) {
            m_object = this.resourceAdapter.createPhysicalResourceObject(this.resourceDescriptor);
            m_resource = this.getResourceAdapter().createResource(m_object);
            if (m_resource != null) {
                if (m_resource.isResourceAlive()) break;
                m_resource.closeResource();
            }
            if (++cnt >= tries) {
                throw new ResourceWaitTimeOutException("ERR.003.002.0039", CommonPlugin.Util.getString("ERR.003.002.0039"));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {}
        }
        return m_resource;
    }

    public void checkIn(ResourceContainer resourceContainer, String userName) throws ResourcePoolException {
    }

    public void cleanUp() {
        this.resourceDescriptor = null;
        this.resourceAdapter = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Resource Pool " + this.resourceDescriptor.getName() + "\n");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

