/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.queue;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueWorkerException;
import com.metamatrix.common.queue.WorkerPool;

public abstract class QueueWorker
extends Thread {
    private Channel channel;
    private WorkerPool pool;
    private long keepAlive;
    private boolean stopped = false;
    private Object firstWork;

    public QueueWorker() {
        this.setDaemon(true);
    }

    void setPoolState(String name, WorkerPool pool, Channel channel, long keepAlive, Object firstWork) {
        this.setName(name);
        this.pool = pool;
        this.channel = channel;
        this.keepAlive = keepAlive;
        this.firstWork = firstWork;
    }

    public abstract void initialize() throws QueueWorkerException;

    public abstract void cleanup() throws QueueWorkerException;

    public abstract void process(Object var1) throws QueueWorkerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.initialize();
                try {
                    this.process(this.firstWork);
                }
                finally {
                    this.pool.threadFree();
                }
                this.firstWork = null;
                while (!this.stopped) {
                    try {
                        Object work = this.channel.poll(this.keepAlive);
                        if (work != null) {
                            this.pool.threadBusy();
                            try {
                                this.process(work);
                                continue;
                            }
                            finally {
                                this.pool.threadFree();
                                continue;
                            }
                        }
                        this.stopped = true;
                    }
                    catch (InterruptedException e) {}
                }
                this.cleanup();
            }
            catch (QueueWorkerException e) {
                this.stopped = true;
                Object var4_7 = null;
                this.pool.threadRemoved(this.getName());
                if (!LogManager.isMessageToBeRecorded("RESOURCE_POOLING", 6)) return;
                LogManager.logTrace("RESOURCE_POOLING", CommonPlugin.Util.getString("WorkerPool.Removed_thread", new Object[]{this.getName(), this.pool.getName()}));
                return;
            }
            Object var4_6 = null;
            this.pool.threadRemoved(this.getName());
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.pool.threadRemoved(this.getName());
            if (!LogManager.isMessageToBeRecorded("RESOURCE_POOLING", 6)) throw throwable;
            LogManager.logTrace("RESOURCE_POOLING", CommonPlugin.Util.getString("WorkerPool.Removed_thread", new Object[]{this.getName(), this.pool.getName()}));
            throw throwable;
        }
        if (!LogManager.isMessageToBeRecorded("RESOURCE_POOLING", 6)) return;
        LogManager.logTrace("RESOURCE_POOLING", CommonPlugin.Util.getString("WorkerPool.Removed_thread", new Object[]{this.getName(), this.pool.getName()}));
    }

    public void interruptAndStop() {
        this.stopped = true;
        this.interrupt();
    }
}

