/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.remote;

import java.io.IOException;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import java.util.Iterator;
import java.util.List;

public class MMRMISocketFactory
extends RMISocketFactory
implements Serializable {
    private List firewalls = null;
    private static String firewall = null;
    private int rmiPort;

    public MMRMISocketFactory(List firewallAddresses, int port) {
        this.firewalls = firewallAddresses;
        this.rmiPort = port;
    }

    public Socket createSocket(String host, int port) throws IOException {
        try {
            if (firewall != null) {
                return new Socket(firewall, port);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            return new Socket(host, port);
        }
        catch (IOException e) {
            IOException e2 = null;
            if (this.firewalls != null) {
                Iterator it = this.firewalls.iterator();
                while (it.hasNext()) {
                    String address = (String)it.next();
                    if (firewall != null && (firewall == null || address.equalsIgnoreCase(firewall))) continue;
                    try {
                        Socket s = new Socket(address, port);
                        firewall = address;
                        return s;
                    }
                    catch (IOException ioe) {
                        it.remove();
                        if (e2 != null) continue;
                        e2 = ioe;
                    }
                }
            } else {
                e2 = e;
            }
            firewall = null;
            throw e2;
        }
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        port = port == 0 ? this.rmiPort : port;
        for (int i = 0; i < 5; ++i) {
            try {
                return new ServerSocket(port + i);
            }
            catch (IOException e) {
                if (i != 5) continue;
                throw e;
            }
        }
        return null;
    }
}

