/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeEditor;
import com.metamatrix.common.tree.directory.DirectoryEntryFilter;
import com.metamatrix.common.tree.directory.FileSystemView;
import com.metamatrix.common.util.exception.AssertionException;

public class FileSystemFilter
implements DirectoryEntryFilter {
    private String description = "q";
    private String[] filterExtensions;
    private FileSystemView fileSystemView;

    public static String getFileNameExtension(String s) {
        if (s != null) {
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                return s.substring(i + 1).toLowerCase();
            }
            return "";
        }
        return null;
    }

    public FileSystemFilter(FileSystemView fsv, String[] extensions, String description) {
        this.setDescription(description);
        this.filterExtensions = extensions;
        this.fileSystemView = fsv;
    }

    public void setTreeNodeEditor(TreeNodeEditor editor) {
        if (editor == null) {
            throw new AssertionException("ERR.003.028.0014", CommonPlugin.Util.getString("ERR.003.028.0014"));
        }
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean accept(TreeNode entry) {
        String ext = FileSystemFilter.getFileNameExtension(entry.getName());
        if (ext != null) {
            for (int i = 0; i < this.filterExtensions.length; ++i) {
                if (!ext.equals(this.filterExtensions[i]) && !this.fileSystemView.allowsChildren(entry)) continue;
                return true;
            }
        }
        return false;
    }

    public String getExtension(int index) {
        return this.filterExtensions[index];
    }

    public int getExtensionCount() {
        return this.filterExtensions.length;
    }
}

