/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree.directory;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.tree.directory.FileSystemViewHelper;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

class WindowsAltFileSystemView
extends FileSystemViewHelper {
    WindowsAltFileSystemView() {
    }

    public boolean isRoot(File f) {
        if (!f.isAbsolute()) {
            return false;
        }
        String parentPath = f.getParent();
        if (parentPath == null) {
            return true;
        }
        File parent = new File(parentPath);
        return parent.equals(f);
    }

    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.028.0054"));
        }
        File newFolder = null;
        newFolder = this.createFileObject(containingDir, "New Folder");
        for (int i = 2; newFolder.exists() && i < 100; ++i) {
            newFolder = this.createFileObject(containingDir, "New Folder (" + i + ")");
        }
        if (newFolder.exists()) {
            throw new IOException(CommonPlugin.Util.getString("ERR.003.028.0055", (Object)newFolder.getAbsolutePath()));
        }
        newFolder.mkdirs();
        return newFolder;
    }

    public boolean isHiddenFile(File f) {
        return false;
    }

    public File[] getRoots() {
        Vector<FileSystemRoot> rootsVector = new Vector<FileSystemRoot>();
        for (char c = 'C'; c <= 'Z'; c = (char)((char)(c + 1))) {
            char[] device = new char[]{c, ':', '\\'};
            String deviceName = new String(device);
            FileSystemRoot deviceFile = new FileSystemRoot(deviceName);
            if (deviceFile == null || !deviceFile.exists()) continue;
            rootsVector.addElement(deviceFile);
        }
        Object[] roots = new File[rootsVector.size()];
        rootsVector.copyInto(roots);
        return roots;
    }

    class FileSystemRoot
    extends File {
        public FileSystemRoot(File f) {
            super(f, "");
        }

        public FileSystemRoot(String s) {
            super(s);
        }

        public boolean isDirectory() {
            return true;
        }
    }
}

