/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.xml;

import com.metamatrix.core.util.StringUtil;
import org.jdom.Verifier;

public class XmlUtil {
    private XmlUtil() {
    }

    public static String containsValidCharacters(String str) {
        return Verifier.checkCharacterData((String)str);
    }

    public static String removeInvalidCharacters(String str) {
        if (str != null) {
            char[] orig = str.toCharArray();
            int origLength = orig.length;
            StringBuffer sb = new StringBuffer(str.length());
            for (int i = 0; i != origLength; ++i) {
                char c = orig[i];
                if (!Verifier.isXMLCharacter((int)c)) continue;
                sb.append(c);
            }
            return sb.toString();
        }
        return str;
    }

    public static String escapeCharacterData(String text) {
        if (text == null) {
            return null;
        }
        String escaped = StringUtil.replace((String)text, (String)"&", (String)"&amp;");
        escaped = StringUtil.replace((String)escaped, (String)">", (String)"&gt;");
        escaped = StringUtil.replace((String)escaped, (String)"<", (String)"&lt;");
        escaped = StringUtil.replace((String)escaped, (String)"\"", (String)"&quot;");
        escaped = StringUtil.replace((String)escaped, (String)"'", (String)"&apos;");
        return escaped;
    }
}

