/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.domain;

import com.metamatrix.license.LicensePlugin;
import com.metamatrix.license.domain.DottedStringComparator;
import com.metamatrix.license.domain.RangeSet;
import com.metamatrix.license.domain.ReferenceSet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class IPSet
extends ReferenceSet {
    private DottedStringComparator COMPARATOR = new DottedStringComparator();
    public static final IPSet UNDEFINED = new IPSet("Undefined");
    private String name;
    private Set addresses = new TreeSet(this.COMPARATOR);
    private Set rangeSets = new HashSet();
    private Set includeSets = new HashSet();
    private Set fullSet;

    public IPSet() {
    }

    public IPSet(String name) {
        this();
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public int size() {
        return this.getFullSet().size();
    }

    public Set getSingleIPs() {
        return this.addresses;
    }

    public void addAddress(String addr) {
        this.addresses.add(addr);
        this.updateFullSet();
    }

    public void deleteAddress(String addr) {
        this.addresses.remove(addr);
        this.updateFullSet();
    }

    public Set getRanges() {
        return this.rangeSets;
    }

    public void addRange(RangeSet range) {
        if (range.getIncrementer() == null) {
            range.setIncrementer(RangeSet.getDottedStringIncrementer());
        }
        this.rangeSets.add(range);
        this.updateFullSet();
    }

    public void deleteRange(RangeSet range) {
        if (range.getIncrementer() == null) {
            range.setIncrementer(RangeSet.getDottedStringIncrementer());
        }
        this.rangeSets.remove(range);
        this.updateFullSet();
    }

    public void addRange(String addr1, String addr2) {
        RangeSet range = new RangeSet(RangeSet.getDottedStringIncrementer());
        range.setRange(addr1, addr2);
        this.rangeSets.add(range);
        this.updateFullSet();
    }

    public Set getIncludeSets() {
        return this.includeSets;
    }

    public void addIncludeSet(ReferenceSet otherSet) {
        this.includeSets.add(otherSet);
        this.updateFullSet();
    }

    public void deleteIncludeSet(ReferenceSet otherSet) {
        this.includeSets.remove(otherSet);
        this.updateFullSet();
    }

    public String getFirstAddress() {
        return (String)((SortedSet)this.getFullSet()).first();
    }

    public String getLastAddress() {
        return (String)((SortedSet)this.getFullSet()).last();
    }

    public boolean contains(String addr) {
        return this.getFullSet().contains(addr);
    }

    public boolean containsLocalHost() throws UnknownHostException {
        String local = InetAddress.getLocalHost().getHostAddress();
        return this.contains(local);
    }

    public Iterator iterator() {
        return this.getFullSet().iterator();
    }

    public Set getFullSet() {
        if (this.fullSet == null) {
            this.updateFullSet();
        }
        return this.fullSet;
    }

    private void updateFullSet() {
        this.fullSet = this.computeFullSet();
    }

    private Set computeFullSet() {
        TreeSet fullSet = new TreeSet(this.COMPARATOR);
        Iterator addrIter = this.addresses.iterator();
        while (addrIter.hasNext()) {
            fullSet.add(addrIter.next());
        }
        Iterator rangeIter = this.rangeSets.iterator();
        while (rangeIter.hasNext()) {
            RangeSet rs1 = (RangeSet)rangeIter.next();
            Iterator elemIter1 = rs1.iterator();
            while (elemIter1.hasNext()) {
                fullSet.add(elemIter1.next());
            }
        }
        Iterator inclIter = this.includeSets.iterator();
        while (inclIter.hasNext()) {
            ReferenceSet rs2 = (ReferenceSet)inclIter.next();
            Iterator elemIter2 = rs2.iterator();
            while (elemIter2.hasNext()) {
                fullSet.add(elemIter2.next());
            }
        }
        return fullSet;
    }

    public String toString() {
        return (this.getName() != null ? this.getName() + " " : "") + (this.size() > 0 ? "(" + this.size() + " addresses)" : "") + (this.size() > 0 && this.size() < 10 ? " - " + this.getFullSet() : "");
    }

    public String toStringVerbose() {
        StringBuffer buffer = new StringBuffer(this.toString());
        Iterator iter = this.getFullSet().iterator();
        while (iter.hasNext()) {
            buffer.append("\n  " + iter.next());
        }
        return buffer.toString();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof IPSet)) {
            return false;
        }
        IPSet ipSet = (IPSet)other;
        if (this == ipSet) {
            return true;
        }
        if (this.getName() != null && !this.getName().equals(ipSet.getName())) {
            return false;
        }
        return ((Object)this.getFullSet()).equals(ipSet.getFullSet());
    }

    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode() ^ ((Object)this.getFullSet()).hashCode();
        }
        return ((Object)this.getFullSet()).hashCode();
    }

    public static RangeSet.Incrementer getInetAddressIncrementer() {
        RangeSet.Incrementer incrementer = new RangeSet.Incrementer(){
            InetAddress low;
            InetAddress high;
            int highDigit;
            String base;

            public void setRange(Object lo, Object hi) throws IllegalArgumentException {
                String base2;
                String base1;
                this.low = (InetAddress)lo;
                this.high = (InetAddress)hi;
                try {
                    base1 = this.low.getHostAddress();
                    int period = base1.lastIndexOf(46);
                    Integer.parseInt(base1.substring(period + 1));
                    base1 = base1.substring(0, period);
                    base2 = this.high.getHostAddress();
                    period = base2.lastIndexOf(46);
                    this.highDigit = Integer.parseInt(base2.substring(period + 1));
                    base2 = base2.substring(0, period);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                if (!base1.equals(base2)) {
                    Object[] params = new Object[]{base1, base2};
                    throw new IllegalArgumentException(LicensePlugin.Util.getString("IPSet.Base_addresses_mismatch", params));
                }
                this.base = base1;
            }

            public Object increment(Object in) throws Exception {
                InetAddress i = (InetAddress)in;
                String addr = i.getHostAddress();
                int value = Integer.parseInt(addr.substring(addr.lastIndexOf(46) + 1));
                if (value >= this.highDigit) {
                    return null;
                }
                return InetAddress.getByName(this.base + "." + ++value);
            }
        };
        return incrementer;
    }

    public static RangeSet.Incrementer getDottedStringIncrementer() {
        RangeSet.Incrementer incrementer = new RangeSet.Incrementer(){
            String low;
            String high;
            int highDigit;
            String base;

            public void setRange(Object lo, Object hi) throws IllegalArgumentException {
                String base2;
                String base1;
                this.low = (String)lo;
                this.high = (String)hi;
                try {
                    base1 = this.low;
                    int period = base1.lastIndexOf(46);
                    Integer.parseInt(base1.substring(period + 1));
                    base1 = base1.substring(0, period);
                    base2 = this.high;
                    period = base2.lastIndexOf(46);
                    this.highDigit = Integer.parseInt(base2.substring(period + 1));
                    base2 = base2.substring(0, period);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                if (!base1.equals(base2)) {
                    Object[] params = new Object[]{base1, base2};
                    throw new IllegalArgumentException(LicensePlugin.Util.getString("IPSet.Base_addresses_mismatch", params));
                }
                this.base = base1;
            }

            public Object increment(Object in) throws Exception {
                String addr = (String)in;
                int value = Integer.parseInt(addr.substring(addr.lastIndexOf(46) + 1));
                if (value >= this.highDigit) {
                    return null;
                }
                return this.base + "." + ++value;
            }
        };
        return incrementer;
    }

    public static IPSet example(int key) {
        IPSet set = new IPSet();
        String baseAddr = "192.168.10.";
        int endPart = 10 * key;
        String saddr0 = baseAddr + endPart;
        set.addAddress(saddr0);
        String saddr1 = baseAddr + (endPart + 1);
        String saddr2 = baseAddr + (endPart + 5);
        set.addRange(saddr1, saddr2);
        return set;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("String representation of internet addresses... ");
        String saddr1 = "192.168.10.20";
        String saddr2 = "192.168.10.25";
        String saddr3 = "192.168.10.30";
        String saddr4 = "192.168.10.40";
        String saddr5 = "192.168.10.45";
        String saddr6 = "192.168.10.50";
        String saddr7 = "192.168.10.55";
        IPSet s1 = new IPSet();
        s1.addRange(saddr1, saddr2);
        System.out.println("IPSet 1 with one range set: " + s1.toStringVerbose());
        s1.addRange(saddr2, saddr3);
        System.out.println("IPSet 1 with two range sets: " + s1.toStringVerbose());
        s1.addAddress(saddr4);
        s1.addAddress(saddr5);
        System.out.println("IPSet 1 with two range sets and two singles: " + s1.toStringVerbose());
        String check1 = "192.168.10.23";
        String check2 = "192.168.10.00";
        System.out.println("Does set 1 contain '" + check1 + "'? " + s1.contains(check1));
        System.out.println("Does set 1 contain '" + check2 + "'? " + s1.contains(check2));
        IPSet s2 = new IPSet();
        s2.addAddress(saddr5);
        s2.addAddress(saddr6);
        s2.addRange(saddr6, saddr7);
        System.out.println("IPSet 2 with two addresses and overlapping range: " + s2.toStringVerbose());
        s2.addIncludeSet(s1);
        System.out.println("Range set 2 with s1 included: " + s2.toStringVerbose());
        try {
            String local = InetAddress.getLocalHost().getHostAddress();
            System.out.println("Adding local IP '" + local + "' to IP set 2");
            s2.addAddress(local);
            System.out.println("Does set 2 contain '" + local + "'? " + s2.contains(local));
        }
        catch (UnknownHostException e) {
            System.err.println("Could not get local host");
            System.exit(-1);
        }
    }
}

