/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.domain;

import com.metamatrix.license.domain.IPSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class IPSets {
    Map ipSets = new TreeMap();

    public int size() {
        return this.ipSets.size();
    }

    public Set getNames() {
        return this.ipSets.keySet();
    }

    public Collection getIPSets() {
        return this.ipSets.values();
    }

    public IPSet getIPSet(String name) {
        return (IPSet)this.ipSets.get(name);
    }

    public void addIPSet(IPSet set) {
        this.ipSets.put(set.getName(), set);
    }

    public void deleteIPSet(IPSet set) {
        this.ipSets.remove(set.getName());
    }

    public boolean contains(String name) {
        return this.ipSets.containsKey(name);
    }

    public Iterator iterator() {
        return this.getIPSets().iterator();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("There are " + this.ipSets.size() + " IP sets");
        Iterator iter = this.ipSets.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IPSet ipSet = (IPSet)entry.getValue();
            buffer.append(" " + ipSet.toString());
        }
        return buffer.toString();
    }

    public String toStringVerbose() {
        StringBuffer buffer = new StringBuffer("There are " + this.ipSets.size() + " IP sets");
        Iterator iter = this.ipSets.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IPSet ipSet = (IPSet)entry.getValue();
            buffer.append("\n  " + ipSet.toStringVerbose());
        }
        return buffer.toString();
    }

    public static IPSets example(int key) {
        IPSets sets = new IPSets();
        for (int k = 0; k <= key; ++k) {
            IPSet set = IPSet.example(k);
            sets.addIPSet(set);
        }
        return sets;
    }

    public static void main(String[] args) {
        IPSets ipSets = IPSets.example(0);
        System.out.println(ipSets);
    }
}

