/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.domain;

import com.metamatrix.license.domain.License;
import com.metamatrix.license.domain.LicenseTypes;
import java.util.Date;

public class LicenseInfo
implements LicenseTypes {
    String licenseType;
    String createdBy;
    Date created;
    String lastUpdatedBy;
    Date lastUpdated;
    String signature;

    public LicenseInfo() {
        this.setCreated(new Date());
        this.setCreatedBy("System");
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String value) {
        this.licenseType = value;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String value) {
        this.createdBy = value;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date value) {
        this.created = value;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String value) {
        this.lastUpdatedBy = value;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date value) {
        this.lastUpdated = value;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String value) {
        this.signature = value;
    }

    public static LicenseInfo example(int key) {
        LicenseInfo info = new LicenseInfo();
        info.setCreatedBy("user" + key);
        info.setCreated(new Date());
        info.setLicenseType(key % 10 == 0 ? "Evaluation" : "Customer");
        info.setSignature("###" + key);
        return info;
    }

    public String toString() {
        String s = "License Type " + this.getLicenseType() + ", created " + License.dateToString(this.getCreated()) + " by " + this.getCreatedBy() + (this.getLastUpdated() != null ? ", last updated " + License.dateToString(this.getLastUpdated()) + " by " + this.getLastUpdatedBy() : "") + " [" + this.getSignature() + "]";
        return s;
    }

    public static void main(String[] args) {
        LicenseInfo info = LicenseInfo.example(0);
        System.out.println(info);
    }
}

