/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HexOutputStream
extends FilterOutputStream {
    String hexValue = null;
    boolean useSpacer = false;

    public HexOutputStream(OutputStream out) {
        super(out);
    }

    public HexOutputStream(OutputStream out, boolean useSpacer) {
        super(out);
        this.useSpacer = useSpacer;
    }

    public void write(int b) throws IOException {
        this.hexValue = Integer.toHexString(b & 0xFF);
        if (this.hexValue.length() == 1) {
            this.out.write(48);
        }
        this.out.write(this.hexValue.getBytes());
        if (this.useSpacer) {
            this.out.write(32);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: HexOutputStream inFile outFile");
            System.exit(0);
        }
        String inFile = args[0];
        String outFile = args[1];
        byte[] bytes = null;
        if (!inFile.equalsIgnoreCase("AllBytes")) {
            FileInputStream fis = new FileInputStream(inFile);
            bytes = new byte[fis.available()];
            fis.read(bytes, 0, bytes.length);
            fis.close();
        } else {
            System.out.println("Writing bytes from -128 to 127");
            bytes = new byte[256];
            int k = 0;
            int b = -128;
            while (k < 256) {
                bytes[k] = b;
                ++k;
                b = (byte)(b + 1);
            }
        }
        System.out.println(bytes.length);
        FileOutputStream fos = new FileOutputStream(outFile);
        HexOutputStream hos = new HexOutputStream(fos);
        hos.write(bytes, 0, bytes.length);
        hos.close();
    }
}

