/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license.util;

import com.metamatrix.internal.core.xml.SAXBuilderHelper;
import com.metamatrix.license.LicensePlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLDocumentUtil {
    Document xmlDoc;

    public XMLDocumentUtil() {
    }

    public XMLDocumentUtil(Document doc) {
        this.setDocument(doc);
    }

    public Document getDocument() {
        return this.xmlDoc;
    }

    public void setDocument(Document doc) {
        this.xmlDoc = doc;
    }

    public void setDocument(String filename) throws FileNotFoundException, IOException, JDOMException {
        this.setDocument(XMLDocumentUtil.loadDocument(filename));
    }

    public static String getDocumentAsString(Document doc) {
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        return outputter.outputString(doc);
    }

    public String getDocumentAsString() {
        return XMLDocumentUtil.getDocumentAsString(this.xmlDoc);
    }

    public static Document getDocumentExcludingElement(Document doc, String elemFullName) {
        Document clone = (Document)doc.clone();
        Element root = clone.getRootElement();
        Namespace ns = root.getNamespace();
        XMLDocumentUtil.setTextContent(root, elemFullName, ns, "");
        return clone;
    }

    public Document getDocumentExcludingElement(String elemFullName) {
        return XMLDocumentUtil.getDocumentExcludingElement(this.xmlDoc, elemFullName);
    }

    public static String getDocumentAsStringExcludingElement(Document doc, String elemFullName) {
        Document newDoc = XMLDocumentUtil.getDocumentExcludingElement(doc, elemFullName);
        return XMLDocumentUtil.getDocumentAsString(newDoc);
    }

    public String getDocumentAsStringExcludingElement(String elemFullName) {
        return XMLDocumentUtil.getDocumentAsStringExcludingElement(this.xmlDoc, elemFullName);
    }

    public static String getElementContent(Document doc, String elemFullName) {
        Element root = doc.getRootElement();
        Namespace ns = root.getNamespace();
        return XMLDocumentUtil.getTextContent(root, elemFullName, ns);
    }

    public String getElementContent(String elemFullName) {
        return XMLDocumentUtil.getElementContent(this.xmlDoc, elemFullName);
    }

    public static String setElementContent(Document doc, String elemFullName, String text) {
        Element root = doc.getRootElement();
        Namespace ns = root.getNamespace();
        return XMLDocumentUtil.setTextContent(root, elemFullName, ns, text);
    }

    public String setElementContent(String elemFullName, String text) {
        return XMLDocumentUtil.setElementContent(this.xmlDoc, elemFullName, text);
    }

    public static Document loadDocument(String filename) throws IOException, JDOMException {
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder((boolean)false);
        return builder.build(new File(filename));
    }

    private static String getTextContent(Element startElement, String path, Namespace ns) {
        StringTokenizer st = new StringTokenizer(path, ".");
        st.nextToken();
        Element elem = startElement;
        while (st.hasMoreTokens()) {
            String tag = st.nextToken();
            elem = elem.getChild(tag, ns);
        }
        return elem.getTextTrim();
    }

    private static String setTextContent(Element startElement, String path, Namespace ns, String text) {
        StringTokenizer st = new StringTokenizer(path, ".");
        st.nextToken();
        Element elem = startElement;
        while (st.hasMoreTokens()) {
            String tag = st.nextToken();
            if ((elem = elem.getChild(tag, ns)) != null) continue;
            throw new IllegalArgumentException(LicensePlugin.Util.getString("ERR.003.016.0047", (Object)path, (Object)tag));
        }
        String wasThere = elem.getTextTrim();
        elem.setText(text);
        return wasThere;
    }

    public static void main(String[] args) throws Exception {
        String filename = args.length > 0 ? args[0] : "MetaMatrixLicense.xml";
        String elemPath = args.length > 1 ? args[1] : "license.licenseInfo.signature";
        for (int k = 0; k < 100; ++k) {
            XMLDocumentUtil.test1(filename, elemPath);
        }
    }

    public static void test1(String filename, String elemPath) throws Exception {
        XMLDocumentUtil util = new XMLDocumentUtil();
        util.setDocument(filename);
        String sdoc1 = util.getDocumentAsString();
        System.out.println("String of doc1: " + sdoc1);
        Document doc2 = util.getDocumentExcludingElement(elemPath);
        util.getDocumentAsStringExcludingElement(elemPath);
        String subtracted = util.getElementContent(elemPath);
        XMLDocumentUtil util2 = new XMLDocumentUtil();
        util2.setDocument(doc2);
        util2.setElementContent(elemPath, subtracted);
        String sdoc3 = util2.getDocumentAsString();
        System.out.println("String of doc3: " + sdoc3);
        System.out.println("String of doc1 == re-built string of doc3? " + sdoc1.equals(sdoc3));
    }
}

