/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.client;

import com.metamatrix.admin.util.AdminMethodEncryptResolver;
import com.metamatrix.common.api.MMURL;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerConnectionFactory;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnection;
import com.metamatrix.common.comm.platform.socket.client.SocketServerConnectionFactory;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.proxy.SecurityContext;
import com.metamatrix.core.proxy.ServiceInvocation;
import com.metamatrix.core.proxy.ServiceInvocationStruct;
import com.metamatrix.core.proxy.TerminalServiceInterceptor;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;

public class ServerAdminClientInterceptor
implements TerminalServiceInterceptor {
    private static final int MAX_RETRIES = 3;
    private static final int BOUNCE_WAIT = 1000;
    private static final String METHOD_CLOSE = "close";
    private static final String METHOD_BOUNCE_SYSTEM = "bounceSystem";
    private static final String PROPERTY_PASSWORD = "password";
    private String userName;
    private char[] password;
    private MMURL serverURL;
    private String applicationName;
    private SocketServerConnectionFactory serverConnectionFactory;
    private AdminMethodEncryptResolver resolver;
    private SocketServerConnection serverConnection;

    public ServerAdminClientInterceptor(String userName, char[] password, String serverURL, String applicationName, ServerConnectionFactory serverConnectionFactory, AdminMethodEncryptResolver resolver) {
        this.userName = userName;
        this.password = password;
        this.serverURL = new MMURL(serverURL);
        this.applicationName = applicationName;
        this.serverConnectionFactory = (SocketServerConnectionFactory)serverConnectionFactory;
        this.resolver = resolver;
    }

    public Object invoke(ServiceInvocation invocation) throws Throwable {
        Exception exception = null;
        String methodName = invocation.getMethodName();
        if (methodName.equalsIgnoreCase(METHOD_CLOSE)) {
            this.invokeClose();
            return null;
        }
        if (methodName.equalsIgnoreCase(METHOD_BOUNCE_SYSTEM)) {
            this.invokeBounceSystem(invocation);
            return null;
        }
        for (int i = 0; i < 3; ++i) {
            try {
                return this.doOneInvocation(invocation);
            }
            catch (IOException e) {
                exception = e;
                this.closeConnection();
                continue;
            }
            catch (MetaMatrixRuntimeException e) {
                exception = e;
                this.closeConnection();
                continue;
            }
            catch (CommunicationException e) {
                exception = e;
                this.closeConnection();
            }
        }
        throw exception;
    }

    private Object doOneInvocation(ServiceInvocation invocation) throws Throwable {
        SocketServerConnection serverConnection = this.getServerConnection();
        ServerInstance serverInstance = serverConnection.selectServerInstance(null);
        Encryptor encryptor = serverConnection.getEncryptor();
        this.encryptPasswordArguments(encryptor, invocation);
        this.encryptPropertiesArguments(encryptor, invocation);
        SecurityContext securityContext = serverConnection.getClientSideLogon().getSecurityContext();
        invocation.setAttribute(securityContext.getClass().getName(), securityContext);
        MessageHolder requestMessage = this.createRequestMessage(invocation);
        MessageHolder responseMessage = (MessageHolder)serverConnection.send(requestMessage, serverInstance);
        Serializable result = this.getResult(responseMessage);
        if (result instanceof ExceptionHolder) {
            throw ((ExceptionHolder)result).exception;
        }
        return result;
    }

    protected void encryptPasswordArguments(Encryptor encryptor, ServiceInvocation invocation) throws Throwable {
        String methodName = invocation.getMethodName();
        Object[] arguments = invocation.getArguments();
        int[] positions = this.resolver.getArgumentsToEncrypt(methodName);
        for (int i = 0; i < positions.length; ++i) {
            int position = positions[i];
            String password = (String)arguments[position];
            char[] encrypted = CryptoUtil.stringEncrypt(encryptor, password.toCharArray());
            arguments[position] = new String(encrypted);
        }
    }

    protected void encryptPropertiesArguments(Encryptor encryptor, ServiceInvocation invocation) throws Throwable {
        Object[] arguments = invocation.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            if (!(arguments[i] instanceof Properties)) continue;
            Properties properties = (Properties)arguments[i];
            arguments[i] = CryptoUtil.propertyEncryptEndsWith(encryptor, PROPERTY_PASSWORD, properties);
        }
    }

    private MessageHolder createRequestMessage(ServiceInvocation invocation) {
        ServiceInvocationStruct serializedInvocation = invocation.toStruct();
        MessageHolder message = new MessageHolder();
        message.contents = serializedInvocation;
        return message;
    }

    private Serializable getResult(MessageHolder responseMessage) {
        return responseMessage.contents;
    }

    private void invokeClose() {
        this.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeBounceSystem(ServiceInvocation invocation) throws Throwable {
        this.doOneInvocation(invocation);
        Boolean waitUntilDone = (Boolean)invocation.getArguments()[0];
        if (waitUntilDone.booleanValue()) {
            boolean done = false;
            while (!done) {
                try {
                    SocketServerConnection serverConnection = this.getServerConnection();
                    ServerInstance serverInstance = serverConnection.selectServerInstance(null);
                    if (serverInstance == null) continue;
                    done = true;
                    break;
                }
                catch (Exception e) {}
                continue;
                finally {
                    this.closeConnection();
                    Thread.sleep(1000L);
                }
            }
        }
    }

    private synchronized void closeConnection() {
        if (this.serverConnection != null) {
            try {
                this.serverConnection.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.serverConnection = null;
        }
    }

    private synchronized SocketServerConnection getServerConnection() throws ConnectionException, CommunicationException {
        if (this.serverConnection == null) {
            this.serverConnection = (SocketServerConnection)this.serverConnectionFactory.establishConnection(this.serverURL, "Platform", this.applicationName, "SessionService", this.userName, this.password);
            this.serverConnection.setStickyConnections(true);
        }
        return this.serverConnection;
    }
}

