/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.comm.platform.server;

import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.ClientConnectionWithConnectionIdObject;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.platform.CommPlatformPlugin;
import com.metamatrix.common.comm.service.ClientConnectionWithConnectionId;
import com.metamatrix.platform.resource.MessageReceiver;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Properties;

public class ClientConnectionImpl
implements ClientConnection,
ClientConnectionWithConnectionId,
ClientConnectionWithConnectionIdObject {
    private MessageReceiver msgReceiver;
    private Map props;
    private Object connectionId;

    public ClientConnectionImpl(MessageReceiver msgReceiver) {
        this.msgReceiver = msgReceiver;
    }

    public ClientConnectionImpl(MessageReceiver msgReceiver, Properties props) {
        this.msgReceiver = msgReceiver;
        this.props = props;
    }

    public ClientConnectionImpl(MessageReceiver msgReceiver, Properties props, Object connectionId) {
        this.msgReceiver = msgReceiver;
        this.props = props;
        this.connectionId = connectionId;
        if (CommPlatformPlugin.DEBUG) {
            String debug = CommPlatformPlugin.Util.getString("ClientConnectionImpl.ConnectionID", connectionId, msgReceiver, props);
            CommPlatformPlugin.Util.log(1, debug);
        }
    }

    public Object getConnectionProperty(String propertyName) {
        if (this.props != null) {
            return this.props.get(propertyName);
        }
        return null;
    }

    public void send(Message message, String messageKey) throws CommunicationException {
        try {
            if (CommPlatformPlugin.DEBUG) {
                String debug = CommPlatformPlugin.Util.getString("ClientConnectionImpl.Send", this.connectionId, messageKey, message);
                CommPlatformPlugin.Util.log(1, debug);
            }
            this.msgReceiver.receive(messageKey, message);
        }
        catch (RemoteException re) {
            throw new CommunicationException((Throwable)re, re.getMessage());
        }
    }

    public void shutdown() {
    }

    public String getConnectionId() {
        return this.connectionId.toString();
    }

    public Object getConnectionIdObject() {
        return this.connectionId;
    }

    public void setSessionPayload(Serializable payload) {
        if (payload != null) {
            this.props.put("trustedPayload", payload);
        }
    }
}

