/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.datatype;

import com.metamatrix.dqp.DQPPlugin;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class ClobImpl
implements Clob,
Serializable {
    public static final int DEFAULT_MAX_SIZE = 5000000;
    private char[] data;

    public ClobImpl(Clob clob) throws SQLException {
        try {
            int length = (int)clob.length();
            this.data = new char[length];
            Reader reader = clob.getCharacterStream();
            int charsRead = 0;
            int start = 0;
            for (int bytesToRead = length; (charsRead = reader.read(this.data, start, bytesToRead)) != -1 && bytesToRead != 0; bytesToRead -= charsRead) {
                start += charsRead;
            }
        }
        catch (IOException ioe) {
            throw new SQLException(DQPPlugin.Util.getString("ClobImpl.Failed_copy_clob", ioe.getMessage()));
        }
    }

    public ClobImpl(char[] originalData) {
        this.data = new char[originalData.length];
        int originalDataStartPosition = 0;
        int dataStartPosition = 0;
        int charsToCopy = originalData.length;
        System.arraycopy(originalData, originalDataStartPosition, this.data, dataStartPosition, charsToCopy);
    }

    public ClobImpl(InputStream in, int length) throws SQLException {
        this.data = new char[length];
        try {
            new InputStreamReader(in).read(this.data, 0, length);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public ClobImpl(Reader reader, int length) throws SQLException {
        this.data = new char[length];
        try {
            reader.read(this.data, 0, length);
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        byte[] bytes = new String(this.data).getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public Reader getCharacterStream() throws SQLException {
        return new CharArrayReader(this.data);
    }

    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new SQLException(DQPPlugin.Util.getString("ClobImpl.Invalid_substring_position", new Long(pos)));
        }
        if (pos > (long)this.data.length) {
            return null;
        }
        if (length < 0) {
            throw new SQLException(DQPPlugin.Util.getString("ClobImpl.Invalid_substring_length", new Long(length)));
        }
        if (length > this.data.length) {
            length = this.data.length;
        }
        return new String(this.data, (int)(--pos), length);
    }

    public long length() throws SQLException {
        return this.data.length;
    }

    public long position(Clob searchstr, long start) throws SQLException {
        if (searchstr == null || start > (long)this.data.length) {
            return -1L;
        }
        int length = (int)searchstr.length();
        String searchString = searchstr.getSubString(1L, length);
        return this.position(searchString, start);
    }

    public long position(String searchstr, long start) throws SQLException {
        int position;
        if (start < 1L) {
            throw new SQLException(DQPPlugin.Util.getString("ClobImpl.Invalid_start_position", new Long(start)));
        }
        if (searchstr == null || start > (long)this.data.length) {
            return -1L;
        }
        String str = new String(this.data);
        if ((position = str.indexOf(searchstr, (int)(--start))) != -1) {
            ++position;
        }
        return position;
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null || this.data == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ClobImpl)) {
                return false;
            }
            ClobImpl clob = (ClobImpl)obj;
            if (clob.length() != this.length()) {
                return false;
            }
            String str = clob.getSubString(1L, (int)clob.length());
            if (!str.equals(new String(this.data))) {
                return false;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        int i;
        String pre = "{";
        String post = "";
        int lastByte = this.data.length - 1;
        int frontTruncate = 5;
        int endTruncate = lastByte - 5;
        if (lastByte < 10) {
            frontTruncate = lastByte;
            endTruncate = lastByte;
        }
        for (i = 0; i < frontTruncate; ++i) {
            pre = pre + this.data[i] + ",";
        }
        for (i = endTruncate; i < lastByte; ++i) {
            post = post + "," + this.data[i];
        }
        post = post + "}";
        return "Length:" + this.data.length + ":" + pre + "..." + post;
    }

    public int setString(long pos, String str) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

