/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.util;

import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.MessageHolder;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerInstance;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.service.ExceptionHolder;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.TransactionMessage;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.util.ThreadIdentifier;
import com.metamatrix.jdbc.util.UserTransactionProxy;
import javax.transaction.UserTransaction;
import javax.transaction.xa.Xid;

public class TransactionHelper {
    public static UserTransaction createUserTransaction(ServerConnection connection, ServerInstance instance) throws MMSQLException {
        UserTransactionProxy ut = new UserTransactionProxy(connection, instance);
        return ut;
    }

    public static UserTransaction getRequiredTransaction(ServerConnection connection, ServerInstance instance, RequestMessage request) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setRequestID(msg.getRequestID());
        msg.setCommand(request.getCommand());
        msg.setRequestType(1);
        TransactionMessage returnMsg = TransactionHelper.sendMessage(msg, connection, instance);
        if (returnMsg.hasException()) {
            MMSQLException e = MMSQLException.create(returnMsg.getException(), JDBCPlugin.Util.getString("TransactionHelper.Unable_to_check_for_required_transaction"));
            throw e;
        }
        UserTransactionProxy ut = null;
        if (returnMsg.isTxnRequired()) {
            ut = new UserTransactionProxy(connection, instance);
        }
        return ut;
    }

    public static void startTransaction(ServerConnection serverConn, ServerInstance serverInstance, Xid arg0, int arg1) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setThreadIdentifier(ThreadIdentifier.get());
        msg.setRequestType(7);
        msg.setXid(arg0);
        msg.setParameter(arg1);
        TransactionHelper.sendMessage(msg, serverConn, serverInstance);
    }

    public static void commitTransaction(ServerConnection serverConn, ServerInstance serverInstance, Xid arg0, boolean arg1) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setThreadIdentifier(ThreadIdentifier.get());
        msg.setRequestType(8);
        msg.setXid(arg0);
        msg.setParameter(arg1 ? 1 : 0);
        TransactionHelper.sendMessage(msg, serverConn, serverInstance);
    }

    public static void endTransaction(ServerConnection serverConn, ServerInstance serverInstance, Xid arg0, int arg1) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setThreadIdentifier(ThreadIdentifier.get());
        msg.setRequestType(11);
        msg.setXid(arg0);
        msg.setParameter(arg1);
        TransactionHelper.sendMessage(msg, serverConn, serverInstance);
    }

    public static void forgetTransaction(ServerConnection serverConn, ServerInstance serverInstance, Xid arg0) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setThreadIdentifier(ThreadIdentifier.get());
        msg.setRequestType(10);
        msg.setXid(arg0);
        TransactionHelper.sendMessage(msg, serverConn, serverInstance);
    }

    public static int prepareTransaction(ServerConnection serverConn, ServerInstance serverInstance, Xid arg0) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setThreadIdentifier(ThreadIdentifier.get());
        msg.setRequestType(12);
        msg.setXid(arg0);
        return TransactionHelper.sendMessage(msg, serverConn, serverInstance).getParameter();
    }

    public static Xid[] recoverTransaction(ServerConnection serverConn, ServerInstance serverInstance, int arg0) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setThreadIdentifier(ThreadIdentifier.get());
        msg.setRequestType(13);
        return TransactionHelper.sendMessage(msg, serverConn, serverInstance).getRecoveredXids();
    }

    public static void rollbackTransaction(ServerConnection serverConn, ServerInstance serverInstance, Xid arg0) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setThreadIdentifier(ThreadIdentifier.get());
        msg.setRequestType(9);
        msg.setXid(arg0);
        TransactionHelper.sendMessage(msg, serverConn, serverInstance);
    }

    public static void setTransactionTimeout(ServerConnection serverConn, ServerInstance serverInstance, int seconds) throws MMSQLException {
        TransactionMessage msg = new TransactionMessage();
        msg.setThreadIdentifier(ThreadIdentifier.get());
        msg.setRequestType(14);
        msg.setTxnTimeout(seconds);
        TransactionHelper.sendMessage(msg, serverConn, serverInstance);
    }

    private static TransactionMessage sendMessage(TransactionMessage msg, ServerConnection connection, ServerInstance instance) throws MMSQLException {
        try {
            Message returnedMsg = connection.send(msg, instance);
            if (returnedMsg instanceof TransactionMessage) {
                msg = (TransactionMessage)returnedMsg;
            } else if (returnedMsg instanceof MessageHolder) {
                ExceptionHolder contents = (ExceptionHolder)((MessageHolder)returnedMsg).contents;
                msg.setException(contents.exception);
            } else {
                Object[] params = new Object[]{returnedMsg};
                msg.setException(new MetaMatrixRuntimeException(JDBCPlugin.Util.getString("UserTransactionProxy.Unknown_msg_type", params)));
            }
        }
        catch (CommunicationException e) {
            throw MMSQLException.create(e);
        }
        catch (ApplicationException e) {
            throw MMSQLException.create(e);
        }
        if (msg.getException() != null) {
            throw MMSQLException.create(msg.getException());
        }
        return msg;
    }
}

