/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.lang;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SetQuery
extends QueryCommand {
    public static final int UNION = 0;
    public static final int INTERSECT = 1;
    public static final int EXCEPT = 2;
    private int operation;
    private List queries = new ArrayList();
    private List allFlags = new ArrayList();

    public SetQuery() {
    }

    public SetQuery(int operation) {
        this.operation = operation;
    }

    public int getType() {
        return 1;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getOperation() {
        return this.operation;
    }

    public void addQuery(QueryCommand query) {
        this.addQuery(query, true);
    }

    public void addQuery(QueryCommand query, boolean useAll) {
        if (this.queries.isEmpty()) {
            useAll = true;
        }
        this.queries.add(query);
        this.allFlags.add(useAll);
    }

    public void addQueries(List queries, List useAll) {
        this.queries.addAll(queries);
        this.allFlags.addAll(useAll);
    }

    public void removeAllQueries() {
        this.queries.clear();
        this.allFlags.clear();
    }

    public List getQueries() {
        return this.queries;
    }

    public List getUseAllFlags() {
        return this.allFlags;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public List getProjectedSymbols() {
        if (this.queries.size() > 0) {
            return ((QueryCommand)this.queries.get(0)).getProjectedSymbols();
        }
        return new ArrayList();
    }

    public static String getOperationString(int setOperation) {
        if (setOperation == 0) {
            return "UNION";
        }
        if (setOperation == 1) {
            return "INTERSECT";
        }
        if (setOperation == 2) {
            return "EXCEPT";
        }
        return "null";
    }

    public Object clone() {
        SetQuery copy = new SetQuery(this.operation);
        ArrayList<Object> copyQueries = new ArrayList<Object>(this.queries.size());
        Iterator iter = this.queries.iterator();
        while (iter.hasNext()) {
            QueryCommand subQuery = (QueryCommand)iter.next();
            copyQueries.add(subQuery.clone());
        }
        ArrayList copyAllFlags = new ArrayList(this.allFlags);
        copy.addQueries(copyQueries, copyAllFlags);
        if (this.getOrderBy() != null) {
            copy.setOrderBy((OrderBy)this.getOrderBy().clone());
        }
        if (this.getLimit() != null) {
            copy.setLimit((Limit)this.getLimit().clone());
        }
        if (this.getOption() != null) {
            copy.setOption((Option)this.getOption().clone());
        }
        copy.setIsResolved(this.isResolved());
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SetQuery other = (SetQuery)obj;
        return this.getOperation() == other.getOperation() && EquivalenceUtil.areEqual(this.getQueries(), other.getQueries()) && EquivalenceUtil.areEqual(this.getUseAllFlags(), other.getUseAllFlags()) && EquivalenceUtil.areEqual(this.getOrderBy(), other.getOrderBy()) && EquivalenceUtil.areEqual(this.getLimit(), other.getLimit()) && EquivalenceUtil.areEqual(this.getOption(), other.getOption());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.operation);
        if (this.queries.size() > 0) {
            myHash = HashCodeUtil.hashCode(myHash, this.queries.get(0));
        }
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean areResultsCachable() {
        for (int i = 0; i < this.queries.size(); ++i) {
            Query query = (Query)this.queries.get(i);
            if (query.getInto() == null) continue;
            return false;
        }
        return true;
    }

    public int updatingModelCount(QueryMetadataInterface metadata) throws MetaMatrixComponentException {
        return this.getSubCommandsUpdatingModelCount(metadata);
    }
}

