/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.proc;

import com.metamatrix.core.util.EquivalenceUtil;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.visitor.SQLStringVisitor;

public class LoopStatement
extends Statement
implements SubqueryContainer {
    private String cursorName;
    private Block loopBlock;
    private Command query;

    public LoopStatement(Block block, Command query, String cursorName) {
        this.loopBlock = block;
        this.query = query;
        this.cursorName = cursorName;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public Block getBlock() {
        return this.loopBlock;
    }

    public Command getCommand() {
        return this.query;
    }

    public void setCommand(Command command) {
        this.query = command;
    }

    public void setCursorName(String cursorName) {
        this.cursorName = cursorName;
    }

    public void setBlock(Block block) {
        this.loopBlock = block;
    }

    public void setCommand(Query query) {
        this.query = query;
    }

    public int getType() {
        return 6;
    }

    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        Block otherBlock = (Block)this.loopBlock.clone();
        Query otherQuery = (Query)this.query.clone();
        return new LoopStatement(otherBlock, otherQuery, this.cursorName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LoopStatement other = (LoopStatement)obj;
        return EquivalenceUtil.areEqual(this.query, other.query) && EquivalenceUtil.areEqual(this.loopBlock, other.loopBlock) && EquivalenceUtil.areEqual(this.cursorName, other.cursorName);
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode(myHash, this.loopBlock);
        myHash = HashCodeUtil.hashCode(myHash, this.query);
        myHash = HashCodeUtil.hashCode(myHash, this.cursorName);
        return myHash;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

