/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.sql.visitor;

import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.BetweenCriteria;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.MatchCriteria;
import com.metamatrix.query.sql.lang.SetCriteria;
import com.metamatrix.query.sql.lang.SubqueryCompareCriteria;
import com.metamatrix.query.sql.lang.SubquerySetCriteria;
import com.metamatrix.query.sql.navigator.PreOrderNavigator;
import com.metamatrix.query.sql.symbol.CaseExpression;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.SearchedCaseExpression;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ExpressionMappingVisitor
extends LanguageVisitor {
    private Map symbolMap;

    public ExpressionMappingVisitor(Map symbolMap) {
        this.symbolMap = symbolMap;
    }

    public void visit(BetweenCriteria obj) {
        obj.setExpression(this.getMapping(obj.getExpression()));
        obj.setLowerExpression(this.getMapping(obj.getLowerExpression()));
        obj.setUpperExpression(this.getMapping(obj.getUpperExpression()));
    }

    public void visit(CaseExpression obj) {
        obj.setExpression(this.getMapping(obj.getExpression()));
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whens.add(this.getMapping(obj.getWhenExpression(i)));
            thens.add(this.getMapping(obj.getThenExpression(i)));
        }
        obj.setWhen(whens, thens);
        if (obj.getElseExpression() != null) {
            obj.setElseExpression(this.getMapping(obj.getElseExpression()));
        }
    }

    public void visit(CompareCriteria obj) {
        obj.setLeftExpression(this.getMapping(obj.getLeftExpression()));
        obj.setRightExpression(this.getMapping(obj.getRightExpression()));
    }

    public void visit(Function obj) {
        Expression[] args = obj.getArgs();
        if (args != null && args.length > 0) {
            Expression[] newArgs = new Expression[args.length];
            for (int i = 0; i < args.length; ++i) {
                newArgs[i] = this.getMapping(args[i]);
            }
            obj.setArgs(newArgs);
        }
    }

    public void visit(IsNullCriteria obj) {
        obj.setExpression(this.getMapping(obj.getExpression()));
    }

    public void visit(MatchCriteria obj) {
        obj.setLeftExpression(this.getMapping(obj.getLeftExpression()));
        obj.setRightExpression(this.getMapping(obj.getRightExpression()));
    }

    public void visit(SearchedCaseExpression obj) {
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            thens.add(this.getMapping(obj.getThenExpression(i)));
        }
        obj.setWhen(obj.getWhen(), thens);
        if (obj.getElseExpression() != null) {
            obj.setElseExpression(this.getMapping(obj.getElseExpression()));
        }
    }

    public void visit(SetCriteria obj) {
        obj.setExpression(this.getMapping(obj.getExpression()));
        ArrayList<Expression> newValues = new ArrayList<Expression>(obj.getValues().size());
        Iterator valueIter = obj.getValues().iterator();
        while (valueIter.hasNext()) {
            newValues.add(this.getMapping((Expression)valueIter.next()));
        }
        obj.setValues(newValues);
    }

    public void visit(DependentSetCriteria obj) {
        obj.setExpression(this.getMapping(obj.getExpression()));
    }

    public void visit(SubqueryCompareCriteria obj) {
        obj.setLeftExpression(this.getMapping(obj.getLeftExpression()));
    }

    public void visit(SubquerySetCriteria obj) {
        obj.setExpression(this.getMapping(obj.getExpression()));
    }

    private Expression getMapping(Expression element) {
        Expression mapped = (Expression)this.symbolMap.get(element);
        if (mapped != null) {
            return mapped;
        }
        return element;
    }

    public static void mapExpressions(LanguageObject obj, Map exprMap) {
        if (obj == null) {
            return;
        }
        ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(exprMap);
        PreOrderNavigator.doVisit(obj, visitor);
    }
}

