/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.BufferManagerLookup;
import com.metamatrix.common.buffer.MemoryNotAvailableException;
import com.metamatrix.common.buffer.StorageManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.log.LogManager;
import java.util.List;
import java.util.Properties;

public class LoggingBufferManagerProxy
implements BufferManager {
    private static final String CONTEXT = "BM";
    private BufferManager proxy;

    public LoggingBufferManagerProxy(BufferManager proxy) {
        this.proxy = proxy;
    }

    public void initialize(BufferManagerLookup lookup, Properties properties) throws MetaMatrixComponentException {
        LogManager.logInfo(CONTEXT, CommonPlugin.Util.getString("MSG.003.006.0001"));
        this.proxy.initialize(lookup, properties);
        LogManager.logDetail(CONTEXT, "initialize(" + properties + ")");
    }

    public int getProcessorBatchSize() {
        return this.proxy.getProcessorBatchSize();
    }

    public int getConnectorBatchSize() {
        return this.proxy.getConnectorBatchSize();
    }

    public void addStorageManager(StorageManager storageManager) {
        LogManager.logDetail(CONTEXT, "addStorageManager(" + storageManager + ")");
        this.proxy.addStorageManager(storageManager);
    }

    public TupleSourceID createTupleSource(List elements, String[] types, String groupName, int tupleSourceType) throws MetaMatrixComponentException {
        LogManager.logDetail(CONTEXT, "createTupleSource(" + elements + ", " + groupName + ", " + tupleSourceType + ")");
        TupleSourceID tsID = this.proxy.createTupleSource(elements, types, groupName, tupleSourceType);
        LogManager.logDetail(CONTEXT, "--> " + tsID);
        return tsID;
    }

    public void removeTupleSource(TupleSourceID tupleSourceID) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        LogManager.logDetail(CONTEXT, "removeTupleSource(" + tupleSourceID + ")");
        this.proxy.removeTupleSource(tupleSourceID);
    }

    public void removeTupleSources(String groupName) throws MetaMatrixComponentException {
        LogManager.logDetail(CONTEXT, "removeTupleSources(" + groupName + ")");
        this.proxy.removeTupleSources(groupName);
    }

    public TupleSource getTupleSource(TupleSourceID tupleSourceID) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        LogManager.logDetail(CONTEXT, "getTupleSource(" + tupleSourceID + ")");
        TupleSource source = this.proxy.getTupleSource(tupleSourceID);
        LogManager.logDetail(CONTEXT, "--> " + source);
        return source;
    }

    public TupleBatch pinTupleBatch(TupleSourceID tupleSourceID, int beginRow, int maxEndRow) throws TupleSourceNotFoundException, MemoryNotAvailableException, MetaMatrixComponentException {
        LogManager.logDetail(CONTEXT, "pinTupleBatch(" + tupleSourceID + ", " + beginRow + ", " + maxEndRow + ")");
        TupleBatch batch = this.proxy.pinTupleBatch(tupleSourceID, beginRow, maxEndRow);
        LogManager.logDetail(CONTEXT, "--> " + batch);
        return batch;
    }

    public void unpinTupleBatch(TupleSourceID tupleSourceID, int firstRow, int lastRow) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        LogManager.logDetail(CONTEXT, "unpinTupleBatch(" + tupleSourceID + ", " + firstRow + ", " + lastRow + ")");
        this.proxy.unpinTupleBatch(tupleSourceID, firstRow, lastRow);
    }

    public List getTupleSchema(TupleSourceID tupleSourceID) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        LogManager.logDetail(CONTEXT, "getTupleSchema(" + tupleSourceID + ")");
        List schema = this.proxy.getTupleSchema(tupleSourceID);
        LogManager.logDetail(CONTEXT, "--> " + schema);
        return schema;
    }

    public void addTupleBatch(TupleSourceID tupleSourceID, TupleBatch tupleBatch) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        LogManager.logDetail(CONTEXT, "addTupleBatch(" + tupleSourceID + ", " + tupleBatch + ")");
        this.proxy.addTupleBatch(tupleSourceID, tupleBatch);
    }

    public int getRowCount(TupleSourceID tupleSourceID) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        LogManager.logDetail(CONTEXT, "getRowCount(" + tupleSourceID + ")");
        int rowCount = this.proxy.getRowCount(tupleSourceID);
        LogManager.logDetail(CONTEXT, "--> " + rowCount);
        return rowCount;
    }

    public void setStatus(TupleSourceID tupleSourceID, int status) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        LogManager.logDetail(CONTEXT, "setStatus(" + tupleSourceID + ", " + status + ")");
        this.proxy.setStatus(tupleSourceID, status);
    }

    public int getStatus(TupleSourceID tupleSourceID) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        LogManager.logDetail(CONTEXT, "getStatus(" + tupleSourceID + ")");
        int status = this.proxy.getStatus(tupleSourceID);
        LogManager.logDetail(CONTEXT, "--> " + status);
        return status;
    }

    public int getFinalRowCount(TupleSourceID tupleSourceID) throws TupleSourceNotFoundException, MetaMatrixComponentException {
        LogManager.logDetail(CONTEXT, "getFinalRowCount(" + tupleSourceID + ")");
        int count = this.proxy.getFinalRowCount(tupleSourceID);
        LogManager.logDetail(CONTEXT, "--> " + count);
        return count;
    }

    public void stop() {
        LogManager.logDetail(CONTEXT, "stop()");
        this.proxy.stop();
    }
}

