/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.buffer.impl;

import com.metamatrix.common.log.LogManager;

public class BufferStats {
    public long memoryUsed;
    public long memoryFree;
    public int numTupleSources;
    public int numPersistentBatches;
    public int numPinnedBatches;
    public int numUnpinnedBatches;
    public long freeDiskSpace;
    public String sLocalDrive;
    public int pinRequests;
    public int pinSuccesses;
    public int pinnedFromMemory;
    public int numCleanings;
    public long totalCleaned;

    BufferStats() {
    }

    void log() {
        LogManager.logInfo("BUFFER_MGR", "BUFFER MANAGER STATS");
        LogManager.logInfo("BUFFER_MGR", "    memoryFree = " + this.memoryFree);
        LogManager.logInfo("BUFFER_MGR", "    memoryUsed = " + this.memoryUsed);
        LogManager.logInfo("BUFFER_MGR", "    numTupleSources = " + this.numTupleSources);
        LogManager.logInfo("BUFFER_MGR", "    numPersistentBatches = " + this.numPersistentBatches);
        LogManager.logInfo("BUFFER_MGR", "    numPinnedBatches = " + this.numPinnedBatches);
        LogManager.logInfo("BUFFER_MGR", "    numUnpinnedBatches = " + this.numUnpinnedBatches);
        LogManager.logInfo("BUFFER_MGR", "    pinRequests = " + this.pinRequests);
        double pinSuccessRate = this.pinRequests > 0 ? (double)this.pinSuccesses / (double)this.pinRequests * 100.0 : 100.0;
        LogManager.logInfo("BUFFER_MGR", "    pinSuccessRate = " + pinSuccessRate);
        double memoryHitRate = this.pinRequests > 0 ? (double)this.pinnedFromMemory / (double)this.pinRequests * 100.0 : 100.0;
        LogManager.logInfo("BUFFER_MGR", "    memoryHitRate = " + memoryHitRate);
        LogManager.logInfo("BUFFER_MGR", "    numCleanings = " + this.numCleanings);
        long avgCleaned = this.numCleanings > 0 ? this.totalCleaned / (long)this.numCleanings : 0L;
        LogManager.logInfo("BUFFER_MGR", "    avgCleaned = " + avgCleaned);
        if (this.freeDiskSpace > -1L) {
            LogManager.logInfo("BUFFER_MGR", "    free disk space (Kb) = " + this.freeDiskSpace);
        } else {
            LogManager.logInfo("BUFFER_MGR", "    free disk space UNKNOWN");
        }
    }
}

