/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.xml;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationInfo;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.model.BasicComponentObject;
import com.metamatrix.common.config.model.BasicComponentType;
import com.metamatrix.common.config.model.BasicUtil;
import com.metamatrix.common.config.util.ConfigurationPropertyNames;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLHelper;
import com.metamatrix.common.config.xml.XMLHelperUtil;
import com.metamatrix.common.namedobject.BaseObject;
import com.metamatrix.common.object.Multiplicity;
import com.metamatrix.common.object.MultiplicityExpressionException;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyDefinitionImpl;
import com.metamatrix.common.object.PropertyType;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.Assertion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Content;
import org.jdom.Element;

public class XMLHelperImpl
implements XMLHelper,
ConfigurationPropertyNames {
    public Element createConfigurationElement(Configuration configuration) {
        Assertion.isNotNull((Object)configuration);
        Element productServiceConfigsElement = new Element("Configuration.ProductServiceConfigs");
        Element serviceDefnsElement = this.createServiceComponentDefnsElement();
        Element deployedComponentsElement = new Element("Configuration.DeployedComponents");
        Element vmComponentDefnsElement = new Element("Configuration.VMComponentDefns");
        Element resourcePoolsElement = new Element("Configuration.ResourcePools");
        Element configElement = this.createComponentObjectElement("Configuration", configuration);
        configElement.addContent((Content)productServiceConfigsElement);
        configElement.addContent((Content)serviceDefnsElement);
        configElement.addContent((Content)deployedComponentsElement);
        configElement.addContent((Content)vmComponentDefnsElement);
        configElement.addContent((Content)resourcePoolsElement);
        return configElement;
    }

    public Element createConfigurationInfoElement(ConfigurationInfo info) {
        Assertion.isNotNull((Object)info);
        Element configurationInfoElement = new Element("ConfigurationInfo");
        Date date = info.getLastChangedDate();
        if (date != null) {
            configurationInfoElement.setAttribute("LastChangedDate", date.toString());
        }
        if ((date = info.getCreationDate()) != null) {
            configurationInfoElement.setAttribute("CreationDate", date.toString());
        }
        return configurationInfoElement;
    }

    public Element createVMComponentDefnElement(VMComponentDefn defn) {
        Assertion.isNotNull((Object)defn);
        Element vmComponentDefnElement = this.createComponentObjectElement("VMComponentDefn", defn);
        return vmComponentDefnElement;
    }

    public Element createServiceComponentDefnElement(ServiceComponentDefn defn) {
        Assertion.isNotNull((Object)defn);
        Element serviceComponentDefnElement = this.createComponentObjectElement("ServiceComponentDefn", defn);
        serviceComponentDefnElement.setAttribute("QueuedService", new Boolean(defn.isQueuedService()).toString());
        serviceComponentDefnElement.setAttribute("routingUUID", defn.getRoutingUUID());
        return serviceComponentDefnElement;
    }

    public Element createProductServiceConfigElement(ProductServiceConfig config) {
        Assertion.isNotNull((Object)config);
        Element productServiceConfigElement = this.createComponentObjectElement("ProductServiceConfig", config);
        Iterator iterator = config.getServiceComponentDefnIDs().iterator();
        while (iterator.hasNext()) {
            ServiceComponentDefnID id = (ServiceComponentDefnID)iterator.next();
            boolean isEnabled = config.isServiceEnabled(id);
            Element idElement = this.createIDElement("ServiceComponentDefnID", id.getName());
            idElement.setAttribute("IsEnabled", new Boolean(isEnabled).toString());
            productServiceConfigElement.addContent((Content)idElement);
        }
        return productServiceConfigElement;
    }

    public Element createComponentTypeElement(ComponentType type) {
        ComponentTypeID parentID;
        Assertion.isNotNull((Object)type);
        Element componentTypeElement = new Element("ComponentType");
        Iterator iterator = type.getComponentTypeDefinitions().iterator();
        while (iterator.hasNext()) {
            ComponentTypeDefn defn = (ComponentTypeDefn)iterator.next();
            Element componentTypeDefnElement = this.createComponentTypeDefnElement(defn);
            Element propertyDefinitionElement = this.createPropertyDefinitionElement(defn.getPropertyDefinition());
            componentTypeDefnElement.addContent((Content)propertyDefinitionElement);
            componentTypeElement.addContent((Content)componentTypeDefnElement);
        }
        componentTypeElement.setAttribute("Name", type.getName());
        componentTypeElement.setAttribute("ComponentTypeCode", new Integer(type.getComponentTypeCode()).toString());
        componentTypeElement.setAttribute("Deployable", new Boolean(type.isDeployable()).toString());
        componentTypeElement.setAttribute("Deprecated", new Boolean(type.isDeprecated()).toString());
        componentTypeElement.setAttribute("Monitorable", new Boolean(type.isMonitored()).toString());
        ComponentTypeID superID = type.getSuperComponentTypeID();
        if (superID != null) {
            String superIDString = superID.getName();
            componentTypeElement.setAttribute("SuperComponentType", superIDString);
        }
        if ((parentID = type.getParentComponentTypeID()) != null) {
            String parentIDString = parentID.getName();
            componentTypeElement.setAttribute("ParentComponentType", parentIDString);
        }
        Element chgHistoryElement = this.createChangeHistoryElement(type);
        componentTypeElement.addContent((Content)chgHistoryElement);
        return componentTypeElement;
    }

    public Element createPropertyDefinitionElement(PropertyDefinition defn) {
        String valueDelimiter;
        PropertyType type;
        Multiplicity mult;
        Assertion.isNotNull((Object)defn);
        Element propertyDefinitionElement = new Element("PropertyDefinition");
        String name = defn.getName();
        propertyDefinitionElement.setAttribute("Name", name);
        String displayName = defn.getDisplayName();
        propertyDefinitionElement.setAttribute("DisplayName", displayName);
        String shortDescription = defn.getShortDescription();
        propertyDefinitionElement.setAttribute("ShortDescription", shortDescription);
        Object value = defn.getDefaultValue();
        if (value != null) {
            String defaultValue = value.toString();
            propertyDefinitionElement.setAttribute("DefaultValue", defaultValue);
        }
        if ((mult = defn.getMultiplicity()) != null) {
            String multiplicity = mult.toString();
            propertyDefinitionElement.setAttribute("Multiplicity", multiplicity);
        }
        if ((type = defn.getPropertyType()) != null) {
            String propertyType = type.getDisplayName();
            propertyDefinitionElement.setAttribute("PropertyType", propertyType);
        }
        if ((valueDelimiter = defn.getValueDelimiter()) == null) {
            valueDelimiter = ",";
        }
        String isConstrainedToAllowedValues = new Boolean(defn.isConstrainedToAllowedValues()).toString();
        String isExpert = new Boolean(defn.isExpert()).toString();
        String isHidden = new Boolean(defn.isHidden()).toString();
        String isMasked = new Boolean(defn.isMasked()).toString();
        String isModifiable = new Boolean(defn.isModifiable()).toString();
        String isPreferred = new Boolean(defn.isPreferred()).toString();
        propertyDefinitionElement.setAttribute("ValueDelimiter", valueDelimiter);
        propertyDefinitionElement.setAttribute("IsConstrainedToAllowedValues", isConstrainedToAllowedValues);
        propertyDefinitionElement.setAttribute("IsExpert", isExpert);
        propertyDefinitionElement.setAttribute("IsHidden", isHidden);
        propertyDefinitionElement.setAttribute("IsMasked", isMasked);
        propertyDefinitionElement.setAttribute("IsModifiable", isModifiable);
        propertyDefinitionElement.setAttribute("IsPreferred", isPreferred);
        List allowedValues = defn.getAllowedValues();
        Iterator iterator = allowedValues.iterator();
        while (iterator.hasNext()) {
            Element allowedValueElement = new Element("AllowedValue");
            allowedValueElement.addContent(iterator.next().toString());
            propertyDefinitionElement.addContent((Content)allowedValueElement);
        }
        return propertyDefinitionElement;
    }

    public Element createComponentTypeDefnElement(ComponentTypeDefn defn) {
        Assertion.isNotNull((Object)defn);
        Element componentTypeDefnElement = new Element("ComponentTypeDefn");
        componentTypeDefnElement.setAttribute("Deprecated", new Boolean(defn.isDeprecated()).toString());
        return componentTypeDefnElement;
    }

    public Element createProductTypeElement(ProductType type) {
        Assertion.isNotNull((Object)type);
        Element productTypeElement = new Element("ProductType");
        Iterator iterator = type.getComponentTypeIDs().iterator();
        while (iterator.hasNext()) {
            ComponentTypeID id = (ComponentTypeID)iterator.next();
            Element componentTypeIDElement = this.createIDElement("ComponentTypeID", id.getName());
            productTypeElement.addContent((Content)componentTypeIDElement);
        }
        productTypeElement.setAttribute("Name", type.getName());
        productTypeElement.setAttribute("ComponentTypeCode", new Integer(type.getComponentTypeCode()).toString());
        productTypeElement.setAttribute("Deployable", new Boolean(type.isDeployable()).toString());
        productTypeElement.setAttribute("Deprecated", new Boolean(type.isDeprecated()).toString());
        productTypeElement.setAttribute("Monitorable", new Boolean(type.isMonitored()).toString());
        ComponentTypeID superID = type.getSuperComponentTypeID();
        if (superID != null) {
            String superIDString = superID.getName();
            productTypeElement.setAttribute("SuperComponentType", superIDString);
        }
        Element chgHistoryElement = this.createChangeHistoryElement(type);
        productTypeElement.addContent((Content)chgHistoryElement);
        return productTypeElement;
    }

    public Element createHostElement(Host host) {
        Assertion.isNotNull((Object)host);
        Element hostElement = this.createComponentObjectElement("Host", host);
        return hostElement;
    }

    public Properties getHeaderProperties(Element element) throws InvalidConfigurationElementException {
        if (!element.getName().equals("Header")) {
            throw new InvalidConfigurationElementException("This is not the header element: " + element.getName() + ".", (Object)element);
        }
        return XMLHelperUtil.getHeaderProperties(element);
    }

    public Element createHeaderElement(Properties props) {
        Assertion.isNotNull((Object)props);
        Element headerElement = new Element("Header");
        String applicationCreatedByContent = props.getProperty("ApplicationCreatedBy");
        String applicationVersionCreatedByContent = props.getProperty("ApplicationVersion");
        String userNameContent = props.getProperty("UserCreatedBy");
        String configVersionContent = props.getProperty("ConfigurationVersion");
        String serverVersionContent = props.getProperty("MetaMatrixSystemVersion");
        String timeContent = props.getProperty("Time");
        if (configVersionContent != null) {
            Element configurationVersion = new Element("ConfigurationVersion");
            configurationVersion.addContent(configVersionContent);
            headerElement.addContent((Content)configurationVersion);
        }
        if (applicationCreatedByContent != null) {
            Element applicationCreatedBy = new Element("ApplicationCreatedBy");
            applicationCreatedBy.addContent(applicationCreatedByContent);
            headerElement.addContent((Content)applicationCreatedBy);
        }
        if (applicationVersionCreatedByContent != null) {
            Element applicationVersionCreatedBy = new Element("ApplicationVersion");
            applicationVersionCreatedBy.addContent(applicationVersionCreatedByContent);
            headerElement.addContent((Content)applicationVersionCreatedBy);
        }
        if (userNameContent != null) {
            Element userName = new Element("UserCreatedBy");
            userName.addContent(userNameContent);
            headerElement.addContent((Content)userName);
        }
        if (serverVersionContent != null) {
            Element serverVersion = new Element("MetaMatrixSystemVersion");
            serverVersion.addContent(serverVersionContent);
            headerElement.addContent((Content)serverVersion);
        }
        if (timeContent != null) {
            Element time = new Element("Time");
            time.addContent(timeContent);
            headerElement.addContent((Content)time);
        }
        return headerElement;
    }

    private ComponentObject setDateHistory(ComponentObject defn, Element element, ConfigurationObjectEditor editor) {
        String lastChangedBy = null;
        String lastChangedDate = null;
        String createdDate = null;
        String createdBy = null;
        Properties props = this.getChangeHistoryFromElement(element);
        lastChangedBy = props.getProperty("LastChangedBy");
        lastChangedDate = props.getProperty("LastChangedDate");
        createdBy = props.getProperty("CreatedBy");
        createdDate = props.getProperty("CreationDate");
        defn = editor.setCreationChangedHistory(defn, createdBy, createdDate);
        defn = editor.setLastChangedHistory(defn, lastChangedBy, lastChangedDate);
        return defn;
    }

    private ComponentType setDateHistory(ComponentType type, Element element, ConfigurationObjectEditor editor) {
        String lastChangedBy = null;
        String lastChangedDate = null;
        String createdDate = null;
        String createdBy = null;
        Properties props = this.getChangeHistoryFromElement(element);
        lastChangedBy = props.getProperty("LastChangedBy");
        lastChangedDate = props.getProperty("LastChangedDate");
        createdBy = props.getProperty("CreatedBy");
        createdDate = props.getProperty("CreationDate");
        type = editor.setCreationChangedHistory(type, createdBy, createdDate);
        type = editor.setLastChangedHistory(type, lastChangedBy, lastChangedDate);
        return type;
    }

    private Properties getChangeHistoryFromElement(Element parentElement) {
        Element propertiesElement = parentElement.getChild("ChangeHistory");
        if (propertiesElement == null) {
            return new Properties();
        }
        Properties props = new Properties();
        List properties = propertiesElement.getChildren("Property");
        if (properties == null) {
            return new Properties();
        }
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Element propertyElement = (Element)iterator.next();
            String propertyName = propertyElement.getAttributeValue("Name");
            String propertyValue = propertyElement.getText();
            props.setProperty(propertyName, propertyValue != null ? propertyValue : "");
        }
        return props;
    }

    private Element createChangeHistoryElement(ComponentType obj) {
        Element changeHistoryElement = new Element("ChangeHistory");
        String lastChangedBy = null;
        String lastChangedDate = null;
        String createdDate = null;
        String createdBy = null;
        lastChangedBy = obj.getLastChangedBy();
        lastChangedDate = ((BasicComponentType)obj).getLastChangedDateString();
        createdBy = obj.getCreatedBy();
        createdDate = ((BasicComponentType)obj).getCreatedDateString();
        if (lastChangedBy != null && lastChangedBy.trim().length() != 0) {
            changeHistoryElement = this.addPropertyElement(changeHistoryElement, "LastChangedBy", lastChangedBy);
        }
        if (lastChangedDate != null) {
            changeHistoryElement = this.addPropertyElement(changeHistoryElement, "LastChangedDate", lastChangedDate);
        }
        if (createdBy != null && createdBy.trim().length() != 0) {
            changeHistoryElement = this.addPropertyElement(changeHistoryElement, "CreatedBy", createdBy);
        }
        if (createdDate != null) {
            changeHistoryElement = this.addPropertyElement(changeHistoryElement, "CreationDate", createdDate);
        }
        return changeHistoryElement;
    }

    private Element createChangeHistoryElement(ComponentObject obj) {
        Element changeHistoryElement = new Element("ChangeHistory");
        String lastChangedBy = null;
        String lastChangedDate = null;
        String createdDate = null;
        String createdBy = null;
        lastChangedBy = obj.getLastChangedBy();
        lastChangedDate = ((BasicComponentObject)obj).getLastChangedDateString();
        createdBy = obj.getCreatedBy();
        createdDate = ((BasicComponentObject)obj).getCreatedDateString();
        if (lastChangedBy != null && lastChangedBy.trim().length() != 0) {
            changeHistoryElement = this.addPropertyElement(changeHistoryElement, "LastChangedBy", lastChangedBy);
        }
        if (lastChangedDate != null) {
            changeHistoryElement = this.addPropertyElement(changeHistoryElement, "LastChangedDate", lastChangedDate);
        }
        if (createdBy != null && createdBy.trim().length() != 0) {
            changeHistoryElement = this.addPropertyElement(changeHistoryElement, "CreatedBy", createdBy);
        }
        if (createdDate != null) {
            changeHistoryElement = this.addPropertyElement(changeHistoryElement, "CreationDate", createdDate);
        }
        return changeHistoryElement;
    }

    public Element createPropertiesElement(Properties props) {
        Assertion.isNotNull((Object)props);
        Properties sortprops = PropertiesUtils.sort(props);
        Element propertiesElement = new Element("Properties");
        Enumeration<?> enumeration = sortprops.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            propertiesElement = this.addPropertyElement(propertiesElement, propName, props.getProperty(propName));
        }
        return propertiesElement;
    }

    private Element addPropertyElement(Element propertiesElement, String propName, String propValue) {
        Element property = new Element("Property");
        property.setAttribute("Name", propName);
        property.addContent(propValue);
        propertiesElement.addContent((Content)property);
        return propertiesElement;
    }

    public Element createIDElement(String type, String name) {
        Element idElement = new Element(type);
        idElement.setAttribute("Name", name);
        return idElement;
    }

    public Element createConfigurationsElement() {
        return new Element("Configurations");
    }

    public Element createHostsElement() {
        return new Element("Hosts");
    }

    public Element createServiceComponentDefnsElement() {
        return new Element("Configuration.ServiceComponentDefns");
    }

    public Element createComponentTypesElement() {
        return new Element("ComponentTypes");
    }

    public Element createProductTypesElement() {
        return new Element("ProductTypes");
    }

    public Element createProductServiceConfigsElement() {
        throw new UnsupportedOperationException("createProductServiceConfigsElement is unsupported in the 3.0 version of configuration");
    }

    public Element createConnectorBindingsElement() {
        return new Element("ConnectorBindings");
    }

    public Element createRootConfigurationDocumentElement() {
        return new Element("ConfigurationDocument");
    }

    private Element createComponentObjectElement(String type, ComponentObject componentObject) {
        Element componentObjectElement = new Element(type);
        componentObjectElement.setAttribute("Name", componentObject.getName());
        ComponentTypeID id = componentObject.getComponentTypeID();
        if (id != null) {
            componentObjectElement.setAttribute("ComponentType", id.getName());
        }
        Element properties = this.createPropertiesElement(componentObject.getProperties());
        componentObjectElement.addContent((Content)properties);
        Element chgHistoryElement = this.createChangeHistoryElement(componentObject);
        componentObjectElement.addContent((Content)chgHistoryElement);
        return componentObjectElement;
    }

    public Host createHost(Element element, ConfigurationID configID, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        Assertion.isNotNull((Object)element);
        Assertion.isNotNull((Object)editor);
        if (!element.getName().equals("Host")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0032", CommonPlugin.Util.getString("ERR.003.001.0032", (Object)element.getName()), (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        Host host = editor.createHost(configID, name);
        Element propertiesElement = element.getChild("Properties");
        host = (Host)this.setDateHistory(host, element, editor);
        if (propertiesElement != null) {
            host = (Host)this.addProperties(propertiesElement, host, editor);
            return host;
        }
        return host;
    }

    public Element createResourcePoolElement(ResourceDescriptor resource) {
        Assertion.isNotNull((Object)resource);
        Element resourceElement = this.createComponentObjectElement("ResourcePool", resource);
        return resourceElement;
    }

    public ResourceDescriptor createResourcePool(Element element, ConfigurationID configID, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        Assertion.isNotNull((Object)element);
        Assertion.isNotNull((Object)editor);
        if (!element.getName().equals("ResourcePool")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0033", CommonPlugin.Util.getString("ERR.003.001.0033", (Object)element.getName()), (Object)element);
        }
        String name = element.getAttributeValue("Name");
        this.checkElementValue(name, null, "ERR.003.001.0053");
        String type = element.getAttributeValue("ComponentType");
        this.checkElementValue(type, name, "ERR.003.001.0054");
        ComponentTypeID id = new ComponentTypeID(type);
        ResourceDescriptor descriptor = editor.createResourceDescriptor(configID, id, name);
        Element propertiesElement = element.getChild("Properties");
        descriptor = (ResourceDescriptor)this.setDateHistory(descriptor, element, editor);
        if (propertiesElement != null) {
            descriptor = (ResourceDescriptor)this.addProperties(propertiesElement, descriptor, editor);
        }
        return descriptor;
    }

    public Element createResourcePoolsElement() {
        return new Element("Configuration.ResourcePools");
    }

    public Element createSharedResourceElement(SharedResource resource) {
        Assertion.isNotNull((Object)resource);
        Element resourceElement = this.createComponentObjectElement("Resource", resource);
        return resourceElement;
    }

    public SharedResource createSharedResource(Element element, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        Assertion.isNotNull((Object)element);
        Assertion.isNotNull((Object)editor);
        if (!element.getName().equals("Resource")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0034", CommonPlugin.Util.getString("ERR.003.001.0034", (Object)element.getName()), (Object)element);
        }
        String name = element.getAttributeValue("Name");
        this.checkElementValue(name, null, "ERR.003.001.0055");
        String type = element.getAttributeValue("ComponentType");
        this.checkElementValue(type, name, "ERR.003.001.0056");
        ComponentTypeID id = new ComponentTypeID(type);
        SharedResource descriptor = editor.createSharedResource(id, name);
        Element propertiesElement = element.getChild("Properties");
        descriptor = (SharedResource)this.setDateHistory(descriptor, element, editor);
        if (propertiesElement != null) {
            descriptor = (SharedResource)this.addProperties(propertiesElement, descriptor, editor);
        }
        return descriptor;
    }

    public Element createSharedResourcesElement() {
        return new Element("Resources");
    }

    public ComponentType createComponentType(Element element, ConfigurationObjectEditor editor, String name, boolean maintainParentID) throws InvalidConfigurationElementException {
        Assertion.isNotNull((Object)element);
        Assertion.isNotNull((Object)editor);
        if (!element.getName().equals("ComponentType")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0035", CommonPlugin.Util.getString("ERR.003.001.0035", (Object)element.getName()), (Object)element);
        }
        String parentType = element.getAttributeValue("ParentComponentType");
        String superType = element.getAttributeValue("SuperComponentType");
        String componentTypeCode = element.getAttributeValue("ComponentTypeCode");
        String deployable = element.getAttributeValue("Deployable");
        String monitorable = element.getAttributeValue("Monitorable");
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        int typeCode = Integer.parseInt(componentTypeCode);
        ProductTypeID parentTypeID = null;
        ComponentTypeID superTypeID = null;
        if (parentType != null && parentType.length() > 0) {
            parentTypeID = new ProductTypeID(parentType);
        }
        if (superType != null && superType.length() > 0) {
            superTypeID = new ComponentTypeID(superType);
        }
        boolean isDeployable = Boolean.valueOf(deployable);
        boolean isMonitorable = Boolean.valueOf(monitorable);
        ComponentType type = editor.createComponentType(typeCode, name, parentTypeID, superTypeID, isDeployable, isMonitorable);
        List componentTypeDefnElements = element.getChildren("ComponentTypeDefn");
        type = this.setDateHistory(type, element, editor);
        return this.addComponentTypeDefns(componentTypeDefnElements, type, editor);
    }

    public ProductType createProductType(Element element, ConfigurationObjectEditor editor, Map componentTypeMap, String name) throws InvalidConfigurationElementException {
        Assertion.isNotNull((Object)element);
        Assertion.isNotNull((Object)editor);
        if (!element.getName().equals("ProductType")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0036", CommonPlugin.Util.getString("ERR.003.001.0036", (Object)element.getName()), (Object)element);
        }
        String deployable = element.getAttributeValue("Deployable");
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        boolean isDeployable = Boolean.valueOf(deployable);
        List componentTypeIDs = element.getChildren("ComponentTypeID");
        ArrayList<ComponentType> componentTypes = new ArrayList<ComponentType>();
        Iterator iter = componentTypeIDs.iterator();
        while (iter.hasNext()) {
            Element componentTypeIDElement = (Element)iter.next();
            String componentTypeIDName = componentTypeIDElement.getAttributeValue("Name");
            ComponentTypeID componentTypeID = new ComponentTypeID(componentTypeIDName);
            ComponentType componentType = (ComponentType)componentTypeMap.get(componentTypeID);
            if (componentType == null) {
                throw new InvalidConfigurationElementException("ERR.003.001.0037", CommonPlugin.Util.getString("ERR.003.001.0037", new Object[]{componentTypeID, name}), (Object)element);
            }
            componentTypes.add(componentType);
        }
        ProductType type = editor.createProductType(name, componentTypes, isDeployable, false);
        return type;
    }

    public Configuration createConfiguration(Element element, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        Assertion.isNotNull((Object)element);
        Assertion.isNotNull((Object)editor);
        if (!element.getName().equals("Configuration")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0038", CommonPlugin.Util.getString("ERR.003.001.0038", (Object)element.getName()), (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        Configuration config = editor.createConfiguration(name);
        Element propertiesElement = element.getChild("Properties");
        config = (Configuration)this.setDateHistory(config, element, editor);
        if (propertiesElement != null) {
            config = (Configuration)this.addProperties(propertiesElement, config, editor);
            return config;
        }
        return config;
    }

    public Element createConnectorBindingElement(ConnectorBinding connector, boolean isExportConfig) {
        Assertion.isNotNull((Object)connector);
        Element connectorElement = this.createComponentObjectElement("Connector", connector);
        connectorElement.setAttribute("QueuedService", new Boolean(connector.isQueuedService()).toString());
        if (isExportConfig) {
            connectorElement.setAttribute("routingUUID", connector.getRoutingUUID());
        }
        return connectorElement;
    }

    public ConnectorBinding createConnectorBinding(ConfigurationID configurationID, Element element, ConfigurationObjectEditor editor, String name, boolean isImportConfig) throws InvalidConfigurationElementException {
        Assertion.isNotNull((Object)element);
        Assertion.isNotNull((Object)editor);
        if (!element.getName().equals("Connector")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0041", CommonPlugin.Util.getString("ERR.003.001.0041", (Object)element.getName()), (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        String componentType = element.getAttributeValue("ComponentType");
        this.checkElementValue(componentType, name, "ERR.003.001.0057");
        ComponentTypeID id = new ComponentTypeID(componentType);
        String routingUUID = null;
        if (isImportConfig) {
            routingUUID = element.getAttributeValue("routingUUID");
        }
        ConnectorBinding defn = null;
        defn = editor.createConnectorComponent(configurationID, id, name, routingUUID);
        defn = (ConnectorBinding)this.setDateHistory(defn, element, editor);
        Element propertiesElement = element.getChild("Properties");
        if (propertiesElement != null) {
            return (ConnectorBinding)this.addProperties(propertiesElement, defn, editor);
        }
        return defn;
    }

    public ComponentDefn createServiceComponentDefn(Element element, Configuration config, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        ConfigurationID configID = null;
        if (config != null) {
            configID = (ConfigurationID)config.getID();
        }
        return this.createServiceComponentDefn(element, configID, editor, name);
    }

    public ComponentDefn createServiceComponentDefn(Element element, ConfigurationID configID, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        Assertion.isNotNull((Object)element);
        Assertion.isNotNull((Object)editor);
        Assertion.isNotNull((Object)configID);
        if (!element.getName().equals("ServiceComponentDefn")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0042", CommonPlugin.Util.getString("ERR.003.001.0042", (Object)element.getName()), (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        String componentType = element.getAttributeValue("ComponentType");
        this.checkElementValue(componentType, name, "ERR.003.001.0058");
        ComponentTypeID id = new ComponentTypeID(componentType);
        String routingUUID = element.getAttributeValue("routingUUID");
        ComponentDefn defn = null;
        boolean isResourcePool = this.isResourcePool(componentType);
        if (configID != null) {
            defn = !isResourcePool ? (routingUUID == null ? editor.createServiceComponentDefn(configID, id, name) : editor.createServiceComponentDefn(configID, id, name, routingUUID)) : editor.createResourceDescriptor(configID, id, name);
        }
        defn = (ComponentDefn)this.setDateHistory(defn, element, editor);
        Element propertiesElement = element.getChild("Properties");
        if (propertiesElement != null) {
            return (ComponentDefn)this.addProperties(propertiesElement, defn, editor);
        }
        return defn;
    }

    private boolean isResourcePool(String componentTypeName) {
        boolean result = false;
        if (componentTypeName.equals("JDBC Resource Type") || componentTypeName.equals("JMS Resource Type") || componentTypeName.equals("Miscellaneous Resource Type") || componentTypeName.equals("Searchbase Resource Type")) {
            return true;
        }
        return result;
    }

    public boolean is42ConfigurationCompatible(Element element) throws InvalidConfigurationElementException {
        return XMLHelperUtil.is42ConfigurationCompatible(element);
    }

    public ProductServiceConfig createProductServiceConfig(Element element, ConfigurationID configID, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        Iterator iterator;
        Assertion.isNotNull((Object)element);
        Assertion.isNotNull((Object)editor);
        Assertion.isNotNull((Object)configID);
        if (!element.getName().equals("ProductServiceConfig")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0043", CommonPlugin.Util.getString("ERR.003.001.0043", (Object)element.getName()), (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        String componentType = element.getAttributeValue("ComponentType");
        this.checkElementValue(componentType, name, "ERR.003.001.0059");
        ProductTypeID id = new ProductTypeID(componentType);
        ProductServiceConfig productServiceConfig = editor.createProductServiceConfig(configID, id, name);
        List serviceComponentDefnIDs = element.getChildren("ServiceComponentDefnID");
        if (id.getFullName().equals("Connectors")) {
            iterator = serviceComponentDefnIDs.iterator();
            while (iterator.hasNext()) {
                Element serviceComponentDefnIDElement = (Element)iterator.next();
                String serviceComponentDefnName = serviceComponentDefnIDElement.getAttributeValue("Name");
                String enabled = serviceComponentDefnIDElement.getAttributeValue("IsEnabled");
                if (enabled == null) {
                    enabled = Boolean.TRUE.toString();
                }
                ConnectorBindingID serviceComponentDefnID = new ConnectorBindingID(configID, serviceComponentDefnName);
                productServiceConfig = editor.addServiceComponentDefn(productServiceConfig, serviceComponentDefnID);
                editor.setEnabled(serviceComponentDefnID, productServiceConfig, new Boolean(enabled));
            }
        } else {
            iterator = serviceComponentDefnIDs.iterator();
            while (iterator.hasNext()) {
                Element serviceComponentDefnIDElement = (Element)iterator.next();
                String serviceComponentDefnName = serviceComponentDefnIDElement.getAttributeValue("Name");
                String enabled = serviceComponentDefnIDElement.getAttributeValue("IsEnabled");
                if (enabled == null) {
                    enabled = Boolean.TRUE.toString();
                }
                ServiceComponentDefnID serviceComponentDefnID = new ServiceComponentDefnID(configID, serviceComponentDefnName);
                productServiceConfig = editor.addServiceComponentDefn(productServiceConfig, serviceComponentDefnID);
                editor.setEnabled(serviceComponentDefnID, productServiceConfig, new Boolean(enabled));
            }
        }
        productServiceConfig = (ProductServiceConfig)this.setDateHistory(productServiceConfig, element, editor);
        Element propertiesElement = element.getChild("Properties");
        if (propertiesElement != null) {
            productServiceConfig = (ProductServiceConfig)this.addProperties(propertiesElement, productServiceConfig, editor);
            return productServiceConfig;
        }
        return productServiceConfig;
    }

    public Element createDeployedProductServiceConfigElement(ProductServiceConfig config) {
        throw new UnsupportedOperationException("createDeployedProductServiceConfigElement method is not supported in the 3.0 version of configuration");
    }

    public DeployedComponent createDeployedComponent(Element element, ConfigurationID configID, HostID hostID, VMComponentDefnID vmID, ProductServiceConfigID pscID, Map componentTypeMap, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        Assertion.isNotNull((Object)element);
        Assertion.isNotNull((Object)editor);
        Assertion.isNotNull((Object)configID);
        Assertion.isNotNull((Object)hostID);
        Assertion.isNotNull((Object)vmID);
        if (!element.getName().equals("DeployedComponent")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0044", CommonPlugin.Util.getString("ERR.003.001.0044", (Object)element.getName()), (Object)element);
        }
        String name = element.getAttributeValue("Name");
        String componentTypeIDString = element.getAttributeValue("ComponentType");
        String serviceComponentDefnIDString = element.getAttributeValue("ServiceComponentDefnID");
        this.checkElementValue(componentTypeIDString, name, "ERR.003.001.0049");
        this.checkElementValue(serviceComponentDefnIDString, name, "ERR.003.001.0049");
        ComponentType type = null;
        Iterator it = componentTypeMap.keySet().iterator();
        while (it.hasNext()) {
            ComponentTypeID id = (ComponentTypeID)it.next();
            if (!id.getFullName().equals(componentTypeIDString)) continue;
            type = (ComponentType)componentTypeMap.get(id);
            break;
        }
        if (type == null) {
            throw new InvalidConfigurationElementException("ERR.003.001.0050", CommonPlugin.Util.getString("ERR.003.001.0050", new Object[]{componentTypeIDString, serviceComponentDefnIDString}), (Object)element);
        }
        ServiceComponentDefnID svcid = null;
        svcid = type.getComponentTypeCode() == 2 ? new ConnectorBindingID(configID, serviceComponentDefnIDString) : new ServiceComponentDefnID(configID, serviceComponentDefnIDString);
        DeployedComponent component = editor.createDeployedServiceComponent(name, configID, hostID, vmID, svcid, pscID, (ComponentTypeID)type.getID());
        return component;
    }

    public DeployedComponent createDeployedComponent(Element element, Configuration config, ConfigurationObjectEditor editor, Map serviceComponentDefnMap, Map vmComponentDefnMap, Map componentTypeMap, String name) throws InvalidConfigurationElementException {
        DeployedComponent component;
        Assertion.isNotNull((Object)element);
        Assertion.isNotNull((Object)editor);
        Assertion.isNotNull((Object)config);
        if (!element.getName().equals("DeployedComponent")) {
            throw new InvalidConfigurationElementException("ERR.003.001.0044", CommonPlugin.Util.getString("ERR.003.001.0044", (Object)element.getName()), (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        String productServiceConfigIDString = element.getAttributeValue("ProductServiceConfigID");
        String vmComponentDefnIDString = element.getAttributeValue("VMComponentDefnID");
        String serviceComponentDefnIDString = element.getAttributeValue("ServiceComponentDefnID");
        String HostIDString = element.getAttributeValue("HostID");
        this.checkElementValue(vmComponentDefnIDString, name, "ERR.003.001.0045");
        this.checkElementValue(HostIDString, name, "ERR.003.001.0046");
        ConfigurationID configID = (ConfigurationID)config.getID();
        HostID hostID = new HostID(HostIDString);
        VMComponentDefnID vmComponentDefnID = new VMComponentDefnID(configID, hostID, vmComponentDefnIDString);
        String componentTypeIDString = element.getAttributeValue("ComponentType");
        if (serviceComponentDefnIDString == null && productServiceConfigIDString == null) {
            Element vmelement = (Element)vmComponentDefnMap.get(vmComponentDefnIDString);
            VMComponentDefn defn = this.createVMComponentDefn(vmelement, configID, hostID, editor, null);
            if (defn == null) {
                BaseObject type = null;
                Iterator it = componentTypeMap.keySet().iterator();
                while (it.hasNext()) {
                    ComponentTypeID id = (ComponentTypeID)it.next();
                    if (!id.getFullName().equals(componentTypeIDString)) continue;
                    type = (ComponentType)componentTypeMap.get(id);
                    break;
                }
                defn = (VMComponentDefn)((Object)BasicUtil.createComponentDefn(5, configID, hostID, (ComponentTypeID)type.getID(), name));
            }
            component = BasicUtil.createDeployedVMComponent(name, configID, defn.getHostID(), (VMComponentDefnID)defn.getID(), defn.getComponentTypeID());
        } else {
            this.checkElementValue(productServiceConfigIDString, name, "ERR.003.001.0048");
            this.checkElementValue(serviceComponentDefnIDString, name, "ERR.003.001.0049");
            ComponentType type = null;
            Iterator it = componentTypeMap.keySet().iterator();
            while (it.hasNext()) {
                ComponentTypeID id = (ComponentTypeID)it.next();
                if (!id.getFullName().equals(componentTypeIDString)) continue;
                type = (ComponentType)componentTypeMap.get(id);
                break;
            }
            if (type == null) {
                throw new InvalidConfigurationElementException("ERR.003.001.0050", CommonPlugin.Util.getString("ERR.003.001.0050", new Object[]{componentTypeIDString, serviceComponentDefnIDString}), (Object)element);
            }
            ProductServiceConfigID productServiceConfigID = null;
            if (type instanceof ConnectorBindingType) {
                productServiceConfigID = new ProductServiceConfigID(configID, productServiceConfigIDString);
                ConnectorBindingID bindingID = new ConnectorBindingID(configID, serviceComponentDefnIDString);
                ConnectorBinding bdefn = (ConnectorBinding)serviceComponentDefnMap.get(bindingID);
                if (bdefn == null) {
                    throw new InvalidConfigurationElementException("ERR.003.001.0051", CommonPlugin.Util.getString("ERR.003.001.0051", new Object[]{name, serviceComponentDefnIDString}), (Object)element);
                }
                component = editor.createDeployedServiceComponent(name, config, hostID, vmComponentDefnID, bdefn, productServiceConfigID);
            } else {
                productServiceConfigID = new ProductServiceConfigID(configID, productServiceConfigIDString);
                ServiceComponentDefnID serviceComponentDefnID = new ServiceComponentDefnID(configID, serviceComponentDefnIDString);
                ServiceComponentDefn defn = (ServiceComponentDefn)serviceComponentDefnMap.get(serviceComponentDefnID);
                if (defn == null) {
                    throw new InvalidConfigurationElementException("ERR.003.001.0052", CommonPlugin.Util.getString("ERR.003.001.0052", new Object[]{name, serviceComponentDefnIDString}), (Object)element);
                }
                component = editor.createDeployedServiceComponent(name, config, hostID, vmComponentDefnID, defn, productServiceConfigID);
            }
        }
        component = (DeployedComponent)this.setDateHistory(component, element, editor);
        Element propertiesElement = element.getChild("Properties");
        if (propertiesElement != null) {
            return (DeployedComponent)this.addProperties(propertiesElement, component, editor);
        }
        return component;
    }

    public VMComponentDefn createVMComponentDefn(Element element, ConfigurationID configID, HostID hostID, ConfigurationObjectEditor editor, String name) throws InvalidConfigurationElementException {
        Assertion.isNotNull((Object)element);
        Assertion.isNotNull((Object)editor);
        Assertion.isNotNull((Object)configID);
        if (!element.getName().equals("VMComponentDefn")) {
            throw new InvalidConfigurationElementException("A Configuration object cannot be created from a JDOM Element type: " + element.getName() + ".", (Object)element);
        }
        if (name == null) {
            name = element.getAttributeValue("Name");
        }
        String componentType = element.getAttributeValue("ComponentType");
        this.checkElementValue(componentType, name, "ERR.003.001.0060");
        ComponentTypeID id = new ComponentTypeID(componentType);
        VMComponentDefn defn = editor.createVMComponentDefn(configID, hostID, id, name);
        defn = (VMComponentDefn)this.setDateHistory(defn, element, editor);
        Element propertiesElement = element.getChild("Properties");
        if (propertiesElement != null) {
            return (VMComponentDefn)this.addProperties(propertiesElement, defn, editor);
        }
        return defn;
    }

    public PropertyDefinition createPropertyDefinition(Element element) throws InvalidConfigurationElementException {
        if (!element.getName().equals("PropertyDefinition")) {
            throw new InvalidConfigurationElementException("A Configuration object cannot be created from a JDOM Element type: " + element.getName() + ".", (Object)element);
        }
        String nameString = element.getAttributeValue("Name");
        String displayNameString = element.getAttributeValue("DisplayName");
        String shortDescriptionString = element.getAttributeValue("ShortDescription");
        String defaultValueString = element.getAttributeValue("DefaultValue");
        String multiplicityString = element.getAttributeValue("Multiplicity");
        String propertyTypeString = element.getAttributeValue("PropertyType");
        String valueDelimiterString = element.getAttributeValue("ValueDelimiter");
        String isConstrainedToAllowedValuesString = element.getAttributeValue("IsConstrainedToAllowedValues");
        String isExpertString = element.getAttributeValue("IsExpert");
        String isHiddenString = element.getAttributeValue("IsHidden");
        String isMaskedString = element.getAttributeValue("IsMasked");
        String isModifiableString = element.getAttributeValue("IsModifiable");
        String isPreferredString = element.getAttributeValue("IsPreferred");
        Multiplicity mult = null;
        try {
            mult = Multiplicity.getInstance(multiplicityString);
        }
        catch (MultiplicityExpressionException e) {
            throw new InvalidConfigurationElementException((Throwable)((Object)e), "The PropertyDefinition object: " + nameString + " could not be created because the multiplicity definition: '" + multiplicityString + " is not a valid multiplicity definition.", (Object)element);
        }
        PropertyType type = PropertyType.getInstance(propertyTypeString);
        boolean isConstrainedToAllowedValues = Boolean.valueOf(isConstrainedToAllowedValuesString);
        boolean isExpert = Boolean.valueOf(isExpertString);
        boolean isHidden = Boolean.valueOf(isHiddenString);
        boolean isMasked = Boolean.valueOf(isMaskedString);
        boolean isModifiable = Boolean.valueOf(isModifiableString);
        boolean isPreferred = Boolean.valueOf(isPreferredString);
        List allowedValuesElements = element.getChildren("AllowedValue");
        ArrayList<String> allowedValues = new ArrayList<String>(allowedValuesElements.size());
        Iterator iterator = allowedValuesElements.iterator();
        while (iterator.hasNext()) {
            Element allowedValueElement = (Element)iterator.next();
            allowedValues.add(allowedValueElement.getText());
        }
        PropertyDefinitionImpl defn = new PropertyDefinitionImpl(nameString, displayNameString, type, mult, shortDescriptionString, defaultValueString, allowedValues, valueDelimiterString, isHidden, isPreferred, isExpert, isModifiable);
        defn.setMasked(isMasked);
        defn.setConstrainedToAllowedValues(isConstrainedToAllowedValues);
        return defn;
    }

    public ComponentObject addProperties(Element propertiesElement, ComponentObject object, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        if (!propertiesElement.getName().equals("Properties")) {
            throw new InvalidConfigurationElementException("A Properties object cannot be created from a JDOM Element type: " + propertiesElement.getName() + ".", (Object)propertiesElement);
        }
        Properties props = this.getProperties(propertiesElement);
        object = editor.modifyProperties(object, props, 1);
        return object;
    }

    private Properties getProperties(Element propertiesElement) {
        Properties props = new Properties();
        List properties = propertiesElement.getChildren("Property");
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Element propertyElement = (Element)iterator.next();
            String propertyName = propertyElement.getAttributeValue("Name");
            String propertyValue = propertyElement.getText();
            props.setProperty(propertyName, propertyValue);
        }
        return props;
    }

    private ComponentType addComponentTypeDefns(Collection componentTypeDefnElements, ComponentType type, ConfigurationObjectEditor editor) throws InvalidConfigurationElementException {
        ArrayList<ComponentTypeDefn> componentTypeDefns = new ArrayList<ComponentTypeDefn>(componentTypeDefnElements.size());
        Iterator iterator = componentTypeDefnElements.iterator();
        while (iterator.hasNext()) {
            Element componentTypeDefnElement = (Element)iterator.next();
            Element propertyDefinitionElement = componentTypeDefnElement.getChild("PropertyDefinition");
            PropertyDefinition propDefn = this.createPropertyDefinition(propertyDefinitionElement);
            componentTypeDefns.add(editor.createComponentTypeDefn(type, propDefn, false));
        }
        return editor.setComponentTypeDefinitions(type, componentTypeDefns);
    }

    public void orderComponentTypeElementList(List componentTypeElements) {
        ComponentTypeElementComparator comparator = new ComponentTypeElementComparator();
        Collections.sort(componentTypeElements, comparator);
    }

    private void checkElementValue(String value, String name, String errorKey) throws InvalidConfigurationElementException {
        if (value == null || value.trim().length() > 0) {
            if (name != null) {
                if (value == null) {
                    Assertion.isNotNull((Object)value, (String)CommonPlugin.Util.getString(errorKey, (Object)name));
                }
            } else if (value == null) {
                Assertion.isNotNull((Object)value, (String)CommonPlugin.Util.getString(errorKey));
            }
        }
    }

    class ComponentTypeElementComparator
    implements Comparator {
        ComponentTypeElementComparator() {
        }

        public int compare(Object thisObject, Object thatObject) {
            if (thisObject instanceof Element) {
                Element thisElement = (Element)thisObject;
                if (thatObject instanceof Element) {
                    Element thatElement = (Element)thatObject;
                    String thatSuperID = this.getElementSuperID(thatElement);
                    String thisSuperID = this.getElementSuperID(thisElement);
                    String thatID = this.getElementID(thatElement);
                    String thisID = this.getElementID(thisElement);
                    if (thisSuperID != null && thisSuperID.equals(thatID)) {
                        return 1;
                    }
                    if (thatSuperID != null && thatSuperID.equals(thisID)) {
                        return -1;
                    }
                    return 0;
                }
            }
            return 0;
        }

        private String getElementSuperID(Element componentTypeElement) {
            return componentTypeElement.getAttributeValue("SuperComponentType");
        }

        private String getElementID(Element componentTypeElement) {
            return componentTypeElement.getAttributeValue("Name");
        }
    }
}

