/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule;

import com.metamatrix.common.extensionmodule.exception.InvalidExtensionModuleTypeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ExtensionModuleTypes {
    public static final String JAR_FILE_TYPE = "JAR File";
    public static final String METADATA_KEYWORD_TYPE = "Metadata Keyword";
    public static final String METAMODEL_EXTENSION_TYPE = "Metamodel Extension";
    public static final String FUNCTION_DEFINITION_TYPE = "Function Definition";
    public static final String CONFIGURATION_MODEL_TYPE = "Configuration Model";
    public static final String VDB_FILE_TYPE = "VDB File";
    public static final String MISC_FILE_TYPE = "Miscellaneous Type";
    static final Collection ALL_TYPES;

    public static boolean isValidType(String typeName) {
        return ALL_TYPES.contains(typeName);
    }

    public static void checkTypeIsValid(String typeName) throws InvalidExtensionModuleTypeException {
        if (!ExtensionModuleTypes.isValidType(typeName)) {
            throw new InvalidExtensionModuleTypeException(typeName);
        }
    }

    static {
        ArrayList<String> types = new ArrayList<String>(5);
        types.add(JAR_FILE_TYPE);
        types.add(METADATA_KEYWORD_TYPE);
        types.add(METAMODEL_EXTENSION_TYPE);
        types.add(FUNCTION_DEFINITION_TYPE);
        types.add(CONFIGURATION_MODEL_TYPE);
        types.add(VDB_FILE_TYPE);
        types.add(MISC_FILE_TYPE);
        ALL_TYPES = Collections.unmodifiableList(types);
    }
}

