/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.object;

import com.metamatrix.common.object.DefaultPropertyAccessPolicy;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertiedObjectImpl;
import com.metamatrix.common.object.PropertyAccessPolicy;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.transaction.UserTransactionFactory;
import com.metamatrix.common.transaction.manager.SimpleUserTransactionFactory;
import com.metamatrix.common.util.I18nArgCheck;
import com.metamatrix.core.util.Assertion;
import java.util.List;

public class PropertiedObjectEditorImpl
implements PropertiedObjectEditor {
    private PropertyAccessPolicy policy;
    private UserTransactionFactory txnFactory;

    public PropertiedObjectEditorImpl(PropertyAccessPolicy policy, UserTransactionFactory txnFactory) {
        I18nArgCheck.isNotNull(policy, "ERR.003.019.0015");
        I18nArgCheck.isNotNull(txnFactory, "ERR.003.019.0016");
        this.policy = policy;
        this.txnFactory = txnFactory;
    }

    public PropertiedObjectEditorImpl() {
        this(new DefaultPropertyAccessPolicy(), new SimpleUserTransactionFactory());
    }

    public PropertiedObjectEditorImpl(PropertyAccessPolicy policy) {
        this(policy, new SimpleUserTransactionFactory());
    }

    public PropertiedObjectEditorImpl(UserTransactionFactory txnFactory) {
        this(new DefaultPropertyAccessPolicy(), txnFactory);
    }

    protected PropertiedObjectImpl assertPropertiedObject(PropertiedObject obj) {
        I18nArgCheck.isTrue(obj instanceof PropertiedObjectImpl, "ERR.003.019.0017");
        return (PropertiedObjectImpl)obj;
    }

    public List getPropertyDefinitions(PropertiedObject obj) {
        PropertiedObjectImpl descriptor = this.assertPropertiedObject(obj);
        return descriptor.getPropertyDefinitions();
    }

    public List getAllowedValues(PropertiedObject obj, PropertyDefinition def) {
        I18nArgCheck.isNotNull(def, "ERR.003.019.0018");
        return def.getAllowedValues();
    }

    public Object getValue(PropertiedObject obj, PropertyDefinition def) {
        PropertiedObjectImpl propObj = this.assertPropertiedObject(obj);
        I18nArgCheck.isNotNull(def, "ERR.003.019.0018");
        return propObj.getValue(def);
    }

    public boolean isValidValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        PropertiedObjectImpl propObj = this.assertPropertiedObject(obj);
        I18nArgCheck.isNotNull(def, "ERR.003.019.0018");
        if (def.getMultiplicity().getMaximum() > 1) {
            Assertion.assertTrue((boolean)(value instanceof Object[]), (String)("The property definition " + def.getDisplayName() + " is multi-valued, so the property value must be an Object[]"));
        }
        return propObj.isValidValue(def, value);
    }

    public void setValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        PropertiedObjectImpl propObj = this.assertPropertiedObject(obj);
        I18nArgCheck.isNotNull(def, "ERR.003.019.0018");
        if (def.getMultiplicity().getMaximum() > 1) {
            Assertion.assertTrue((boolean)(value instanceof Object[]), (String)("The property definition " + def.getDisplayName() + " is multi-valued, so the property value must be an Object[]"));
        }
        propObj.setValue(def, value);
    }

    public PropertyAccessPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(PropertyAccessPolicy policy) {
        this.policy = policy == null ? new DefaultPropertyAccessPolicy() : policy;
    }

    public boolean isReadOnly(PropertiedObject obj) {
        return this.policy.isReadOnly(obj);
    }

    public boolean isReadOnly(PropertiedObject obj, PropertyDefinition def) {
        I18nArgCheck.isNotNull(obj, "ERR.003.019.0019");
        I18nArgCheck.isNotNull(def, "ERR.003.019.0018");
        return this.policy.isReadOnly(obj, def);
    }

    public void setReadOnly(PropertiedObject obj, PropertyDefinition def, boolean readOnly) {
        I18nArgCheck.isNotNull(obj, "ERR.003.019.0019");
        I18nArgCheck.isNotNull(def, "ERR.003.019.0018");
        this.policy.setReadOnly(obj, def, readOnly);
    }

    public void setReadOnly(PropertiedObject obj, boolean readOnly) {
        I18nArgCheck.isNotNull(obj, "ERR.003.019.0019");
        this.policy.setReadOnly(obj, readOnly);
    }

    public void reset(PropertiedObject obj) {
        I18nArgCheck.isNotNull(obj, "ERR.003.019.0019");
        this.assertPropertiedObject(obj);
        this.policy.reset(obj);
    }

    public UserTransaction createReadTransaction() {
        return this.txnFactory.createReadTransaction();
    }

    public UserTransaction createWriteTransaction() {
        return this.txnFactory.createWriteTransaction();
    }

    public UserTransaction createWriteTransaction(Object source) {
        return this.txnFactory.createWriteTransaction(source);
    }
}

